package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Enumeration;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.comm.Common;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.ui.base.IFormModel;
import com.ibm.ulc.ui.base.IFormModelListener;
public class UIMenu extends UIComponent implements IMenuComponent, IFormModelListener {
	protected JMenu fMenu = null;
	protected boolean fVisible = true;
	protected String fFormAttributeName = null;
	protected Object fFormAttributeValue = null;
	protected IFormModel fFormModel = null;
	protected Vector fContents = new Vector();
	protected UIMenu fMenuFoldedInto = null;
	protected boolean fMenuBarMenu = false;
	protected String fMenuLabel = null;
	protected boolean fActive = false;
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void add(UIComponent component) {
	insert(component, fContents.size());
}
public void add(Component c) {
	if (fMenu != null)
		fMenu.add(c);
	forceParentRepaint();
}
public void checkForInvalidFormValueUpdate() {
}
/*
 * The receiver has been added to or removed from a menubar. Configure  the receiver
 * according to <code>isMenuBarMenu</code>.
 *
 * @param isMenuBarMenu indicates whether the receiver should be configured as a menubar
 *                      item, or not
 */
public void configureAsMenuBarItem(boolean isMenuBarMenu) {
	if (fMenuBarMenu != isMenuBarMenu) {
		fMenuBarMenu = isMenuBarMenu;
		if (isDynamic()) {
			if (isMenuBarMenu) {
				fFormModel.addModelListener(fFormAttributeName, this);
			}
			else {
				fFormModel.removeModelListener(this);
			}
		}
		Enumeration enum = fContents.elements();
		while (enum.hasMoreElements()) {
			((IMenuComponent) enum.nextElement()).configureAsMenuBarItem(isMenuBarMenu);
		}
	}
}
public void free() {
	if (fMenu != null) {
		fMenu.getPopupMenu().removeAll();
		fMenu.removeAll();
		fMenu = null;
	}
	fContents.removeAllElements();
	super.free();
}
public Component getComponent() {
	return fMenu;
}
/*
 * based on <code>index</code> figure out the real index into the receiver's <code>JMenu</code>.
 * The calculation takes into account the potential dynamic configuration of the receiver. I.e.
 * if the reciever is dynamic (when it has a FormModel specified), it does not create its own
 * popup menu, but instead inserts its contents into its parent menu.
 *
 * @param index the index to adjust for any dynamic elements in the receiver's <code>fPopupMenu</code>
 */
private int getRealIndex(int index) {
	int answer = index;
	if ((fFormModel != null) && (fContents.size() > 0)) {
		if (fFormAttributeValue != null) {
			JPopupMenu popup = ((JMenu) getComponent()).getPopupMenu();
			Component[] menuComponents = popup.getComponents();
			UIComponent uiComp = (UIComponent) fContents.elementAt(0);
			Component firstItem = uiComp.getComponent();
			int startIndex = -1;
			for (int i = 0; i < menuComponents.length; i++) {
				if (firstItem == menuComponents[i]) {
					startIndex = i;
					break;
				}
			}
			answer = startIndex + index;
		}
	} else {
		for (int i = 0; i < index; i++) {
			if (fContents.elementAt(i) instanceof UIMenu) {
				if (((UIMenu) fContents.elementAt(i)).isDynamic()) {
					answer = answer - 1 + ((UIMenu) fContents.elementAt(i)).fContents.size();
				}
			}
		}
	}
	return answer;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setMnemonic")) {
		setMnemonic(args.asInt(-1));
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Inserts the <code>component</code> as a child of the receiver at the specified index.
 *
 * @param managed 		the UIComponent widget that is being added as a child
 * @param index 		the Index at which the widget should be added
 */
public void insert(UIComponent managed, int index) {
	int realIndex = getRealIndex(index);
	if (managed != null && !fContents.contains(managed)) {
		fContents.insertElementAt(managed, index);
		if (fActive && fVisible)
			 ((IMenuComponent) managed).insertIn(this, (JMenu) getComponent(), fMenuBarMenu, realIndex);
	}
	//prepareForPopup();
	forceParentRepaint();
}
/**
 * The receiver is expected to insert itself in both the UIMenu and its associated JMenu.
 * if <code>isMenuBarItem</code> is true, the receiver is expected to configure itself properly as
 * such. <code>index</code> indicates at which offset into <code>jmenu</code> the receiver is to be inserted.
 *
 * @param menu		the UIMenu into which the receiver is to be inserted
 * @param jmenu		the physical JMenu into which the receiver's compoennt is to be inserted
 * @param isMenuBarItem indicates whether <code>menu</code> is a menubar menu
 * @param index		the index at which the receiver is to be inserted into <code>menu</menu>
 *
 */
public void insertIn(UIMenu menu, JMenu jmenu, boolean isMenuBarMenu, int index) {
	if (isDynamic()) {
		if ((fMenu != null) && (fMenu != jmenu)) {
			fMenu.getPopupMenu().removeAll();
			fMenu.removeAll();
		}
		fMenuFoldedInto = menu;
		fMenu = jmenu;
		if (fActive) {
			for (int i = 0; i < fContents.size(); i++) {
				((IMenuComponent) fContents.elementAt(i)).insertIn(this, jmenu, isMenuBarMenu, (i + index));
			}
		}
	}
	else {
		fMenuFoldedInto = null;
		if (fMenu == null) {
		}
		jmenu.insert((JMenu) getComponent(), index);
	}
	configureAsMenuBarItem(isMenuBarMenu);
}
/**
 * The receiver is expected to insert itself in the UIMenuBar at the <code>index</code> specified.
 *
 * @param menuBar	the UIMenuBar into which the receiver is to be inserted
 * @param index		the index at which the receiver is to be inserted into <code>menu</menu>
 *
 */
public void insertIn(UIMenuBar menuBar, int index) {
	fMenuFoldedInto = null;
	if (fMenu == null) {
		fMenu = new JMenu(fMenuLabel);
		rebuildPopupMenu();
	}
	configureAsMenuBarItem(true);
	prepareForPopup();
}
/*
 * answer true, if the receiver is a dynamically configured menu. This is given if the receiver's <code>fFromModel</code>
 * is specified
 */
protected boolean isDynamic() {
	return (fFormModel != null);
}
/*
 * the <code>attributeName</code> of receiver's <code>fFormModel</code> has been changed. prepare 
 * the popupMenu accordingly. The change listener is only installed if the receiver is a menuBar
 * menu. In this case the menu is updated with every change of the model
 *
 * @param changeType		the kind of change that has taken place in <code>fFormModel</code>
 * @param attributeName		the attribute that has changed
 */
public void notify(int changeType, String attributeName) {
	prepareForPopup();
}
/*
 * The receiver prepares its <code>JPopupMenu</code> for display. If the receiver is a dynamic menu,
 * its visibility is set according to the value of the <code>fFormModel</code>'s attribute.
 *
 */
public void prepareForPopup() {
	boolean active = fActive;
	setActive();
	Enumeration enum = fContents.elements();
	while (enum.hasMoreElements()) {
		((IMenuComponent) enum.nextElement()).prepareForPopup();
	}
	if (active != fActive) {
		rebuildPopupMenu();
	}
}
private void rebuildPopupMenu() {
	if (fMenuFoldedInto == null) {
		if (fMenu != null) {
			fMenu.getPopupMenu().removeAll();
			fMenu.removeAll();
			rebuildPopupMenu(fMenu);
		}
	}
	else {
		fMenuFoldedInto.rebuildPopupMenu();
	}
}
public void rebuildPopupMenu(JMenu menu) {
	if (!fActive || !fVisible)
		return;
	Enumeration enum = fContents.elements();
	while (enum.hasMoreElements()) {
		try {
			IMenuComponent item = (IMenuComponent) enum.nextElement();
			if (item instanceof UIMenu) {
				UIMenu childMenu = (UIMenu) item;
				if (childMenu.isDynamic()) {
					childMenu.rebuildPopupMenu(menu);
				}
				else {
					if (fActive && fVisible & childMenu.fVisible)
						menu.add(childMenu.getComponent());
				}
			}
			else {
				if (fActive && fVisible)
					item.rebuildPopupMenu(menu);
			}
		}
		catch (ClassCastException c) {
		}
	}
}
/**
 * Remove the  <code>UIComponent</code> from the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void remove(UIComponent component) {
	int index = fContents.indexOf(component);
	if (fContents.removeElement(component)) {
		((IMenuComponent) component).removeFrom(this, (JMenu) getComponent(), index);
		super.remove(component);
	}
}
/**
 * Needs special treatment since the parent of a
 * menuItem is not JMenu but a JPopupMenu. So a
 * simple remove(c) does not work.
 */
public void remove(Component c) {
	if (fMenu != null) {
		if (c instanceof JMenuItem) {
			JMenuItem item = (JMenuItem) c;
			fMenu.remove(item);
		}
		else {
			fMenu.remove(c);
		}
		// removing and adding items to a popupMenu leads to items overlaying each other in Swing,
		// we work around this bug by rebuilding the entire menu whenever an item is removed
		rebuildPopupMenu();
		forceParentRepaint();
	}
}
/**
 * The receiver is expected to remove itself from @jmenu (the associated menu of @menu).
 * @index indicates at which offset into @jmenu the receiver currently is.
 */
public void removeFrom(UIMenu menu, JMenu jmenu, int index) {
	if (isDynamic()) {
		fMenuFoldedInto = null;
		fMenu = null;
		for (int i = 0; i < fContents.size(); i++) {
			((IMenuComponent) fContents.elementAt(i)).removeFrom(menu, jmenu, i + index);
		}
	} else {
		if (jmenu != null)
			jmenu.remove((JMenuItem) getComponent());
	}
	configureAsMenuBarItem(false);
}
/**
 * reset fMenu to null before removing the items. when all items in list have been removed, 
 * rebuild the receiver's menu.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param list		the <code>Anything</code> containing the list of children
 */
public void removeMany(ORBConnection conn, Anything list) {
	if (list != null) {
		JMenu menu = fMenu;
		fMenu = null;
		super.removeMany(conn, list);
		fMenu = menu;
		rebuildPopupMenu();
		forceParentRepaint();
	}
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	String label = args.get("label", "Menu");
	UiLabelAndMnemonic u = internalParseLabelForMnemonic(label);
	label = u.fLabel;
	fMenu = new JMenu(label) {
		public JToolTip createToolTip() {
			return new UiJMultiLineToolTip();
		}
	};
	if (args.isDefined("formModel")) {
		fFormAttributeName = new String(args.get("key", null));
		if (args.isDefined("value")) {
			fFormAttributeValue = Common.convertFromAnything(args.get("value"));
		}
		setFormModel(conn, (Anything) args.get("formModel"));
	}
	setActive();
	if (u.fMnemonic != null)
		setMnemonic(u.fMnemonic.charValue());
	if (args.isDefined("mnemonic"))
		setMnemonic(args.get("mnemonic", -1));
	super.restoreState(conn, args);
	fMenuLabel = fMenu.getText();
}
/*
 * Update the receiver's active flag. Set the flag to true, if no formModel is defined.
 * Set the flag to true if the formModel's value for the receiver's attributeName is 
 * the same as the receiver's formValue. Set the flag to false, if the formModel's value
 * for the receiver's attributeName is not the same as the receiver's formValue.
 *
 */
private void setActive() {
	if (fFormModel != null) {
		Object formValue = fFormModel.getValueAt(fFormAttributeName);
		if (formValue != null && fFormAttributeValue != null) {
			fActive = formValue.equals(fFormAttributeValue);
		}
		else
			fActive = (fFormAttributeValue == null);
	}
	else
		fActive = true;
}
/**
 * Set the FormModel for the receiver from the given
 * arguments.
 */
private void setFormModel(ORBConnection conn, Anything args) {
	fFormModel = (IFormModel) getManaged(UIStandardFormModel.class, conn, args);
	setActive();
}
public void setLabel(String label) {
	if (fMenu != null)
		fMenu.setText(label);
	forceParentRepaint();
}
private void setMnemonic(int keyCode) {
	if ((keyCode != -1) && (fMenu != null))
		fMenu.setMnemonic((char)keyCode);
}
/**
 * Set the foreground of all selected items in the receiver 
 * to the color defined by the RGB int values <code>red, green,
 * and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */

public void setSelectionForegroundColor(int red, int green, int blue, boolean refresh) {
	Color color = null;
	JComponent c = (JComponent) getBasicComponent();
	if (c != null) {
		if (red == -1 || green == -1 || blue == -1) {
			color = UIManager.getColor("Menu.pressedForeground");
		}
		else {
			color = new Color(red, green, blue);
		}
		c.setForeground(color);
		if (refresh)
			refreshComponentColor(c);
	}
}
/*
 * The receiver should set the visiblity of the specified menuComponent to aBoolean.
 *
 */
public void setVisible(IMenuComponent menuComponent, boolean aBoolean) {
	rebuildPopupMenu();
}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	if (fVisible != visible) {
		fVisible = visible;
		if (getProxyParent() instanceof UIMenuBar)
			 ((UIMenuBar) getProxyParent()).setVisible(this, visible);
		else {
			if (getProxyParent() != null) {
				((UIMenu) getProxyParent()).setVisible(this, visible);
			}
			else {
				rebuildPopupMenu();
			}
		}
	}
}
}
