package com.ibm.ulc.ui;

import java.awt.Component;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.BevelBorder;

/**
 * My instances mark mandatory widgets with a particular border.
 */
public class UIMandatoryInputBorderStyle extends UIMandatoryInputStyle {
	protected Border fHighLightBorder = null;

	/** the key to store the component's "border" property
	 */
	protected static final String BORDER = "border";
/**
 * Get the border that highlights that the widget needs more input.
 *
 * @return Border
 */
protected Border getHighLightBorder() {
	if (fHighLightBorder == null) {
		fHighLightBorder = new BevelBorder(BevelBorder.LOWERED, getHighLightColor(), null, null, getHighLightColor());
	}
	return fHighLightBorder;
}
/**
 * Perform any processing necessary for the initialization of the component
 *
 */
protected void initializeForComponent(UIComponent component) {
	setPropertyValue(component, BORDER, ((JComponent) component.getBorderComponent()).getBorder());
}
/**
 * Change the border (and save the old one) to show that more input is (not) needed.
 *
 * @param boolean 		needsInput	true if more input is needed, false otherwise
 * @param UIComponent	component	The owning widget 
 */
public void mark(boolean needsInput, UIComponent component) {
	if (getBooleanPropertyValue(component, NEEDS_INPUT) != needsInput) {
		Border newBorder = null;
		if (needsInput)
			newBorder = getHighLightBorder();
		else
			newBorder = (Border) getPropertyValue(component, BORDER);
		Border oldBorder = swapBorderWith(component, newBorder);
		setPropertyValue(component, BORDER, oldBorder);
		setBooleanPropertyValue(component, NEEDS_INPUT, needsInput);
	}
}
/**
 * Set the attributes used to display the mandatory character again,
 * in order to trigger a refresh of the user interface.
 */
void refreshNeedsMoreInputAttributes(boolean needsMoreInput, UIComponent component) {
	Component comp = component.getBorderComponent();
	if (comp instanceof JComponent) {
		JComponent jComp = (JComponent) comp;
		jComp.setBorder(jComp.getBorder());
	}
}
	
/**
 * Set the border that highlights that the widget needs more input.
 */
protected void setHighLightBorder(Border border) {
	fHighLightBorder = border;
}
/**
 * Force the border to be rebuilt to take the new colors.
 *
 */
protected void setHighLightColor(Color color) {
	super.setHighLightColor(color);
	setHighLightBorder(null);
}
/**
 * Set the border of the component to newBorder and 
 * answer the old border object.
 *
 * @param	UIComponent component	The INeedsMoreInput UIComponent
 * @param	Border		newBorder	The new border
 * @return	Border					The old border
 */
public Border swapBorderWith(UIComponent component, Border newBorder) {
	Component comp = component.getBorderComponent();
	if (comp instanceof JComponent) {
		JComponent jComp = (JComponent) comp;
		Border b = jComp.getBorder();
		jComp.setBorder(newBorder);
		comp.repaint();
		return b;
	} else {
		return null;
	}
}
}
