package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997-1999 Object Technology International Inc.
 */
import java.util.*;
import java.awt.Component;
import java.awt.Color;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.Assert;
import com.ibm.ulc.util.Anything;
/**
 * The instances of this class are used to give a visible feedback
 * for widgets requiring user input.
 * To that extent, the instances have to configured as follows:
 * 1. the fEnabler field refers to a widget W that possibly requires user input
 * 2. the instance is added as enable listener to the EnableListener
 *    that makes further input unnecessary (e.g. W itself)
 */

public class UIMandatoryAndEnabler extends UIAndEnabler {
	/**
	 * The object used to specify how the mandatory input is displayed on the widget.
	 */
	protected UIMandatoryInputStyle fMandatoryStyle = null;
/**
 * This method was created in VisualAge.
 */
public UIMandatoryAndEnabler() {
	super();
}
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void add(IEnableListener component) {
	if (component instanceof UIComponent) {
		fMandatoryStyle.initializeForComponent((UIComponent) component);
		// we need this hack because colors are set in a runnable in UIComponent.
		//so we ensure that this code runs at least once after the view has been built.
		final Component c = ((UIComponent) component).getBasicComponent();
		markNeedsMoreInput();
	
		DeferredRequest r = new DeferredRequest(fConnection) {
			public void safeDispatch() {
				refreshNeedsMoreInputAttributes();
			}
		};
		fConnection.postRequest(r);
	}
	super.add(component);
}
/**
 * Mark all components that need more input.
 *
 */
public void markNeedsMoreInput() {
	Enumeration e = fSourceComponents.elements();
	while (e.hasMoreElements()) {
		IEnableListener c = (IEnableListener) e.nextElement();
		if (c instanceof UIComponent) {
			if (((UIComponent) c).isEnabled())
				fMandatoryStyle.mark(!c.shouldEnableListener(), (UIComponent) c);
			else
				fMandatoryStyle.mark(false, (UIComponent) c);
		}
	}
}
/**
 * Set the attributes used to display the mandatory character again,
 * in order to trigger a refresh of the user interface.
 */
public void refreshNeedsMoreInputAttributes() {
	Enumeration e = fSourceComponents.elements();
	while (e.hasMoreElements()) {
		IEnableListener c = (IEnableListener) e.nextElement();
		if (c instanceof UIComponent) {
			if (((UIComponent) c).isEnabled())
				fMandatoryStyle.refreshNeedsMoreInputAttributes(!c.shouldEnableListener(), (UIComponent) c);
			else
				fMandatoryStyle.refreshNeedsMoreInputAttributes(false, (UIComponent) c);
		}
	}
}	
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	setMandatoryStyle(args.get("style", MANDATORY_STYLE_BACKGROUND));
	Anything b = args.get("bc");
	if (b != null) {
		fMandatoryStyle.setHighLightColor(new Color(b.get("r", 0), b.get("g", 255), b.get("b", 255)));
	}
	super.restoreState(conn, args);
}
/**
 * Mark component as needing more input or not, according to hasEnough.
 *
 * @param	component	IEnableListenerTarget	the compoent to be marked
 * @param	state	boolean
 *
 */
public void setEnabled(boolean state) {
	markNeedsMoreInput();
	super.setEnabled(state);
}
/**
 * Set whether the mandatory property has to be shown 
 * by background color or by border.
 */
void setMandatoryStyle(int typeCode) {
	fMandatoryStyle = UIMandatoryInputStyle.forType(typeCode);
}
}
