package com.ibm.ulc.ui;

/**
 * This type was created in VisualAge.
 */
import java.awt.*;
import java.util.Enumeration;
import javax.swing.*;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
public class UILookAndFeel extends UlcObject implements ILookAndFeel {
/**
 * Creates a UILookAndFeel for the specified UI instance and causes the L&F
 * to be set based on the current L&F specified in the UI instance.
 * If the UI instance does not specify the L&F then the system L&F is set.
 */
public UILookAndFeel(String look) {
	String lookName = look;
	if (lookName == null)
		lookName = UIManager.getSystemLookAndFeelClassName();
	try {
		UIManager.setLookAndFeel(lookName);
		temporaryFixes(lookName);
	} catch (ClassNotFoundException e) {
		System.out.println("UILookAndFeel(" + lookName + "): ClassNotFoundException");
	} catch (InstantiationException e) {
		System.out.println("UILookAndFeel(" + lookName + "): InstantiationException");
	} catch (IllegalAccessException e) {
		System.out.println("UILookAndFeel(" + lookName + "): IllegalAccessException");
	} catch (UnsupportedLookAndFeelException e) {
		System.out.println("UILookAndFeel(" + lookName + "): UnsupportedLookAndFeelException");
	}
}
/**
 * Sends a list of available look & feel classes to the ULCContext proxy
 * on the specified connection.
 */
public void getInstalledLookAndFeels(ORBConnection conn) {
	UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
	Anything args = new Anything();
	for (int i = 0; i < lafInfo.length; i++) {
		Anything lafDescription = new Anything();
		lafDescription.put("name", lafInfo[i].getName());
		lafDescription.put("className", lafInfo[i].getClassName());
		args.append(lafDescription);
	}
	conn.send(Common.FACTORY_ID, "getInstalledLookAndFeels", args);
}
/**
 * Returns the current L&F of the UI registered in the specified connection.
 */
public void getLook(ORBConnection conn) {
	Anything a= new Anything();
	a.put("name", UIManager.getLookAndFeel().getName());
	a.put("className", UIManager.getLookAndFeel().getClass().getName());
	conn.send(Common.FACTORY_ID, "getLook", a);
}
/**
 * Sets the look and feel for the ULCShells registered in the connection.
 */
public void setLook(ORBConnection conn, String lookAndFeelClassName) {
	try {
		UIManager.setLookAndFeel(lookAndFeelClassName);
		temporaryFixes(lookAndFeelClassName);
		Registry r = conn.getRegistry();
		if (r != null) {
			Enumeration c = r.getRegistry().elements();
			while (c.hasMoreElements()) {
				try {
					UIShell s = (UIShell) c.nextElement();
					Frame f = s.getFrame();
					if (f != null)
						SwingUtilities.updateComponentTreeUI(f);
				} catch (ClassCastException e) {
					//System.out.println("UILookAndFeel.setLook: ClassCastException");
				}
			}
		}
	} catch (ClassNotFoundException e) {
		System.out.println("UILookAndFeel.setLook: ClassNotFoundException");
	} catch (InstantiationException e) {
		System.out.println("UILookAndFeel.setLook: InstantiationException");
	} catch (IllegalAccessException e) {
		System.out.println("UILookAndFeel.setLook: IllegalAccessException");
	} catch (UnsupportedLookAndFeelException e) {
		System.out.println("UILookAndFeel.setLook: UnsupportedLookAndFeelException");
	}
}
private void temporaryFixes(String lookName) {
	if (lookName.indexOf("Windows") >= 0) {
		UIManager.getDefaults().put("ScrollBar.track", new javax.swing.plaf.ColorUIResource(224, 224, 224));
	}
}
}
