package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.*;

public class UIHtmlPane extends UIComponent implements HyperlinkListener, PropertyChangeListener {
	protected boolean fEditable= false;
	protected JEditorPane fEditorPane= null;
	protected JPanel fPanel= null;
	protected boolean fVeto= false;
	protected int fWaitCursorCount= 0;
	protected Cursor fCurrentCursor= null;
	static public Cursor fgWaitCursor= Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
JEditorPane createHtmlPane() {
	fPanel = new UiJPanel();
	fPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
	fPanel.setLayout(new BorderLayout());
	fPanel.getAccessibleContext().setAccessibleName("HTML panel");
	fPanel.getAccessibleContext().setAccessibleDescription("A panel for viewing HTML documents, and following their links");
	JEditorPane html = null;
	html = new JEditorPane() {
		public JToolTip createToolTip() {
			return new UiJMultiLineToolTip();
		}
	};
	html.setEditable(fEditable);
	html.addHyperlinkListener(this);
	html.addPropertyChangeListener(this);	// WARNING: Somehow registering for "page" doesn't work
	JScrollPane scroller = new UiJScrollPane();
	scroller.setBorder(new SoftBevelBorder(BevelBorder.LOWERED));
	JViewport vp = scroller.getViewport();
	vp.add(html);
	vp.setBackingStoreEnabled(true);
	fPanel.add(scroller, BorderLayout.CENTER);
	return html;
}
	public Component getComponent() {
		return fPanel;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setPage")) {
		setPage(args.asString("???"));
		return;
	}
	if (request.equals("setVeto")) {
		setVeto(args.asBoolean(false));
		return;
	}
	if (request.equals("setHtmlPageContents")) {
		try {
			setHtmlPageContents(args.asString(""));
		} catch (Exception e) {
			e.printStackTrace();
		};
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Notification of a change relative to a 
 * hyperlink.
 */
public void hyperlinkUpdate(HyperlinkEvent e) {
	if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
		linkActivated(e.getURL());
	}
}
/**
 * Follows the reference in a hyperlink. 
 * The given url is the requested reference.
 * By default this calls <a href="#loadPage">loadPage</a>, if fVeto is not true.
 * A linkActivated event is sent whenever a link is selected by the User
 * to ULC which should call setPage if veto is true to activate the selected link.
 *
 * @param u the URL to follow
 */
protected void linkActivated(URL u) {
	Cursor c= fEditorPane.getCursor();
	Anything a = new Anything();
	a.put("url", new Anything(u.toString()));
	if (!fVeto) {
		setPage(u);
		sendOptionalEventULC("la", a);
	}
	else
		sendEventULC("la", a);
}
/*
 * Important:	This method method might display a NullPointerException
 *				in the console. This is due to a Swing bug in JEditorPane,
 *				which catches and prints (but not throws) this exception.
 */
protected synchronized void loadPage(URL url) throws IOException {
	fCurrentCursor= fEditorPane.getCursor();
	if (!fEditorPane.getCursor().equals(fgWaitCursor) || fCurrentCursor == null)
		fCurrentCursor= fEditorPane.getCursor();
	fEditorPane.setCursor(fgWaitCursor);
	fWaitCursorCount += 1;
	try {
		/*
		 * Important: Two paths are possible from here,
		 * depending on the actual document that will be shown:
		 *   a) the document may specify to be loaded synchronously
		 *   b) the document may specify to be loaded asynchronously
		 * For this reason the cursor is reseted to normal if the
		 * property change event is received and in case of an
		 * exception.
		 */
		fEditorPane.setPage(url);
	} catch (IOException e) {
		fPanel.getToolkit().beep();
		fEditorPane.setText(e.toString());
		restoreCursor();
		throw e;
	}	
}
/**
 * @deprecated	As of ULC R3.1, use loadPage(URL) instead
 * @see			#loadPage(URL)
 */
protected synchronized void loadPage(URL url, Cursor c) throws Exception {
	loadPage(url, null);
}
/**
 * This method gets called when a bound property is changed.
 * @param evt A PropertyChangeEvent object describing the event source 
 *   	and the property that has changed.
 */
public synchronized void propertyChange(PropertyChangeEvent evt) {
	if (evt.getPropertyName().equalsIgnoreCase("page"))
		restoreCursor();
}
private void restoreCursor() {
	if (fWaitCursorCount > 0)
		fWaitCursorCount -= 1;
	if (fWaitCursorCount == 0 && fEditorPane.getCursor().equals(fgWaitCursor))
		fEditorPane.setCursor(fCurrentCursor);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fEditable = args.get("editable", false);
	fVeto = args.get("veto", fVeto);
	fEditorPane = createHtmlPane();
	super.restoreState(conn, args);
	if (args.isDefined("url"))
		setPage(args.get("url", ""));
}
protected void setHtmlPageContents(String htmlText) throws Exception {
	HTMLEditorKit kit = (HTMLEditorKit) fEditorPane.getEditorKitForContentType("text/html");
	InputStream in = new ByteArrayInputStream(htmlText.getBytes());
	fEditorPane.setContentType("text/html");
	if (kit != null) {
		Document doc = kit.createDefaultDocument();
		doc.putProperty(Document.StreamDescriptionProperty, new URL("http://www.ibm.com"));
		try {
			kit.read(in, doc, 0);
			fEditorPane.setDocument(doc);

		} catch (BadLocationException e) {
			throw new IOException(e.getMessage());
		}
	}
}
protected void setPage(String urlString) {
	URL url= null;
	try {
		url= new URL(urlString);
	}
	catch (MalformedURLException e) {
		fEditorPane.setText(e.toString());
		Anything args= new Anything();
		args.put("url", urlString);
		args.put("error", e.toString());
		sendEventULC("setPageError", args);
		return;
	}
	setPage(url);
}
protected void setPage(URL url) {
	try {
		loadPage(url);
	}
	catch (IOException e) {
		Anything args = new Anything();
		args.put("url", url.toString());
		args.put("error", e.toString());
		sendEventULC("setPageError", args);
	}
}
protected void setVeto(boolean veto) {
	fVeto= veto;
}
}
