package com.ibm.ulc.ui;

import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
public class UIHelpBrowserContext extends UIBrowserContext {
	protected String fHelpRootUrl = null;
/**
 * Returns the root of the help path. This URL is combined with the help Url specified
 * for each UIComponent to form the complete URL path to the help file to be displayed.
 */
public String getHelpUrl() {
	return fHelpUrl;
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	fHelpUrl = args.get("helpUrl", null);
}
}
