package com.ibm.ulc.ui;

import com.ibm.ulc.base.*;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import java.util.zip.*;
public class UIGraphicsPane extends UIComponent implements ComponentListener, MouseMotionListener, MouseListener, IUlcGraphicsDefaults {
	private ByteArrayInputStream fGraphicsBytes = null;
	private DataInputStream fGraphicsBuffer = null;
	private byte fBytes[] = null;
	private Dimension fMin = new Dimension();
	private Dimension fMax = new Dimension();
	private Dimension fPref = new Dimension();
	private Dimension fDimension = null;
	private Dimension fRequestedSize = null;
	private Color fBackgroundColor = null;
	private JPanel fComponent = null;
	private boolean fZoomable = false;
	Point start = null;
	Point end = null;
	protected PrintJob fPendingPrintJob = null;
 public void componentHidden(ComponentEvent e) {
//    System.out.println("componentHidden");
 }   
 public void componentMoved(ComponentEvent e) {
//    System.out.println("componentMoved");
 }   
 public void componentResized(ComponentEvent e) {
	setSize(e.getComponent().getSize());
 }   
 public void componentShown(ComponentEvent e) {
//    System.out.println("componentShown");
 }   
public void drawGraphicBuffer(Graphics g) {
	byte cmd = 0;
	if (fBytes == null)
		return;
	try {
		fGraphicsBytes = new ByteArrayInputStream(fBytes);
		fGraphicsBuffer = new DataInputStream(fGraphicsBytes);
		while (true) {
			int x, y, w, h, dx, dy, a1, a2;
			boolean b;
			cmd = readByte();
			switch (cmd) {
				case ULC_clearRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.clearRect(x, y, w, h);
					break;
				case ULC_clipRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.clipRect(x, y, w, h);
					break;
				case ULC_copyArea :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					dx = readShort();
					dy = readShort();
					g.copyArea(x, y, w, h, dx, dy);
					break;
				case ULC_draw3DRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					b = readBoolean();
					g.draw3DRect(x, y, w, h, b);
					break;
				case ULC_drawArc :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					a1 = readShort();
					a2 = readShort();
					g.drawArc(x, y, w, h, a1, a2);
					break;
				case ULC_drawBytes :
					a1 = readShort();
					a2 = readShort(); 
					byte bytes[] = new byte[a2];
					for (int i = 0; i < a2; i++)
						bytes[i] = readByte();
					x = readShort();
					y = readShort();
					g.drawBytes(bytes, a1, a2, x, y);
					break;
				case ULC_drawChars :
					a1 = readShort();
					a2 = readShort();
					char chars[] = new char[a2];
					for (int i = 0; i < a2; i++)
						chars[i] = (char) readShort();
					x = readShort();
					y = readShort();
					g.drawChars(chars, a1, a2, x, y);
					break;
				case ULC_drawImage :
					x = readShort();
					y = readShort();
					try {
						Image im = Toolkit.getDefaultToolkit().createImage(readBytes());
						MediaTracker tracker = new MediaTracker(new Panel());
						tracker.addImage(im, 0);
						tracker.waitForID(0);
						g.drawImage(im, x, y, null);
					} catch (Exception e) {
						System.out.println(e);
					}
					break;
				case ULC_drawLine :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.drawLine(x, y, w, h);
					break;
				case ULC_drawOval :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.drawOval(x, y, w, h);
					break;
				case ULC_drawPolygon :
					g.drawPolygon((Polygon) readSerializable(new Polygon()));
					break;
				case ULC_drawPolyline :
					Polygon p = (Polygon) readSerializable(new Polygon());
					g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
					break;
				case ULC_drawRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.drawRect(x, y, w, h);
					break;
				case ULC_drawRoundRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					a1 = readShort();
					a2 = readShort();
					g.drawRoundRect(x, y, w, h, a1, a2);
					break;
				case ULC_drawString :
					String str = readString();
					x = readShort();
					y = readShort();
					g.drawString(str, x, y);
					break;
				case ULC_fill3DRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					b = readBoolean();
					g.fill3DRect(x, y, w, h, b);
					break;
				case ULC_fillArc :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					a1 = readShort();
					a2 = readShort();
					g.fillArc(x, y, w, h, a1, a2);
					break;
				case ULC_fillOval :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.fillOval(x, y, w, h);
					break;
				case ULC_fillPolygon :
					g.fillPolygon((Polygon) readSerializable(new Polygon()));
					break;
				case ULC_fillRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.fillRect(x, y, w, h);
					break;
				case ULC_fillRoundRect :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					a1 = readShort();
					a2 = readShort();
					g.fillRoundRect(x, y, w, h, a1, a2);
					break;
				case ULC_setClip :
					x = readShort();
					y = readShort();
					w = readShort();
					h = readShort();
					g.setClip(x, y, w, h);
					break;
				case ULC_setColor :
					g.setColor((Color) readSerializable(new Color(0)));
					break;
				case ULC_setFont :
					g.setFont(new Font(readString(), readShort(), readShort()));
					break;
				case ULC_setPaintMode :
					g.setPaintMode();
					break;
				case ULC_setXORMode :
					g.setXORMode((Color) readSerializable(new Color(0)));
					break;
				case ULC_translate :
					x = readShort();
					y = readShort();
					g.translate(x, y);
					break;
				case ULC_dispose :
					g.dispose();
					g = null;
					break;
				default :
			}
		}
	} catch (EOFException e) { // ok
	} catch (Exception e) {
		System.out.println(e + "in UIGraphicsPane.drawGraphicBuffer");
	}
}
public Component getComponent() {
	return fComponent;
}
public synchronized void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("paint")) {
		Dimension d = new Dimension(args.get("w", 100), args.get("h", 100));
		fBytes = args.get("data").asBytes();
		fComponent.repaint();
		if (d.equals(fRequestedSize)) {
			fRequestedSize = null;
		} else
			if (fRequestedSize != null) {
				sendResized(fRequestedSize);
			}
		return;
	}
	if (request.equals("repaint")) {
		Dimension d = new Dimension(fComponent.getSize());
		if (d != null) {
			sendResized(d);
		}
		return;
	}
	if (request.equals("print")) {
		fBytes = args.get("data").asBytes();
		print(args.get("job", "ULC Print Job"));
		return;
	}
	if (request.equals("startPrintJob")) {
		startPrintJob(args.get("job", "ULC Print Job"));
		return;
	}
	super.handleRequest(conn, request, args);
}
public void mouseClicked(MouseEvent e) {
}
public void mouseDragged(MouseEvent e) {
	if (fZoomable) {
		end = e.getPoint();
		fComponent.repaint();
	}
}
public void mouseEntered(MouseEvent e) {
}
public void mouseExited(MouseEvent e) {
}
public void mouseMoved(MouseEvent e) {
}
public void mousePressed(MouseEvent e) {
	if (fZoomable) {
		start = e.getPoint();
	}
}
public void mouseReleased(MouseEvent e) {
	if (fZoomable) {
		if (end != null) {
			Anything a = new Anything();
			int w = end.x - start.x;
			int h = end.y - start.y;
			if (h > 0) {
				a.put("h", h);
				a.put("y", start.y);
			} else {
				a.put("h", -h);
				a.put("y", end.y);
			}
			if (w > 0) {
				a.put("w", w);
				a.put("x", start.x);
			} else {
				a.put("w", -w);
				a.put("x", end.x);
			}
			sendULC("zoom", a);
			a = new Anything();
			a.put("w", fDimension.width);
			a.put("h", fDimension.height);
			sendULC("resized", a);
		}
		fComponent.repaint();
		start = null;
		end = null;
	}
}
/**
 * Send the contents of the current graphic buffer to the Printer.
 */
public void print(String printJobName) {
	if (fPendingPrintJob != null) {
		Graphics printPage = fPendingPrintJob.getGraphics();
		if (printPage != null) {
			drawGraphicBuffer(printPage);
			printPage.dispose();
			fPendingPrintJob.end();
			fPendingPrintJob = null;
		}
	} else
		sendULC("printError", new Anything("No active printJob"));
}
boolean readBoolean() throws IOException {
	return fGraphicsBuffer.readByte() == (byte) 1;
}
byte readByte() throws IOException {
	return fGraphicsBuffer.readByte();
}
byte[] readBytes() throws IOException {
	int l = fGraphicsBuffer.readShort();
	byte[] b = new byte[l];
	for (int i = 0; i < l; i++) {
		b[i] = fGraphicsBuffer.readByte();
	}
	return b;
}
int readInt() throws IOException {
	return fGraphicsBuffer.readInt();
}
Serializable readSerializable(Serializable ser) throws IOException {
	try {
		ObjectInputStream ois = new ObjectInputStream(fGraphicsBuffer);
		ser = (Serializable) ois.readObject();
		ois.close();
		return ser;
	} catch (Exception e) {
		System.out.println(e);
	}
	return null;
}
int readShort() throws IOException {
	return (int) fGraphicsBuffer.readShort();
}
String readString() throws IOException {
	int i = fGraphicsBuffer.readShort();
	byte data[] = new byte[i];
	fGraphicsBuffer.read(data);
	return new String(data);
}
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	Dimension d = new Dimension(args.get("w", 100), args.get("h", 100));
	fMin.setSize(d);
	fMax.setSize(d);
	fPref.setSize(d);
	fZoomable = args.get("zoomable", false);
	fComponent = new JPanel() {
		Image bimg = null;
		int count = 0;
		public void paint(Graphics g) {
			if (fBytes != null) {
				bimg = fComponent.createImage(fDimension.width, fDimension.height);
				Graphics buf = bimg.getGraphics();
				if (fBackgroundColor != null) {
					//com.ibm.uvm.tools.DebugSupport.halt();
					buf.setColor(fBackgroundColor);
				}
				buf.fillRect(0, 0, fDimension.width, fDimension.height);
				drawGraphicBuffer(buf);
				fBytes = null;
			}
			if (bimg != null)
				g.drawImage(bimg, 0, 0, fComponent);
			if ((start != null) && (end != null)) {
				int w = end.x - start.x;
				int h = end.y - start.y;
				int x = start.x;
				int y = start.y;
				if (h < 0) {
					h = -h;
					y = end.y;
				}
				if (w < 0) {
					w = -w;
					x = end.x;
				}
				g.drawRect(x, y, w, h);
			}
		}
		public Dimension getMaximumSize() {
			return fMax;
		}
		public Dimension getMinimumSize() {
			return fMin;
		}
		public Dimension getPreferredSize() {
			return fPref;
		}
		public JToolTip createToolTip() {
			return new UiJMultiLineToolTip();
		}
	};
	fComponent.addComponentListener(this);
	fComponent.addMouseListener(this);
	fComponent.addMouseMotionListener(this);
	fComponent.setBackground(fBackgroundColor);
}
public void sendResized(Dimension size) {
	Anything a = new Anything();
	a.put("w", size.width);
	a.put("h", size.height);
	sendULC("resized", a);
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	fBackgroundColor = new Color(red, green, blue);
	super.setBackgroundColor(red, green, blue, refresh);
}
public synchronized void setSize(Dimension d) {
	if (!d.equals(fDimension)) {
		fDimension = d;
		if (fRequestedSize == null) {
			Anything a = new Anything();
			a.put("w", d.width);
			a.put("h", d.height);
			sendULC("resized", a);
		}
		fRequestedSize = d;
	}
}
/**
 * Send a request to the application to print its contents with the specified printerInfo
 */
public void startPrintJob(String printJobName) {
	if (fPendingPrintJob != null)
		fPendingPrintJob.end();
	Toolkit tk = Toolkit.getDefaultToolkit();
	fPendingPrintJob = tk.getPrintJob(null, printJobName, null);
	if (fPendingPrintJob != null) {
		Anything printerInfo = new Anything();
		printerInfo.put("w", new Anything(fPendingPrintJob.getPageDimension().width));
		printerInfo.put("h", new Anything(fPendingPrintJob.getPageDimension().height));
		printerInfo.put("r", new Anything(fPendingPrintJob.getPageResolution()));
		printerInfo.put("job", printJobName);
		sendULC("print", printerInfo);
	} else
		sendULC("printError", new Anything("Error creating Print Job or Print Job cancelled"));
}
}
