package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import java.io.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.UIProxy;

public class UIFont extends UIProxy {
	protected Font fFont = null;
	public UIFont() {
	}
	public void free() {
		fFont= null;
		super.free();
	}
	public Font getFont() {
		return fFont;
	}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	fFont = new Font(args.get("nm", "Dialog"), args.get("st", Font.PLAIN), args.get("s", 10));
}
public void setFont(Font font) {
	fFont = font;
}
}
