package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import java.util.*;

public class UIBox extends UIComponent {
	protected JPanel fPanel = null;
	protected int fHGap = 3, fVGap = 2;
	protected UIButtonGroup fButtonGroup = null;
public void add(ORBConnection conn, Anything args) {
	if (fPanel != null) {
		UIComponent ic = (UIComponent) getManaged(UIComponent.class, conn, args.get("c"));
		if (ic != null) {
			internalAddToChildren(ic);
			Component comp = ic.getComponent();
			if (comp != null) {
				fPanel.add(comp);
				GridBagLayout gbl = (GridBagLayout) fPanel.getLayout();
				GridBagConstraints con = Attr.createConstraints(args);
				if (con.gridx > 0)
					con.insets.left = fHGap;
				if (con.gridy > 0)
					con.insets.top = fVGap;
				gbl.setConstraints(comp, con);
				if (fButtonGroup != null)
					fButtonGroup.add(ic);
			}
		}
	}
}
protected void addComponentsToButtonGroup(UIButtonGroup bg) {
	if (bg != null) {
		Enumeration e = fList.elements();
		while (e.hasMoreElements()) {
			UIComponent c = (UIComponent) e.nextElement();
			bg.add(c);
		}
	}
}
public void free() {
	if (fPanel != null) {
		fPanel.removeAll();
		fPanel = null;
	}
	if (fButtonGroup != null) {
		fButtonGroup.free();
		fButtonGroup = null;
	}
	super.free();
}
	public Component getComponent() {
	    return fPanel;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setRadioGroup")) {
		setRadioGroup(args.asBoolean(false));
		return;
	}
	if (request.equals("setHGap")) {
		setHGap(args.asInt(fHGap));
		return;
	}
	if (request.equals("setVGap")) {
		setVGap(args.asInt(fVGap));
		return;
	}
	if (request.equals("setMargin")) {
		setMargin(args.asInt(0));
		return;
	}
	if (request.equals("add") || request.equals("addMany") || request.equals("remove") || request.equals("removeMany")) {
		super.handleRequest(conn, request, args);
		forceParentRepaint();
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Remove the  <code>UIComponent</code> from the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void remove(UIComponent component) {
	if (fPanel != null) {
		internalRemoveFromChildren(component);
		Component comp = component.getComponent();
		if (comp != null) {
			fPanel.remove(comp);
		}
	}
}
protected void removeComponentsFromButtonGroup(UIButtonGroup bg) {
	if (bg != null) {
		Enumeration e = getChildren().elements();
		while (e.hasMoreElements()) {
			UIComponent c = (UIComponent) e.nextElement();
			bg.remove(c);
		}
	}
}
void resetGap(int hgap, int vgap) {
	Component comps[] = ((JPanel) getComponent()).getComponents();
	GridBagLayout gbl = (GridBagLayout) ((JPanel) getComponent()).getLayout();
	for (int i = 0; i < comps.length; i++) {
		GridBagConstraints con = gbl.getConstraints(comps[i]);
		if (con.gridx > 0)
			con.insets.left = hgap;
		if (con.gridy > 0)
			con.insets.top = vgap;
		gbl.setConstraints(comps[i], con);
	}
	forceFrameRepaint();
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fHGap = args.get("hg", 3);
	fVGap = args.get("vg", 3);
	fPanel = new UiJPanel(new GridBagLayout(), getUI().getDoubleBuffering());
	fPanel.setOpaque(false);
	setMargin(args.get("m", 0));
	setRadioGroup(args.get("group", false));
	super.restoreState(conn, args);
}
/**
 * Set the background of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setBackgroundColor(int red, int green, int blue, boolean refresh) {
	setBackgroundColorWithOpaque(red, green, blue, refresh);
}
/**
 * Set the foreground of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setForegroundColor(int red, int green, int blue, boolean refresh) {
	setForegroundColorWithOpaque(red, green, blue, refresh);
}
void setHGap(int hgap) {
	if (fHGap != hgap) {
		fHGap = hgap;
		resetGap(fHGap, fVGap);
	}
}
	void setMargin(int margin) {
		if (margin > 0 || fPanel.getBorder() != null)
			fPanel.setBorder(new EmptyBorder(margin, margin, margin, margin));
	}
void setRadioGroup(boolean b) {
	if (b) {
		if (fButtonGroup != null)
			removeComponentsFromButtonGroup(fButtonGroup);
		fButtonGroup = new UIButtonGroup();
		addComponentsToButtonGroup(fButtonGroup);
	} else {
		if (fButtonGroup != null)
			removeComponentsFromButtonGroup(fButtonGroup);
		fButtonGroup = null;
	}
}
void setVGap(int vgap) {
	if (fVGap != vgap) {
		fVGap = vgap;
		resetGap(fHGap, fVGap);
	}
}
}
