package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;


public class UIBorder extends UIComponent {
	protected JPanel fBorder= null;
public void add(Component c) {
	fBorder.add(c);
}
	public void free() {
		if (fBorder != null) {
			fBorder.setBorder(null);
			fBorder= null;
		}	
		super.free();
	}
	public Component getComponent() {
	    return fBorder;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setMargin")) {
		setMargin(args.asInt(0));
		return;
	}
	if (request.equals("setFont")) {
		setFont((UIFont) getManaged(UIFont.class, conn, args, false));
		return;
	}
	if (request.equals("add")) {
		add(conn, args);
		fBorder.revalidate();
		fBorder.repaint();
		return;
	}
	if (request.equals("remove")) {
		remove(conn, args);
		fBorder.revalidate();
		fBorder.repaint();
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Remove the  <code>Component</code> from the border.
 *
 * @param component : A <code>Component</code>
 */
public void remove(Component component) {
	fBorder.remove(component);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	String title = args.get("label", "");
	fBorder = new UiJPanel(getUI().getDoubleBuffering());
	fBorder.setLayout(new UiBorderLayout(args.get("m", 5), args.get("a", "ee")));
	TitledBorder tb = BorderFactory.createTitledBorder(title);
	UIFont font = (UIFont) getManaged(UIFont.class, conn, args.get("font"));
	if (font != null)
		tb.setTitleFont(font.getFont());
	fBorder.setBorder(tb);
	super.restoreState(conn, args);
}
public void setFont(UIFont font) {
	if (fBorder != null) {
		Border b = fBorder.getBorder();
		if (b instanceof TitledBorder) {
			TitledBorder tb = (TitledBorder) b;
			if (font == null)
				tb.setTitleFont(null);
			else
				tb.setTitleFont(font.getFont());
			fBorder.repaint();
		}
	}
}
/**
 * Set the foreground of the receiver to the color defined
 * by the RGB int values <code>red, green, and blue</code>. 
 * <br>Update the UI if <code>refresh</code> is true
 * <br>If any of the color values are -1, set the code to
 * the LookAndFeel default.
 * 
 * @param red int the red value of the RGB value
 * @param green int the red value of the RGB value
 * @param blue int the blue value of the RGB value
 * @param refresh boolean indicate whether to refresh the UI after
 * the change
 */
public void setForegroundColor(int red, int green, int blue, boolean refresh) {
	JPanel p = (JPanel) getBasicComponent();
	TitledBorder c = (TitledBorder) p.getBorder();
	if (c != null) {
		Color color = null;
		if (areValidRGBColorValues(red, green, blue)) {
			color = new Color(red, green, blue);
		}
		c.setTitleColor(color);
		if (refresh)
			refreshComponentColor(p);
	};
}
	public void setLabel(String text) {
		if (text != null && fBorder != null) {
			Border b= fBorder.getBorder();
			if (b instanceof TitledBorder) {
				TitledBorder tb= (TitledBorder) b;
				tb.setTitle(text);
				fBorder.repaint();
			}	
		}	
	}
void setMargin(int margin) {
	LayoutManager layout = fBorder.getLayout();
	if (layout instanceof UiBorderLayout) {
		UiBorderLayout l = (UiBorderLayout) layout;
		l.setMargin(margin);
		layout.layoutContainer(fBorder);
	}
}
}
