package com.ibm.ulc.ui;

import com.ibm.ulc.util.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.ibm.ulc.comm.*;
public class UIBlockInputTrigger extends UITrigger {
	protected int fMode = TRIGGER_ALL_SHELLS;
	protected int fTriggerOn = TRIGGER_ON_ACTION;
	protected boolean fAutoReset = true;
	/*
	 * The last widget that triggerred this trigger is stored to allow its parent to be found
	 */
	protected UIProxy fUIProxy = null;
public UIBlockInputTrigger() {
	super();
}
private UIShell getShell() {
	UIProxy proxy = fUIProxy.getProxyParent();
	while ((proxy != null) && !(proxy instanceof UIShell)) {
		proxy = proxy.getProxyParent();
	}
	if (proxy instanceof UIShell)
		return ((UIShell) proxy);
	else
		return null;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request write a message out on the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setMode")) {
		setMode(args.asInt(fMode));
		return;
	}
	if (request.equals("setTriggerOn")) {
		setTriggerOn(args.asInt(fTriggerOn));
		return;
	}
	if (request.equals("setAutoReset")) {
		fAutoReset = args.asBoolean(fAutoReset);
		return;
	}
	super.handleRequest(conn, request, args);
}
/*
 * Under JDK1.2 the mouse cursor is not being reset unless the mouse is moved
 * Simulate a bogus mouse event to reset the cursor.
 * This is supposedly fixed in JDK1.3
 */
private void postMouseEvent(UIShell shell) {
	MouseEvent event = new MouseEvent(shell.getBasicComponent(), MouseEvent.MOUSE_ENTERED, new Date().getTime(), 0, 100, 100, 1, false);
	Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
}
public void reset(ORBConnection conn, Anything args) {
	setGlassPaneVisible(false);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	if (args.isDefined("mode"))
		fMode = args.get("mode").asInt(TRIGGER_ALL_SHELLS);
	if (args.isDefined("triggerOn"))
		fTriggerOn = args.get("triggerOn").asInt(TRIGGER_ON_ACTION);
	if (args.isDefined("autoReset"))
		fAutoReset = args.get("autoReset").asBoolean(fAutoReset);
	super.restoreState(conn, args);
}
private void setGlassPaneVisible(boolean visible) {
	Cursor cursor = null;
	if (visible)
		cursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
	if (fMode == TRIGGER_SHELL) {
		UIShell shell = getShell();
		if (shell != null) {
			shell.setGlassPaneVisible(visible);
			shell.getGlassPane().setCursor(cursor);
			postMouseEvent(shell);
		}
		return;
	}
	if (fMode == TRIGGER_ALL_SHELLS) {
		UIShell shell = getShell();
		if (shell != null) {
			Vector proxies = shell.getProxyParent().getChildren();
			for (int i = 0; i < proxies.size(); i++) {
				Object proxy = proxies.elementAt(i);
				try {
					shell = (UIShell) proxy;
					shell.setGlassPaneVisible(visible);
					shell.getGlassPane().setCursor(cursor);
					postMouseEvent(shell);
				} catch (Exception e) {
				}
			}
			return;
		}
	}
}
/**
 * Sets the mode of this trigger.
 * Either block input on all shells within the UI or the owning widgets shell.
 *
 * @return mode  One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>TRIGGER_ALL_SHELLS</code> (the default),
 *           <code>TRIGGER_SHELL</code>
 *
 */
public void setMode(int mode) {
	fMode = mode;
}
/**
 * Sets when this trigger is activated
 *
 * @param triggerOn  One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>TRIGGER_ON_ACTION</code> (the default),
 *           <code>TRIGGER_ON_SELECTION</code>,
 *           <code>TRIGGER_ON_ACTION_AND_SELECTION</code>.
 *
 */
public void setTriggerOn(int triggerOn) {
	fTriggerOn = triggerOn;
}
public void trigger(ORBConnection conn, int triggerOn, UIProxy sourceWidget, Object userData) {
	fUIProxy = sourceWidget;
	if ((fTriggerOn == TRIGGER_ON_ACTION_AND_SELECTION) || 
		(fTriggerOn == triggerOn) || 
		(triggerOn == TRIGGER_ON_ACTION_AND_SELECTION)) {
		setGlassPaneVisible(true);
		if (fAutoReset)
			sendEventULC("triggered");
	}
}
}
