package com.ibm.ulc.ui;

import java.util.*;
import java.awt.Component;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.Assert;
public class UIAndEnabler extends UIEnabler {
	protected Vector fSourceComponents = new Vector();
/**
 * UIAndEnabler constructor comment.
 */
public UIAndEnabler() {
	super();
}
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void add(IEnableListener component) {
	fSourceComponents.addElement(component);
	if (component instanceof IEnableListener)
		 ((IEnableListener) component).addEnableListener(this);
}
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void add(UIProxy component) {
	add((IEnableListener) component);
	setEnabled(true); // the actual state is ignored and recalculated this will force a refresh
}
public void free() {
	fSourceComponents.removeAllElements();
	super.free();
}
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void remove(IEnableListener component) {
	fSourceComponents.removeElement(component);
	if (component instanceof IEnableListener)
		 ((IEnableListener) component).removeEnableListener(this);
}
/**
 * Add the  <code>UIComponent</code> to the receiver's list of children.
 *
 * @param component : A <code>UIComponent</code>
 */
public void remove(UIProxy component) {
	remove((IEnableListener) component);
	setEnabled(true); // the actual state is ignored and recalculated this will force a refresh
}
/**
 * Return true if the component for which I am an enabler should be enabled.
 * If the enable listener is a DISABLED widget then its input is IGNOERD
 *
 */
public boolean shouldEnableListener() {
	boolean state= true;
	boolean componentEnabled= true;
	Enumeration enum= fSourceComponents.elements();
	while (enum.hasMoreElements()) {
		IEnableListener c = (IEnableListener) enum.nextElement();
		if (c instanceof UIComponent)
			componentEnabled= ((UIComponent) c).isEnabled();
		if (c != this && componentEnabled && !c.shouldEnableListener()) {
			state = false;
			break;
		}
	}
	return state;
}
}
