package com.ibm.ulc.ui;

/**
 * UIProxies which should serve as reconnect token
 * strategy must implement this interface.
 * Note: Strategies implemented on the server are
 *       not required/forced to consult the UI and
 *       therefore not all strategies might have a
 *       corresponding UI implementation.
 *
 * @since	R3.1
 */
public interface IReconnectTokenStrategy {
/**
 * This method returns a token which will be reused when
 * the client reconnects to the server (if client reconnection
 * is allowed).
 *
 * Normally this method should first identify the user (e.g.
 * by asking for name and password) and then encrypt these
 * values with the help of the <code>challenge</code>.
 *
 * @param	challenge	The <code>String</code> that can be used to encrypt the answer.
 * @return	The encrypted token as <code>String</code>
 * @since	R3.1
 */
String getToken(String challenge);
}
