package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997,1999 Object Technology International Inc.
 */
import java.awt.Component;
/**
 */
public class CachedResourceUpdate extends Object {
	protected Object fComponent = null;
	protected String fMethodName = null;
	protected Object fUserData = null;
/**
 * This method was created in VisualAge.
 */
public CachedResourceUpdate(Object component, String methodName) {
	fComponent = component;
	fMethodName = methodName;
}
/**
 * This method was created in VisualAge.
 */
public CachedResourceUpdate(Object component, String methodName, Object userData) {
	fComponent = component;
	fMethodName = methodName;
	fUserData = userData;
}
/**
 * This method was created in VisualAge.
 */
public boolean defines(UIProxy component, String methodName, Object userData) {
	if (component.equals(fComponent)) {
		if (methodName.equals(fMethodName)) {
			if (fUserData == null) {
				return (userData == fUserData);
			} else {
				if (userData == null) {
					return false;
				} else {
					return (fUserData.equals(userData));
				}
			}
		}
	}
	return false;
}
/**
 * This method was created in VisualAge.
 */
public boolean sameAs(CachedResourceUpdate update) {
	if (fComponent instanceof UIProxy)
		return update.defines((UIProxy) fComponent, fMethodName, fUserData);
	else
		return false;
}
/**
 * This method was created in VisualAge.
 */
public void updateWith(ICachedResource resource) {
	if (fComponent instanceof UIProxy)
		 ((UIProxy) fComponent).updateCachedResource(fMethodName, resource, fUserData);
	else
		if (fComponent instanceof Component)
			 ((Component) fComponent).repaint();
}
}
