package com.ibm.ulc.testsample;

import java.util.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.test.cases.UlxSimplePerson;
/**
 * Insert the type's description here.
 * Creation date: (12/21/99 2:13:21 PM)
 * @author: Stefan Bosshard, OTI
 */
public class UlxSampleTreeTableModel extends ULCTreeTableModel {
	protected UlxBusinessController fController;
/**
 * UlxTreeTableModel constructor comment.
 */
public UlxSampleTreeTableModel() {
	super();
}
/**
 * UlxTreeTableModel constructor comment.
 * @param prefetchCount int
 */
public UlxSampleTreeTableModel(int prefetchCount) {
	super(prefetchCount);
}
/**
 * UlxTreeTableModel constructor comment.
 */
public UlxSampleTreeTableModel(UlxBusinessController controller) {
	super();
	fController = controller;
}
/**
 * getParent method comment.
 */
public UlxBusinessController getBO() {
	return fController;
}
/**
 * getChildCount method comment.
 */
public int getChildCount(Object userObject) {
	return getChildren(userObject).size();
}
/**
 * getChildren method comment.
 */
public Vector getChildren(Object parent) {
	if (parent == null)
		return new Vector();
	else
		return ((UlxSimplePerson) parent).getChildren();
}
/**
 * getParent method comment.
 */
public Object getParent(Object node) {
	return ((UlxSimplePerson) node).getParent();
}
/**
 * getRoot method comment.
 */
public Object getRoot() {
	return getBO().getFounder();
}
/**
 * Implementing the ULCTreeModel API:
 * Answer the value of the specified attribute of the given object
 * in the tree.
 *
 * @param columnId		: 	The columnIdentifier for a column in the tree,
 * 							which typically represents one attribute of this
 *							userObject.
 *
 * @param userObject	: 	The object being represented as a node
 *							in the tree.
 */
public Object getValue(String columnId, Object userObject) {
	UlxSimplePerson person = (UlxSimplePerson) userObject;
	if (columnId.equals("LastName"))
		return person.getLastName();
	if (columnId.equals("FirstName"))
		return person.getFirstName();
	if (columnId.equals("FirstAndLastName"))
		return person.getFirstName() + "-" + person.getLastName();
	return columnId; // Useful for testing random column-addition
}
public void setValue(String columnId, Object newValue, Object userObject) {
	UlxSimplePerson person = (UlxSimplePerson) userObject;
	if (columnId.equals("LastName"))
		person.setLastName((String) newValue);
	if (columnId.equals("FirstName"))
		person.setFirstName((String) newValue);
}
}
