package com.ibm.ulc.testsample;

import java.util.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.test.cases.UlxSimplePerson;
//
public class UlxBusinessController {
	//The widgets which get notified by the receiver
	protected ULCAbstractTableModel[] fListeners;
	//The data source for the receiver
	protected UlxData fData;
/**
 * UlxBusinessController constructor comment.
 */
public UlxBusinessController() {
	super();
	initialize();
}
public void addListener(ULCAbstractTableModel listener) {
	ULCAbstractTableModel[] newListenerList = new ULCAbstractTableModel[fListeners.length + 1];
	if (fListeners.length > 0)
		System.arraycopy(fListeners, 0, newListenerList, 0, fListeners.length);
	fListeners = newListenerList;
	fListeners[fListeners.length - 1] = listener;
}
public void addPerson(String firstName, String lastName, UlxSimplePerson parent, int childIndex) {
	UlxSimplePerson person = fData.newPerson(firstName, lastName, parent, childIndex);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyAdd(person);
	}
}
/**
 * Add multiple persons of the given name. For this, append an integer to the given name.
 * Use the childIndex as the position to start inserting at.
 */
public void addPersons(String firstName, String lastName, UlxSimplePerson parent, int childIndex, int howMany) {
	UlxSimplePerson[] persons = fData.newPersons(firstName, lastName, parent, childIndex, howMany);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyAdd(persons);
	}
}
public void deletePerson(UlxSimplePerson person) {
	fData.deletePerson(person);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyDelete(person);
	}
}
public void deletePersons(Vector persons) {
	fData.deletePersons(persons);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyDelete(persons.toArray());
	}
}
public UlxSimplePerson getCoFounder() {
	return fData.getCoFounder();
}
public UlxSimplePerson getFounder() {
	return fData.getFounder();
}
public ULCAbstractTableModel[] getListeners() {
	return fListeners;
}
public int getNumberOfPersons() {
	return fData.getNumberOfPersons();
}
public UlxSimplePerson getPersonAt(int row) {
	return fData.getPersonAt(row);
}
public void initialize() {
	fListeners = new ULCAbstractTableModel[0];
	fData = new UlxData();
}
public void refresh(UlxSimplePerson person, String newFirstName, String newLastName) {
	person.setFirstName(newFirstName);
	person.setLastName(newLastName);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyChange(person);
	}
}
public void removeListener(ULCAbstractTableModel listener) {
	int index = -1;
	for (int i = 0; i < fListeners.length; i++) {
		if (fListeners[i] == listener) {
			index = i;
			break;
		}
	}
	if (index > -1) {
		ULCAbstractTableModel[] newList = new ULCAbstractTableModel[fListeners.length - 1];
		System.arraycopy(fListeners, 0, newList, 0, index - 1);
		System.arraycopy(fListeners, index + 1, newList, index, newList.length);
		fListeners = newList;
	}
}
public void setFirstName(UlxSimplePerson person, String newFirstName) {
	person.setFirstName(newFirstName);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyChange("FirstName", person);
	}
}
public void setLastName(UlxSimplePerson person, String newLastName) {
	person.setLastName(newLastName);
	for (int i = 0; i < getListeners().length; i++) {
		ULCAbstractTableModel listener = getListeners()[i];
		listener.notifyChange("LastName", person);
	}
}
}
