package com.ibm.ulc.test;

import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.testsample.UlxBusinessController;
//import com.ibm.ulc.varun.*;
/**
 * This type was created in VisualAge.
 */
public class UlxViewTestRunner extends UlxViewAbstractComposite implements IActionListener {
	private UlxTestRun fTestRun = null;
	private UlxWindowTestSuite fWindow = null;
	private UlxTestSuite fTestSuite = null;
	private UlxAbstractTestComposite fTestComposite = null;
	private ULCBox ivjHorizontalBox = null;
	private ULCLabel ivjStateIcon = null;
	private ULCLabel ivjStatusLine = null;
	private ULCBox ivjVerticalBox = null;
	private ULCBox ivjComponentBox = null;
	private ULCButton ivjRunButton = null;
/**
 * UlxViewTestRunner constructor comment.
 */
public UlxViewTestRunner() {
	super();
	initialize();
}
/**
 * UlxViewTestRunner constructor comment.
 * @param vajContext com.ibm.ulc.varun.ULCVajContext
 */
public UlxViewTestRunner(ULCVajContext vajContext) {
	super(vajContext);
	initialize();
}
public void aboutToRun(boolean visibly) {
	fTestRun = null;
	getStateIcon().setLabel("READY");
	getStateIcon().setIcon(getSystem().getGreenBall());
	getStatusLine().setLabel("");
	if (getTestComponent() != null)
		getTestComponent().aboutToRun(visibly);
}
/**
 * Method to handle events for the IActionListener interface.
 * @param actionEvent com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(ULCActionEvent actionEvent) {
	// user code begin {1}
	// user code end
	if ((actionEvent.getSource() == getRunButton()) ) {
		connEtoC1(actionEvent);
	}
	// user code begin {2}
	// user code end
}
/**
 * connEtoC1:  (RunButton.actionPerformed.actionPerformed(com.ibm.ulc.application.ULCActionEvent) --> UlxViewTestRunner.run()V)
 * @param arg1 com.ibm.ulc.application.ULCActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(ULCActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.run();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * 
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private static void getBuilderData() {
/*V1.1
**start of data**
	D0CB838494G88G88GEC14CDA7GGGGGGGGGGGG8CGGGE2F5E9ECE4E5F2A0E4E1F4E134BB8BF0D4D516F1568F3B13D5DC23939DF4B3B3F1E494E73084E5AC2C4D56D8ABBB4B4CD2AEE3D18EBB26AC2B8636D0F117F531169DAF7999A0BFC81088443492487F8781E208109F90C2B08DB4A1368924537D1234F63A1B6E57A18981761CFB5FF97D727AF587C4D2F56A75B977F36EBD77FC6FFBE1F905F1296B137298DB1F4A143F036B99DBF804B14F835EB5C4CBB7D91319666FD3004D6C135E94
	F866C35B2A8B56649CD651118EF8856033G5F863FF3D9ED0763B07C884327915A1A4F7F716711797CA21D78FC48F15916814FAC009A20D9101F8979C75B72957A9860D94AEF0475C90CB5FD0AFD9EAD4D57509315FEF950D682301877F942266FB3836833G6681EC60AB7B6539FA25FD59DDB14C715ABDE91948C7B30EA06FB34123DEF9B2E6CBC3A1A433391F144033517C6D50E13BE7244AB9B0D295F0592BE449AFB7B41CF30DF5BB254B96C04E845CEE49B77BB3DC5BEFCA5379D8463C00576DC25A21B214
	47AA40D3G5F390B56F84C52282CA17E690759CB1BB2120C56B8E7F4FB5258AE3136D93B02EBDC71F86CFA4173F7B66239FC97716CA9C61EF9C556648A0036A2229716A03D97F099A03A085672A82335C4BFB00BA5D6BF17EA34162878792971C5E28D0B0A02EBB17F6131140F79596F5F08E713329B4E8B2091209FA08AA08EE08757395569E570EC9E10DBBDA3A39EF733575B62F278CEF99C128BFEB7B4C00BC2BBA359BDBE87E3C22F9615D6981C9F41025DD3F58AC16C6DBCA3DDA8CA08E50B7A3312D28D76
	3620ABABE931B2C7626E605EF276205CFE454F10416F750A2C857D571CEE5150AB0A115E4C6908BB20ED519E12736AEFE9ADB589773335775C17762141DAB25EFAB64DDBAC56B023B83896A1636C8C1471BC20AF81D88140CA2C49A600269212F14306FD53497804DB16FCEE1B6BECE040EB7349AD81274BA17994D93FE28BA76B5E12D0B9E72972D84C754EDB2217532B1C9ED522175305E21253CCE8DB83A07ABF40753427D4BF4F231CBEDC2A1FE7F7894DB386ED4B81042C2EE5222C1A4A2C493DGB2C0B440
	9C00C5E5A42B3BB6D443731C4B9EC6D65022504C9AB9093107B7FE84CFE9CC7659CE387D324DED173AEDBE27ED40A57919526778C614694014F11D5CCE6C406338844E43A6BBBDEE185DB6A2412178C51FF39BB7E39F1F44DBAD4E9170B53691AF23F97BB6664253E5734B673C8E1BAC85FB08F6E9A36A5C282D9BE6048960F7FEB94A6AF56E23D6407ED34AC9CE0FE7A12D97F0391C641238F18BBCCF0212C82E0606B6279D17E1730D13BD4EAFC33FBF231CF47B6D9E526D46129F314E2CDF996A76CE3033748A
	21C3260A20EE0BB97F014F59DEC13164F8D9CF841B3F91407505EB93BC7AEF19C7F204B6A11B597B34BEA8E645AF8DE533AC714534E1C5A6D195FA3B6F48C19D0F837AC2006595F4CEBBB619983775961BDFA26B6E720132C90E6029093E799959282F2312DBEE133C125B81BF7C0A3E94E6EC886A7220C755335D1C0EBE2295144D2F524BB3B68BBA4C21358CEA5F475BED326CF38E84E4692CA44BCE77D0F07CA13E967F947763D7F4F4A50FE9EBE00F9915248B2F9423EE542878F20E875B9D45B7F30EB84F4D
	1C3160F17526F8C4520B70BC9EAEC9D1F4C360BF6338D95DE7F9C90F016EFCDFA0F834F19EB73B7E9B85F17E77E4065745FBB30DF5B1A653D8979F490C2CEBBF4DB452B551760BCC74F3F68FE4F15CD854E6A6724037AD38E6275BA91FF7BA06A4792CF3C282BB2CC4BDFD0F7B52B1789DDDC9FE7072AE32755E75B1ECC6CE26E13E5136633934B7959DDCDB9934F53126A7335056A517B482C2E975845C32204F65FEDA217B13B96D5573E8F3269248C3DB82326CF1D75878BE4C12EF50639B119CD5BA3CC41B4E
	5A3CDE17534EC3CC55394E56E65E75A89ECA2929327230A9A4512D70855CA5255D25B50C893F74D71BF12D79D510EB8234D511DF2A4846F60A9F0AC3EA7538DCC24C5036308AE5383AACCFA3175EAAD1B34C2E2258F447961CBF259AF2E7000AEA1ADF4A4E554C5F6971FC9B70DAB072AA67EA4E4941B317AE85A4884B58F0D29AD7E26B791CAD3A36EE1BAB900C5997F3B641532519D32989ECC8777A1CA360D251693159553887B6202DC91A0006B54EA4BCE78208F37A1D95778972B421C0CDA8D11390E9CC8D
	4E3134E427B2FEB50CC987DAC50D18A72AC649CBF93F4CB24A772BD5DA91277DCF9AE3C7D3A9661C4A5156C06D7B0C75104724DA25862A55471CF939B8EF8F5007EBC96E2F65E8655E6C77FB6CCE2EBF0A6C7EFA33D6C795FB5E3C911E03CE1F9F72CE07B4265A73E6DCAB66B08AD91173D365DF30507C752843A9FBFC9462DAAFF3B535F8DAA10DEA0723EAD5CD98858C63C5FD74D6A549EB3216ECF4E51736766A0FF9B2ED1301EC923F5A1EB4CF1149D20DEC22215ED1FC5896E3BB7D5BAD68333FD5756D7EAD
	F0B4100B899D93FB5CF0G4FAFF2FD59BC608797E8C7B1F8BDFE27ACA9FB2A9F20BD656D255AEE1B835752893883E0F2AF6D7509AC5A6B72583FE7166A790635DD4644F329B1FB459E976C8D6EF5A95419A2477EBF1EE3635A57C2FB4DBE30D12E7BAFDF536A7EB050E781A4GAC5DC73A6FA8BD0E33FDBFFEC9115F1D35A8D3610DC8676FF7B5A96B189D75G1B756E1C34EC033DA6DCF8A6ED55BE65EE21AE38571E27BFCFF281A8F563DE2D7DB45606371FFEE58E39CEEFBFEFEE45F31A897478BA321FCD391B
	B57683B5AE148DC360E148A6FE1D1BACF4C741DF4CCDA55DE1941F7F33B2D2AD2C0785F564CBBF5D06BEE8B160ABG58FEEBF2BEC07DFEDADBDB5E34F563513188F523E7A0523AFA760766DC222E7BA157DD57FEFD3D77A027CF6E5757FB858E2A772221ED75FE5A5F7D79280B168356E4AF408C00B80084004483344719FC0F916B3D0835F1F248BD443A83D37715FFF0AAAE46ED8E99D725439BF563041E7F233D189978890D01401ABBDBC56CE74B8F72BA792A56A6ADC00B86188B70920070A19FDCC35DC4DD
	AF2AA79F72789EFEBF84388C90DDCFF2FD67E30CCD7100A7GAC83D883107FB90C8368791CE47BFA1E115F1E2ABF611CF630FE90BC2BF7705C8A661E214E5F38B5D3E3BBE60F53AD2BF633F2AB7A830F4FB964F4936DEDCE33FB203F0F6A5F8DD5B8EFAC4CB9CF1D37F4DB78DC34E61BF1AEFAE01BF1AE5A38ADF2DD5436ADDC2EAA56F7B7776D0BE0ED091FD34EFF3F8363C9CA8361BF66F81E0A6FF25CC8DD02633FCB3EAEF8B45E900F6FDAB3A8F9FCFE78F378C93E71B9BC11EFFC8ECF67C7BE07797911EB06
	97730DEA06823E47FF7EA81B4F6D77CBFE2E50EDB65926347DD95E4A8C6A09AFEDA312A21FDC56D03AC169F3D47634562A361E6EAFE5213EC91377C0D30BE72CD5F2391088FD97B4204E7CD1565AFBBD5006812281629A485E7FF0B5DDB9CBF6086CFD4BB53477FA404DG4307A8E7F86AA4658CA99767B1CB19F14E0090F5C868D47CA14DFD703F56A7891DC9390EBEEF5521205E3146606FBC4D6F926537707B9F73FB4146C66177572B744FB83DDDC3977160A96E379037C05B02C6326B77BF8E2FCFEC3B31BE
	25ED473D7ABD811FDD526BCC6676FC35AD6839CE4852889E2F6873919FAF5BFCD0AB6A4797707122AD5C78BD5BA36BE55D8E5C67180A57F3FCDC55A129B9CB65F1546DD01C242893CC5C77BD1A44D8F98A75FF66B2663E03BE5B8830B96B156CEC6E97BC0628B54DCE40EBG4CGDE0019DFD0DEF747DE74C3280EBD07797D2FC32B07EB3F9077B795505684A0783DE1ADE2B7924FBCE3A2164D716BE3D99C4C7592403243245B3901F4E57F2B8F13EE0F85D0A7CA0EGEF001EA3245B162B245BE32573D85C1F0C
	F5BB7A4979295EA3C2A7E30E84F57B4D5F13EE3FF695F5FB99342DBA925E2F3226E01B50613B394D65B569F31D191CDE54244FF5722FD12ED387ED31CD9413F79420DC56811E5F8C6783508EB08CB0231974BFE1C70301BFB14CF5943722CBF914183463BA4AB79E66DD88A0E8BF6034C500AFD7E97F42E92B81475CC6507E4CE9A9AD50270562D5A126B4CADCA9517CFEE64F2D5E45CE9F47FEFBDBF9A86F81F98C47F3AC02BD7736A06D5D816DBD871E27BDD9640022FD17DD5B0EBEGE3C1307D5C14F654659F
	CD99FF4F1476D44DF821777B2D24777D6FBC465619DF887BCEB43EC5F94727BC67188A52E84EE476F2569E831D1A9A230281CA48A3C5A27BE42DE41F0D920FBD001B8106DB49BEDFEE55562BB9470D5FC5764E1E1F9A552A441E5620FD32045875A2A63EAB69E3A266CBAB206F3AD6729BEF7AA9874EEB23F56D11F99D8D3883E0320DF4B6BF204D5FE35AA267D2335B68DD56AA6E079636893B463984FDAD27AF5550053DDF63F444D7C11B79A859FBEDA1FF6F8778920095G6C18B5598450F40C6CBDFB678103
	3389E76FE06B66D0DBFF1767893D47040F973477B84DF5CC78F0C17BDFCE1B845A01B4322D68EB988FE69DA319BD44F13C4B9278A7572633BD9CFBEB76FDF0DA9E37F22FAD64DCD490BE2FA8AFB04EABEA8B0C73540385117354A3851173016385C6F92A084FFB2FE3EC17BD9E17456935401A583CE3788D470F394F95FD9E667EF944AD0142B86D694771EC67F25A63GEB0FD12CFF63BA4AD7F263F528C3997B176B288FAE5B0064C25D64F33F061FCD50BB7B087781C6A0FC40FD9F118FD8E30AE30BFFF81F61
	7D9CC267F121AFAE65D91FADFC153019777877A43320ED8140F200B5G696DE0B76D6AFDE6812E91ABD3F0D84D32EC338F731BCBAAD879BD1CCA4684C96CED03E434373A76297A5B5E2E0F7FF3395F6BED57477F97B85D552E0F7FAD92457FC9E8CBECA7FF70CDB96E2D6D04B5399FE08CE0A640DC00A5A7E8EF3BBFB948EE509F9884FF61A3CB8749F72FBAC1BE725EC11E2BF4D8139B81AC9DE45FAB7DA8939760D19D41FD47F4CC15496C8E3DCC9E61BEF7E107DEA6711C3E38C3AF138A19E4329C5A1ACED27E
	D14D73407813DA5F5541E973CE0AB5AA77E75C47AE82DAA2401A13347E3FF0FAFAA7642C1D629ED3506F8C5CC84E0073985193F574C5A70D6E079E3DA19E9F0621276AF03D0FD33E8BA98C6F371A8B0D7D5671C2E33FF52AB0325FBAD79859EF75959A79AD11E3ECE2D3EB1A89C6B50F40CF8F63BB08E10F4FB961F14BB6D7334BB964C673D47C524F0BF14D6A9BB1C6FE6521A95F0595DDFBB00D6AC83DBC4D1D620CFABB033905187B656B78ACBED32C4C395B2A1DF35E4A1F24053BA71E294C952FBC93F28A14
	FB6226CA4C5D1683FDAD404ED3104F83341DA2BB5ED97A9963BE4A40BF9DF58CE1AD0ADF1F48A45B8FCA431FF3DA59745F2CE417617B1A818F88EF8467A77A56B254BF596365C4C15BDE06F270B90706E551D5211B78BBA917B448494296CDBC8F6C07FDF52711FD6E16A80F68D6730867A44C9B22CE117DA5F09C6BBE0137CBB7134363BCB79303848F5BCD7138591CC24848DF9E7E1CA64A0D6DB12A5C589E6FAE0FEC0F7716C73647074A0D6CD14822EAD09B6BE22711671CD3147BA68D21BFCDB8A57CB75A05
	20E7F27AD28DDD787518C1FA4734825ABA3FA43F4EE44AC90379E72ACCB9E95057EF14C93F76287A15AD076AD71C0C7AB477CB5227A7B90EF764825FAB5F2E9AB1487364ED63114CA837BB9640FD79BC1715EF85EC8164ED773882A3EE4A9147EC62AE52D58B7DEAEB553197AD69023E8F6902F6BDDD216DC51A381F299DB5FA573098761988A07A9C1DB06A33965AB33AA81F692BE22AAE16D46C06E7376D9B43B73F9D36D1DB5740B712DD3658069865FA472BF1EDC5B0DFD39779CDF7C5F938F900E876F93C12
	CF9E97D47E8500423F3DB23CDDF6D5CE6FBFFB78BBE7897C1EE55C2B5C6B75D57277930303FEC975538315B9AA6D045F0C2FF81D9E3708F1A75B50DEC7E101CE3BB6425179BCF181ED25DBE9B7C1BDA7747DA84F577A3B3436524FE95EAEE1ABC27F520710F6A750E23BC8A7F3B9EDCE1738BF9634C7863FCFBDC5FE5C07A8CF4163596F15877962D48D1E4B5E5F0F3F5B551C81A5C677934ED13A87D852C5B96ED323BC97B4C32DGD0EF26BB032B93F40FEEB6D35F97A6306F8C4063G9618C97FBA2B11276AF3
	050AA9E7FF369AE3BEFED76434391C937C6673ACF4F48F0975768ECE355D4B0321367B0ABFDDE33B02F6A420216DD56CEF48688EF5892C73CDB31D33FB94FD7CBA40F3CE877DFB5169293E3E7E34BEF7AF3C4C6FCBCE6BF377D2CE6FBD2D4F5D1F99255C5D85EDCBCE937F9FCCA07F3AB3566476B36163CB6F99BD7F2AAB7C1B63B3FA7E751C9EF5C64FBFE1C27D66985A561CD14FF508F42067AC1DEBE0987B4E84FCB6C042D90AC7F70D065E117C4DE8E8BC3AEF14625181B59E450C0646235D17712C171DA5D9
	D4F3FC350ABFBFBA1DFD60586FEAAF024712E9F95C4A3D09587B439321F2FBEC02647621CA7B59C4280C6A2E70F71E961249E10ED72878BFCD5C0C8F41F9EEDEC62F5F940F6F767DE77DB05A01995667502CF1CC375EE80B5E8ED6F2DD0D33686D603FB8FD2EC5EF87D706498E92202D689C5D73649E455C7F2CEC13837ECE279B7C15784E277F3256074C007ED8A7AF046792F5EC34E303B2D6BAE167F517986B39229F0B75758AF82EBBC7B655B59C2A9B1661D01B7AEAB8340638B09C2AAF6F8CF3FD69A67DF8
	1F6395AAFE47702D469C1CBB72D9BEF24BBCA269104893BE5E037771533ECF6B9417F4425745DE266F474C5D646B7EEE1C47B04063G96F413DFFC620A9A9B553E7FB149E363F9080DG7567697CE7A4A11DFF2D6606DC85A22C380BAFF36A6F62B147B043B847F9BA0F64719B3DAB1CBC2FFDD71C467D794C737AF745591CBE6B3C7EDDF16CB83DAB1E8DED99BD44FF4E95646F6DB1BE53BB95FAACBC6774E879DF384AEB1C9EBD7FA1CEDF5C23673FFA1278AF0336462FC84E83CE3AE70B7B0A647C5BCB58F799
	602B81522DE4AB5B47312F8970BAAB2DBFE30229FA37D5737B31715B7FCE6D795B4AC36C79B7DC8F1B2CC2760276A7CEB3834D214A26F812FFB784F82CCA3BBCC9721A234A4BF1B5A823914D6F77A6EF3F3C322F5EFE9EC3CE2DBDAD30C60EF70B2DD4339F76214EA5DA75F1241D53D7DB75F1E449A50AA36CEBB8072F4997540E073E9BD8D9439865632F71786D04B0A1707F3E026B9EF57A1D783D35F88F11B1C9FEEA11BA6F6149F0F7FFE2CC4FA4792BE5B0C670BD351729BAF30D5B595A2F35B1E556A52425
	77EA6B23B69F2EEFE7AF694B179C2FD371D7AFCDF706B876564E701DE9F95CCACEA66439EB9277A57B821240BDDC3EA75A24C1DB40A57B2BDA3AFAAE1EB9F13C5D22740F3DB435AEF976D2E8DDF2FDC0FB27004297F548F51F3E8E41F85C83F2F275129FFC5EC767F7E7AF794177396EAD84FCA940AA758C967AD047D37A404E7B02322E681BAA7726BEFD2EB462677F3759277759231C5E5F2777599F7848E73B20EDC99F7915FF730566AC4BFC21B94B3F7BC2F316B7FC21B98B3F4ED3FECFEAFE277AEF3F3F78
	643672907FEF3E585A824FB9EF31D419E51E8938CD723053EF42CF5EE5168C384C72AACD2D819F5EE11A701B6FD127BCEE2A14D9D625496D11F9CF49E12A247B7CADAE6D5DFB4F030F043DFB2F39A8F4206D227E9B6D2DFDF88ED1C01FF5D17D5F12DEE091767E696C084D65824F73ED335B01F7D1AD6332943CC75D5E07737B290F52A85ABE6D43F5FF2399737F83GD0CB878855AF51FBFE95GG64BFGGD0CB818294G94G88G88GEC14CDA755AF51FBFE95GG64BFGG8CGGGGGGGGGGG
	GGGGGGE2F5E9ECE4E5F2A0E4E1F4E1D0CB8586GGGG81G81GBAGGG3895GGGG
**end of data**/
}
/**
 * Return the ComponentBox property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBox getComponentBox() {
	if (ivjComponentBox == null) {
		try {
			ivjComponentBox = new com.ibm.ulc.application.ULCBox(1, 1);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjComponentBox;
}
public UlxBusinessController getController() {
	if (fTestSuite == null)
		return new UlxBusinessController();
	else
		return fTestSuite.getController();
}
public int getDataScope() {
	if (fTestSuite == null)
		return UlxTestData.DATA_NORMAL;
	else
		return fTestSuite.getDataScope();
}
/**
 * Return the Horizontal Box property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBox getHorizontalBox() {
	if (ivjHorizontalBox == null) {
		try {
			ivjHorizontalBox = new com.ibm.ulc.application.ULCBox(1, 3);
			ivjHorizontalBox.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getStatusLine());
			ivjHorizontalBox.add(2, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getStateIcon());
			ivjHorizontalBox.add(1, 0, com.ibm.ulc.base.IDefaults.BOX_CENTER_CENTER, getRunButton());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjHorizontalBox;
}
/**
 * Return the RunButton property value.
 * @return com.ibm.ulc.application.ULCButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCButton getRunButton() {
	if (ivjRunButton == null) {
		try {
			ivjRunButton = new com.ibm.ulc.application.ULCButton("Run");
			ivjRunButton.setToolTipText("Run this test");
			ivjRunButton.setMnemonic('R');
			ivjRunButton.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjRunButton;
}
/**
 * Return the StateIcon property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCLabel getStateIcon() {
	if (ivjStateIcon == null) {
		try {
			ivjStateIcon = new com.ibm.ulc.application.ULCLabel("- not tested -");
			ivjStateIcon.setVisible(true);
			ivjStateIcon.setHorizontalAlignment(IDefaults.BOX_RIGHT);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjStateIcon;
}
/**
 * Return the StatusLine property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCLabel getStatusLine() {
	if (ivjStatusLine == null) {
		try {
			ivjStatusLine = new com.ibm.ulc.application.ULCLabel("- Current Activity -");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjStatusLine;
}
public UlxAbstractTestComposite getTestComponent() {
	return fTestComposite;
}
public UlxTestData getTestData() {
	if (fTestSuite == null)
		return new UlxTestData();
	else
		return fTestSuite.getTestData();
}
public String getTestName() {
	if (fTestComposite == null)
		return "N/A";
	else
		return fTestComposite.getName();
}
UlxTestRun getTestRun(UlxAbstractTestComposite composite) {
	if (fTestRun.getComposite() == composite)
		return fTestRun;
	else {
		testStarted(composite, composite.getName());
		return getTestRun(composite);
	}
}
/**
 * Return the Vertical Box property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBox getVerticalBox() {
	if (ivjVerticalBox == null) {
		try {
			ivjVerticalBox = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjVerticalBox.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getComponentBox());
			ivjVerticalBox.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_BOTTOM, getHorizontalBox());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjVerticalBox;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() {
	// user code begin {1}
	// user code end
	getRunButton().addActionListener(this);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		ulxInitialize(getVajContext());
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getVerticalBox());
		initConnections();
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	// user code end
}
public void logError(String errorText) {
	if (fTestRun != null) {
		fTestRun.addMessage(errorText);
	} else {
		if (fWindow != null) {
			fWindow.logError(errorText);
		} else {
			System.out.println(errorText);
		}
	}
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		ULCVajContext.testULCClass(args, UlxViewTestRunner.class);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of com.ibm.ulc.test.UlxViewAbstractComposite");
		exception.printStackTrace(System.out);
	}
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static ULCComponent mainTestConstruction(ULCVajContext context) {
	return new UlxViewTestRunner(context);
}
/**
 * Comment
 */
public void pause() {
	if (fWindow != null)
		fWindow.pause();
}
public void resetErrorLog() {
	if (fWindow != null)
		fWindow.resetErrorLog();
}
/**
 * Comment
 */
void run() {
	if (fWindow != null)
		fWindow.runCurrent();
}
public void runIt(boolean visibly) {
	fTestRun = null;
	getStateIcon().setLabel("TESTING");
	getStateIcon().setIcon(getSystem().getYellowBall());
	if (getTestComponent() != null) {
		if (getTestComponent().runIt(visibly))
			getStateIcon().setIcon(getSystem().getGreenBall());
		else
			getStateIcon().setIcon(getSystem().getRedBall());
		getStateIcon().setLabel("DONE");
	}
	else
		getStateIcon().setLabel("ERROR: test component is null");	
}
public void setIcon(ULCIcon icon) {
	if (getContext() != null)
		getContext().startBatchingRequests();
	getStateIcon().setIcon(icon);
	getStateIcon().setLabel("");
	if (getContext() != null)
		getContext().stopBatchingRequests();
}
public void setMessage(String message) {
	getStatusLine().setLabel(message);
}
public void setTestComponent(UlxAbstractTestComposite composite) {
	getComponentBox().add("ee", composite);
	composite.setRunner(this);
	fTestComposite = composite;
}
public void setTestComponent(UlxTestSuite testSuite, UlxAbstractTestComposite composite) {
	fTestSuite = testSuite;
	setTestComponent(composite);
}
void setWindow(UlxWindowTestSuite window) {
	fWindow = window;
	getRunButton().setEnabled(window != null);
}
/**
 * After a test has completed in auto pilot mode, close the log entry with @testResult.
 *
 * This message must be called after running a test if has opened a log entry.
 *
 * @see runIt
 * @see testStarted
 */
protected void testCompleted(UlxAbstractTestComposite composite, boolean testResult) {
	getTestRun(composite).setResult(testResult);
	if (fWindow != null)
		fWindow.addTestRun(getTestRun(composite));
	else {
		com.ibm.uvm.tools.DebugSupport.halt();
	}
	fTestRun = null;
}
/**
 * While the test is running, information may be posted to the UI using this method
 *
 * 
 */
public void testMessage(UlxAbstractTestComposite composite, String message) {
	if (fTestRun != null)
		getTestRun(composite).addMessage(message);
	getStatusLine().setLabel(message);
}
/**
 * Before running a test in auto pilot mode, prepare a log entry with @testName.
 *
 * This message must be called before running a test if the test should be entered in the
 * test log of the receiver.
 *
 * @see runIt
 * @see testCompleted
 */
protected void testStarted(UlxAbstractTestComposite composite, String testName) {
	if (fTestRun != null)
		testCompleted(fTestRun.getComposite(), false);
	fTestRun = new UlxTestRun();
	fTestRun.setComposite(composite);
	fTestRun.setName(testName);
}
}
