package com.ibm.ulc.test;

import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import java.util.Vector;
import java.util.Enumeration;
/**
 * This type was created in VisualAge.
 */
public class UlxPrivateTestComposite extends UlxAbstractTestComposite implements ISelectionChangedListener {
	private String fName = "unnamed";
	private ULCPage[] fPages = new ULCPage[0];
	private Vector fTargetComponents = new Vector(0);
	private Vector fControlComponents = new Vector(0);
	private ULCComponent fActiveTestedComponent = null;
	private ULCSplitPane ivjMainSplitPane = null;
	private ULCBorder ivjTestBorder = null;
	private ULCBox ivjTestBox = null;
	private ULCBox ivjControlBox = null;
	private ULCBox ivjControlMainBox = null;
	private ULCCheckbox ivjUpdateActivePageOnly = null;
/**
 * UlxPrivateTestComposite constructor comment.
 */
public UlxPrivateTestComposite() {
	super();
	initialize();
}
/**
 * UlxPrivateTestComposite constructor comment.
 * @param vajContext com.ibm.ulc.application.ULCVajContext
 */
public UlxPrivateTestComposite(ULCVajContext vajContext) {
	super(vajContext);
	initialize();
}
/*
 * This notification is sent to the receiver before a test suite is running through all its
 * test composites (sending #runIt). The receiver has the chance to prepare for the test.
 * 
 * The receiver ensures that all target notebook pages are uploaded
 */
public void aboutToRun(boolean visibly) {
	if (visibly) {
		ULCNotebook notebook = getTargetNotebook();
		if (notebook != null) {
			Vector pages = notebook.getPages();
			for (int i = 0; i < pages.size(); i++) {
				ULCPage page = (ULCPage) pages.elementAt(i);
				page.upload(getContext());
				notebook.setActiveTab(i);
				getSystem().processAllIncomingRequests();
			}
			notebook.setActiveTab(0);
			getSystem().processAllIncomingRequests();
		}
	}
}
public void addControlsComponent(ULCComponent component) {
	if (component instanceof ULCNotebook) {
		ULCNotebook book = (ULCNotebook) component;
		book.setHeight(300);
		book.setWidth(400);
		java.util.Enumeration pages = book.getPages().elements();
		while (pages.hasMoreElements()) {
			ULCPage page = (ULCPage) pages.nextElement();
			UlxControlViewAbstract contents = (UlxControlViewAbstract) page.getComponent();
			contents.setTestComposite(this);
			fControlComponents.addElement(contents);
		}
	} else {
		UlxControlViewAbstract tested = (UlxControlViewAbstract) component;
		tested.setTestComposite(this);
		fControlComponents.addElement(tested);
	}
	getControlBox().add("ee", component);
}
public void addTestComponent(ULCComponent component) {
	if (component instanceof ULCNotebook) {
		ULCNotebook book = (ULCNotebook) component;
		fTargetNotebook = book;
		java.util.Enumeration pages = book.getPages().elements();
		while (pages.hasMoreElements()) {
			ULCPage page = (ULCPage) pages.nextElement();
			UlxTestedViewAbstract tested = (UlxTestedViewAbstract) page.getComponent();
			tested.setTestComposite(this);
			fTargetComponents.addElement(tested);
		}
		book.addSelectionChangedListener(this);
		fPages = new ULCPage[book.getPages().size()];
		book.getPages().copyInto(fPages);
		getUpdateActivePageOnly().setVisible(true);
	}
	else {
		UlxTestedViewAbstract tested = (UlxTestedViewAbstract) component;
		String[] names = new String[] {tested.getClass().getName()};
		try {
			names = (String[]) UlxMessage.invoke(tested.getClass(), "testedClasses", new Class[0], new Object[0], names);
		}
		catch (Throwable t) {
		}
		setName(names[0]);
		tested.setTestComposite(this);
		fTargetComponents.addElement(tested);
		fActiveTestedView = tested;
	}
	fActiveTestedComponent = (ULCComponent) fTargetComponents.firstElement();
	getTestBox().add("ee", component);
}
/**
 * 
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private static void getBuilderData() {
/*V1.1
**start of data**
	D0CB838494G88G88G6515CDA7GGGGGGGGGGGG8CGGGE2F5E9ECE4E5F2A0E4E1F4E134BB8BD0D4D7164C8EC91C8A1B30A3A6A61B6C109932F10CB12606D86E9433B20995CD455AB533542C65B299E31C59E417E42DDD2A465DF2EB9EB6909C0D41C8B22C1A8DAAAAFFE8E8BEE29B79AAA8E2838DB44827FFCFE8FDF4375D8F020E496EB9773E7B7A756B578D9A246A54FB675C7B6E3967F34F6775034B7BA2BEABE3F79E47E5E4F152DFFD8647EDBE43F189DB562FE3340222B19D2778BB8AF0
	00FB73C2A6DC2BE02C40B1264B659EF467G5E8678F67B186E0FF0FF10FB589D5788B7E17888B0F630B3B6A7B21FA72FB0BE9F925CD0308F2E7B81BA00A6GA496A17F2E02FC099E8B78FE699EA1E3B74CAD46B95FEB48D750F7CA738C45741AC466CC9428674482BDC11A33076CECE5FF03B43E7901B84E3965216C0F100F62B98619A57439A2694AF136ECD4020EEB36D74055E83AB1712543B3D56132CFD5CC8B0E8A11770B0D0D7D422C49671A31093C9970D64F145763F709BC47ADAD41BD3E5810C35660B8
	AB60F4CF674DC609E7428BCFF051CB97E7E86DC9507DB0A3156D25B430272E371E4F24EB7FF981DB3B894613CB1176CABD6AFC966EE3811615B21ECFF30CE74C6227382D152B3334F8C6A53C1C15D9A66921AC40336171585D7FC3ECFA3287F56E0431C5GCF81A483EC85604A47F40709AF3DFD25842E4DF6544614475D6C753688CE5FE50F1397603E3191C6A4DAAF6F70781C9CC77DA53121CC43AE8C724B03FDA5E063C10E5938B0F9A937687DA544F955324D26AE49A81356E8AA8F48C665FA25976532827D
	8EC09C408A000DGE932DC25261A39646AF40B3C4FED937A266DDE1BCFEC19F689CE5EA749777D02F07265D4044A06D0D601B62DEBC01B9E017B8C495E145EC468DE853D2392699B088FA09E85E35BAB188F6C384174D4157C975C4E079E4D7ED0C3CF7B5E7FC9F6CCA55DCFC225DACF9EB36AE9935053GB22B46F4C7G0CG16AA262799D3A5DC7B85C798BD4108C4B3A9F4C41F2D6C798C2E7C2C6833F53A7D224D6D6087ECBE174DAE70FECE1A5350037B3687BDF716782583F8DC605D3C4FA63ABCEED85DB6
	4503C17CF44E791E83B8474713D133EB8A8E2CED4A4B31F53BFB8E6239337945FE2F938F34BC030E8F74209EE7EC8330A2ACG774B2AD05FEF10B3BE8B77F1GD4CF0F75A3AD8D70CCBD534B1BBD1F407592B888AFB4B636399C388D1B6F96637FC66F47A87B8C6F965BF8AF6FF6420DDF9A7BC56F1E00DE2EF964BDEFA6F47435D65838DF263F55FB0052E18D25165978EF4938CD94FDAE7B344877712268F2CF841E7F006C459F6446FEC95E9F1338138FF2D569D92CB7B6E06CB76B192FFDE0E13EE6ACFA1C6B
	5A7F22262F257E53120CBBFA6AE3F17A002F51B54F13B583BC7E2E5E22F8562C57BEB3778A1447BF877150AD607A01F8352CC6992F625EDD29291B4DDBFF161DA4491822D71F43B303F84653011EDB8DF628E6BE76273E820E4428961B1FE7D1690A8F2C47BB839EC7674E1A437B5B7F19357D6D8133363FBDEC0E6CCF0B4DDA7EC4471EB46339F0F85CEE1EECD09E66E87E7D400C323B5CAEF150651C6045BE57ED482F5EEA7445ED646CF5407DC8B5733D2F0EB37D0EE444F19DCF47E9660336432B33932B29DE
	B7D48774CB7774177D28DFDE6027C0A92D1EE937C8694F10F3AD517DF4FF2BECFBD1A7BE579428968F9BE72A413DA58755A76F828F2CF78AE12C81C0C7565BE5BA44E12C1CAD102A0882ACA38A94F5843537E8417DAC0567D6G2C2BE1767EFCG47D9CC118C5D6A91842ACA0EBD6F9B4267D36139F400CC83FBFEE060206279AE0F674634570C51D632CD73E0AE5A0D3FB94DC3A84601CB7CADA91EF68CFE229A9B30895301B8ED9AC43D880AB5738D28177F14EBA24C931416FB9AE93F4B663876ACF6CEAE67AA
	EB371CE4EDBB92BB9B287D3C8675B9F9F698570D85FA3CAC739B03CA191B7DFE0F43C5D20264EF7A8FF1DF616B3DE63B9F0E05C38CAE78E8CD36D32E49928D2CA67B47E3287BB440B3EBA1DF56B2BFFDEEBF2B49D2177E00B3D73E2CD9136D3B3DBA4BD0CB653254AAEAB2288329BC37ADCA1F144E2F658FF03D66727921A6F17233727935A0EF4CF192D9224F8EE97B7BB7C39803EF48B67F33A1B09164C0EAE7297E2AD65AE9574F425BE929347F9535EABB550F208C9B001EDA4B6C34EB680042CED0ABC2B9B0
	81DE44763CFCD8C777A661AB0733585EB8964FAB0FC62AA9F754066690DADBDDBA0E7A482CD357DC7D041ED7272E39FEF50C55DC05B036280E55815F0CE28CC883BC279E7AAF0086G8B40ECBD133376EA8DB7C73D94262E14FCFC8CF597876BA548EBBEFA75A3056ECC9E17DB1475E69CC19BFAFC2E89171B511A898D2AF1B79689B44F1FBF0A6BA6421A9B6BD98E6EB90E7E30C3462F921CEBE078BB47ACDCF8FD4BFA2F3F375CCDF96C1A970FFB4D5DD49F8F0D064F0D0F0CEA674638D16D5C7864E864DA6C07
	2311F36772517039F379987AE1609C2FA4B81414D2ACFB69AB0C4157209006A57B3C3C03DB5300369DBD4AF2D3A1608DG9600D900258DACB7FD279AED5B4A8B0275B4BE93F3DC194F3853347EB340358300463F6F921F41BDAC835AD6725CCBC773D4F6F98E7A7C8A385271F70246D197CBB865782747146328639BBA65780520F1143BD8FA1E46275AE196E72D7F76D710F1FF9A769DC0D1A3754BAE693A226073EC36260EDB3F7FA497FACE5B1DAE5163E38795350594567F2FBB1EA3BD9F5D487241AE92C312
	GCF81C8EBE479E0FD2BB29F64DE506E51C716C10FFEC66A514F846228F367731974FCAC0A9873340072FF74B346BF3DA01E5B78702359FB4368C9107846C857060F291EE8BCFA5A0AFE1284E31B81F681649947F4C5GCDC6961F746338C728CDD1D94D22E8F3CC126C45CA5681977FD5000C0ECBE5FB7D3816ECE6E3F0BC19D460B4EEFB8BD167F70C6AF8FE1B50E30C6AF83E3B10457327E00CBB4B627981BBF97F81F89440D200D5G1BGF61CE5325D992F5770934DF80E6E2299532FBA502777FD89FA8368
	82308208DFB29E2F0E9F237A5350DDBB94492D9E52BD0BACAE7C35B5FCBCFB41BAF74F3D5A0A75045DA30A1EA9DC1F51132CE8975163A5C4CA7B39957D89524B24C827CA7475D6BC8B82FF0D10E90E59CA4EC7AC48B5104D724EEF88ED15C423F61FA944D83469CB16E722881EA663B905734989F78348ABB86F9CDDF09E4A9CC5F5F4489E5ECEC76D5AF96714DDBB6F145BA3671DDAFB643CF3569EBE6FB89C6177F95DB137BF799D24E685BFB05F7272D28D6AA0F54935EBFEDE765B2F9D39B22D53EF42D29B8A
	F59A0FAF35617EE7F81F68F25804E641B56146F34031F85DB309F57EA494BA37BDEED1B903663741E10C2F17EDAEF71FD7F0010A5C682B34F7FB29D0196BF24FC18C003C58815791G3A7E16BD781EB324CF30F9E1B587E9A8602CF735AA9627B9613DC256A30867D8CE28BD0171E685606BGD24FB13F7E2070EEE2F9BABCC7635A0F49FAB9CDB42E61FEA9BD11500FA868B45E1DA1F4442BE0AC8E001E452C9338571D0067B533BD3DC8E8C5003749341F921A9570E81956FC62DE4F8B2E9DEE2CCD9A23BC066F
	19C7247AB0CBB167A0F764847A3A53B563028350652126653EA0E320E3009A72774EB9BA7FC59D7A9546B9529D3A29CF5231245D38AE090D0A415C9654F55A89254FAD83B9B13EED076BCEGE9CE19569C8B0C89AD4CAF6BAEE83DFF8D2ED3E427148B966A1B05A765FA2505796648C9D22FG1E821056426A15159D2CDE489CCF44C8927E3715D629DEE98D54AB46C30E5D924FF246D3EC15F9161373G78BA0054D666D345A7354EC3FAEB303F643429737F0327085F372973FFAC21173529733F7DA44B7FC698
	0BEFE3793F10C77DE736C3AF8750GE08270824436335C7C1933C9C37F5A7D1C528C410500A4EF39163CAB5A0365CDEED74B3B0968AF25DDAD6F96C25F5E9EA2EFB913B79D46AC675979EFBA991A1F5BCF06666718D3180F134EB3BBBDC67094991FBCF92F6794571CEB8E65711DFB66B11FDED14A29FC783CE7603573F3A32F1D1F1B78487939030F1C1FCDFC78F774CD659AF6AB8F355BAF4B51CEBBE5BBEDA5F85E8559EE65CA1D6E1C07AD6E86A43B155F4FF76EB46E6E4D447A955F5835F8FCC449CBAF20CE
	561FD246538620E18E93609AF50175417AD29C030ADA74F984AC97DABC50F09BBB707983954A6737DE2079AF97468ABBD8BC5EF97194B70FBAC15A980D093FBF45EA04688E9693979711B88CF88AC0DA870B432F6DE5F1F836F80EB85CA945614EC09C4E03B8CC7739ED38F0FE7B1C25FB6C2C1063F6A75BE3DE95095B002F83C86DE4FBB4FF2D5CE37CDB5A6FBAE3163F1C15AE6DAD7FE2E00F71EF2F4D203E12D9B45FFAE8C4FA1E463D8F0B49EF2597557170G21C7DDD44743A70AD8BC0C0531740BAC7E37CF
	203DAD172097830881C8GD887307D920B7F6F71E7393B687FCCA4GC0708F0E81D45E6E8A253CDCD764731757456A3FC5448EC5DD6A7AEFB1219B3B54755F21AAD67F19E0AC310B497B5AA44A1BFFF9CCE7G6882F082C483A4DCE6721E3ED6B7DFF941F754025258F43888FDA99956CC394CE24FC745980B364A789F891EAE63BFA81ACF3C47676FBDB62D19970FEF772E31FBA2FCCE691F504EA9D7A734F30AEDA2F2CEF1CDC44EA9B7A74267941E1C777CEE9A57A86D37152497682631126A6C11AA249901E6
	6EE636FA0250A6810F11E985D58B59CFA3BF3C1A3B157D41698565416C4C7A832A333F1F8CEF3FDFCEEA5BAFF5D25BFE5BA6A35B6FDFA6A35B6F5FA7356CC773D8F5916EDB3059F9812E2B3A719B2E2A1B9C47F264360BB80EA1C98FD77A4E3723D8195F5261992C690A2E0C690CD7D8FE3CD301675267794ACF717F2EC45DBBBC4274141B71EE393E075274B0CF2F17F9BEB81E9320D72F39C23E2728D272B4838D6B119838468350B99E03569C4E84D7934BB90F85FD7BD5784D12EC0CF9DAF9314CA43D47B429
	3F7DBA580D399BA29876C897EDB3B67A93B40BEBB4E72BFA2828E2169785934B0BEBC81EC9GBC89A04544EA039CFFB1B7D72F86C1B370DAD9622153A38F14B3CD66512EC79E05BDE09BGF38F5343731714FD1A39C4BB77A288BDD47E581E009E76EDDB1BC1F9BEE7E0F2ED6EE1BCFFEDC01E393D6093GCD3DACEF7850E5A51F94EF1E006B006DFA28F44DF62254AB766B3CC3B45BA664F37BC031D61E37748647F221D75D77141510FC5E2B4E73F5049E5B2B4E73FFDB4C72FCBC0CE576496F937548FF9270BB
	FD819E31FD417C937A547C7F0658E0CD1F1A7F2B043E21CF4D7F121E715F8CE3C6B3535FEABF7AF7BC60C9GA9GE9G7B7AA13F77333C3B76E623066F044B3B9A2F1AA5DD2FB0202C9D306EC87F7CF2A515292F1654D47DEAD9C789BD2ADFAD6BEF8CF2CD85E3697D2C47FC2AB834D7F926B834D729AE41B8E399103FB9A238A0636B0A35E2BD4EDF0858CFF97CCA1347C275ACD476AF48590E9D207115528A89ADBE08D62C8F55DB05BED4EFEB752827D5321EDEA77886996F515FCD0EDCF5177A24BC2E5F950F
	3B5527F49E7C617370EBFE6DBC3C512F1D07FF610F1C073778A36761ED7E70F5542B86E65FC09D35412034AF5559D0AD790DC3361303607B86997E2F86AD1D26AD283FE7565ECFFF27B5402183480B766633D2DFBDD5226E2B316E2F82595B86D96E5C4B857F56FD1BE33F0553F563F86C79253EDD51337F17DE3DB65625A3302EF71055B483DF636FEF74BB50E607681A61CD36897E0ADB38C5FF9F082BD52E31E810563549F0CD99E43F05BFDB4272E55AA04B17FFA8A5B95A82319E40ECE1F32B2B651A414266
	BEDECDEA864013GD2ACCC6EDB1730E61833CFEF1D649DB76CA836D4B3EC2C15EB8619474764DB6142A1588F00F90879567292E57E9506A27BD454906BBB3FA172458D29F342A2C2CF98D267045CD2169392E1ACFF18712F2FD6723FB39C19FF6CB0633F37067099D6737F14509307557C1F2EE67C5741D851D5467F4DDA649FF3B540B7DEF11F28385FF0D5791E613BC41F29D7A91F8C199EC3686FAA68147F27040EF8BA0CD9C6D8CE7CB9711D2491E53CCFA5340DA34A9891DDCAFA6491366FC7881EAE631F15
	AEE47F03FCC2E3C4650272D04796AAFBB7B99F7923CAFD38882DE8D4290F83B5A83FF11449FF1860E6997FD175DCFB45E73FDD4CCC1A134737091FD476F749D91E053D7E2FCC4B2CC3DA8C5062C7199FDDA634C440B748344789AD95709D32DE3E071FAC307FD3D05C9F2EDFC85BEA6B4BF0DFF950F83E39A438C77D0F12509E7519BAC5AF2A27FD665AD2F51F097566AE50DB6E984B95FCF5705AD15521EB7F28C6597FD643BDDD3F2BC63DBE56E5C53036D1DE7F774456FE9E3F69651D14F6186CF54A4DC3616F
	F2B847C88EA13467F19D79D9E79D6EE54665F7617737F45E1F6A64EF3464F9AB6BC25F8DC4CF239F505C713BD216BB1246D86EB8DDC63EC187FC5F78182EF01C6532689A164B0C63ECEE92093FA260B1G89630CEFE79DDECF751F123EC1BAB12C6C59935FFBA6BB5C3724C963741CEE122E49391FE753B53FCFE439E6937C016FC0F715E2BC4F310E690ED883673B4A9AFC565B2C6AFE6E85A223452A0E672B895DE9D54773F3E5AC1EFBE1AC45AA1F2F9A645FE09B53F5596E26472AA2BD13552666FF1A50851B
	1A7FABB50C7FAC0C255AD8BFB9BB03B6E932C31DE3E77D636B5325DC183E9C08A61F474B7B44DB14CA3E6C16624C4132507EA43FAC34BF793CAC34BFB9D6965A1F7C84D543E227623E3D6C7E471E317B4A034A9CDF932A2FE7EBC26B7DBAC3C076F30A7B8DB577DF8FEF5FD79E5237BCB3F8AF77CC5425243168992C3771FFBCDCB641F51BD431FDB051BDC17FBFB57ABCFE533062FDAECB647610FF11E8467F63620E50923D408315F9010D946A74BFA830DC17E24AA702B226D816BC99B626B89D74EC4EBA545F
	277FC3874923C05F64E067A73F231C8B7FDE2BEF4AA68822CD38516CF662BB2E16DBA29F688FB7F7607AFEB6C79A24E33F6E40FDDFD7BC737F83GD0CB8788C0A3582F1993GGGBCGGD0CB818294G94G88G88G6515CDA7C0A3582F1993GGGBCGG8CGGGGGGGGGGGGGGGGGE2F5E9ECE4E5F2A0E4E1F4E1D0CB8586GGGG81G81GBAGGG5393GGGG
**end of data**/
}
/**
 * Return the ControlBox property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBox getControlBox() {
	if (ivjControlBox == null) {
		try {
			ivjControlBox = new com.ibm.ulc.application.ULCBox(1, 1);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjControlBox;
}
/**
 * Return the ControlMainBox property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBox getControlMainBox() {
	if (ivjControlMainBox == null) {
		try {
			ivjControlMainBox = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjControlMainBox.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getControlBox());
			ivjControlMainBox.add(0, 1, getUpdateActivePageOnly());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjControlMainBox;
}
/**
 * Return the MainSplitPane property value.
 * @return com.ibm.ulc.application.ULCSplitPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCSplitPane getMainSplitPane() {
	if (ivjMainSplitPane == null) {
		try {
			ivjMainSplitPane = new com.ibm.ulc.application.ULCSplitPane(false, getTestBorder(), getControlMainBox());
			ivjMainSplitPane.setDividerLocation((double) 0.6);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjMainSplitPane;
}
public String getName() {
	return fName;
}
/**
 * getTargetComponents method comment.
 */
public java.util.Vector getTargetComponents() {
	Vector v = new Vector();
	if (getUpdateActivePageOnly().isSelected()) {
		v.addElement(((UlxTestedViewAbstract) fActiveTestedComponent).getTestedComponent());
	} else {
		for (int i = 0; i < fTargetComponents.size(); i++) {
			v.addElement(((UlxTestedViewAbstract) fTargetComponents.elementAt(i)).getTestedComponent());
		}
	}
	return v;
}
/**
 * getTargetComponents method comment.
 */
public java.util.Vector getTargetProxies() {
	Vector v = new Vector();
	if (getUpdateActivePageOnly().isSelected()) {
		v.addElement(((UlxTestedViewAbstract) fActiveTestedComponent).getTestedProxy());
	} else {
		for (int i = 0; i < fTargetComponents.size(); i++) {
			v.addElement(((UlxTestedViewAbstract) fTargetComponents.elementAt(i)).getTestedProxy());
		}
	}
	return v;
}
/**
 * Return the TestBorder property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBorder getTestBorder() {
	if (ivjTestBorder == null) {
		try {
			ivjTestBorder = new com.ibm.ulc.application.ULCBorder("Test Area");
			ivjTestBorder.add(getTestBox());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjTestBorder;
}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCBox getTestBox() {
	if (ivjTestBox == null) {
		try {
			ivjTestBox = new com.ibm.ulc.application.ULCBox(1, 1);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjTestBox;
}
/**
 * Return the UpdateActivePageOnly property value.
 * @return com.ibm.ulc.application.ULCCheckbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ULCCheckbox getUpdateActivePageOnly() {
	if (ivjUpdateActivePageOnly == null) {
		try {
			ivjUpdateActivePageOnly = new com.ibm.ulc.application.ULCCheckbox();
			ivjUpdateActivePageOnly.setSelected(true);
			ivjUpdateActivePageOnly.setMnemonic('U');
			ivjUpdateActivePageOnly.setVisible(false);
			ivjUpdateActivePageOnly.setLabel("Update only active Test Page");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjUpdateActivePageOnly;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getMainSplitPane());
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	// user code end
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		ULCVajContext.testULCClass(args, UlxPrivateTestComposite.class);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of com.ibm.ulc.test.UlxAbstractTestComposite");
		exception.printStackTrace(System.out);
	}
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static ULCComponent mainTestConstruction(ULCVajContext context) {
	return new UlxPrivateTestComposite(context);
}
/**
 * runIt method comment.
 */
public boolean runIt(boolean visibly) {
	testStarted(getName());
	boolean update = getUpdateActivePageOnly().isSelected();
	getUpdateActivePageOnly().setSelected(false);
	boolean answer = true;
	Enumeration controls = fControlComponents.elements();
	while (controls.hasMoreElements()) {
		UlxControlViewAbstract control = (UlxControlViewAbstract) controls.nextElement();
		control.resetRunResult();
		testMessage("Running " + control.testPageTabString());
		control.run(visibly);
		if (!control.getRunResult())
			answer = false;
	}
	if (getTargetNotebook() != null)
		getTargetNotebook().setActiveTab(0);
	getUpdateActivePageOnly().setSelected(update);
	testCompleted(answer);
	return answer;
}
public void selectionChanged(ULCSelectionChangedEvent event) {
	ULCNotebook notebook = (ULCNotebook) event.getSource();
	int activeTab = notebook.getActiveTab();
	ULCPage activePage = (ULCPage) notebook.getPages().elementAt(activeTab);
	fActiveTestedComponent = activePage.getComponent();
}
public void setName(String name) {
	fName = name;
}
/**
 * getTargetComponents method comment.
 */
public void setTargetComponents(Vector components) {
	fTargetComponents = components;
}
}
