package com.ibm.ulc.test;

/**
 * This class implements the infrastructure for a set of ULC tests.
 */
import java.lang.reflect.Method;
class UlxMessage {
/**
 * This method was created in VisualAge.
 */
static private Class[] getClasses(Object[] objects) {
	Class[] answer = new Class[objects.length];
	for (int i = 0; i < objects.length; i++)
		answer[i] = objects[i].getClass();
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static void invoke(Class cls, String selector) {
	try {
		Method method = cls.getMethod(selector, new Class[] {});
		method.invoke(cls, new Object[] {});
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static void invoke(Class cls, String selector, Class[] parmClasses, Object[] parameters) {
	try {
		Method method = cls.getMethod(selector, parmClasses);
		method.invoke(cls, parameters);
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(Class cls, String selector, Class[] parmClasses, Object[] parameters, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		Method method = cls.getMethod(selector, parmClasses);
		answer = method.invoke(cls, parameters);
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static void invoke(Class cls, String selector, Object[] parameters) {
	try {
		Class[] classParms = getClasses(parameters);
		invoke(cls, selector, classParms, parameters);
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(Class cls, String selector, Object[] parameters, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		Class[] classes = getClasses(parameters);
		return invoke(cls, selector, classes, parameters, defaultAnswer);
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(Class cls, String selector, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		Method method = cls.getMethod(selector, new Class[] {});
		answer = method.invoke(cls, new Object[] {});
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static void invoke(Object object, String selector) {
	try {
		invoke(object.getClass(), selector);
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static void invoke(Object object, String selector, Object[] parameters) {
	try {
		invoke(object.getClass(), selector, parameters);
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(Object object, String selector, Object[] parameters, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		answer = invoke(object.getClass(), selector, parameters, defaultAnswer);
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(Object object, String selector, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		answer = invoke(object.getClass(), selector, defaultAnswer);
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static void invoke(String clsName, String selector) {
	try {
		Class cls = Class.forName(clsName);
		invoke(cls, selector);
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static void invoke(String clsName, String selector, Object[] parameters) {
	try {
		Class cls = Class.forName(clsName);
		invoke(cls, selector, parameters);
	} catch (Throwable e) {
	}
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(String clsName, String selector, Object[] parameters, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		Class cls = Class.forName(clsName);
		answer = invoke(cls, selector, parameters, defaultAnswer);
	} catch (Throwable e) {
	}
	return answer;
}
/**
 * This method was created in VisualAge.
 */
static Object invoke(String clsName, String selector, Object defaultAnswer) {
	Object answer = defaultAnswer;
	try {
		Class cls = Class.forName(clsName);
		answer = invoke(cls, selector, defaultAnswer);
	} catch (Throwable e) {
	}
	return answer;
}
}
