package com.ibm.ulc.test;

import com.ibm.ulc.application.*;
public class UlxDefinedTest extends UlxTest {
	UlxComposedTest[] fControls = new UlxComposedTest[0];
	UlxComposedTest fTested = null;
/**
 * UlxDefinedTest constructor comment.
 */
UlxDefinedTest() {
	super();
}
/**
 * UlxDefinedTest constructor comment.
 * @param system com.ibm.ulc.test.UlxSystem
 */
UlxDefinedTest(UlxSystem system) {
	super(system);
}
/**
 * UlxDefinedTest constructor comment.
 * @param system com.ibm.ulc.test.UlxSystem
 * @param testComponent java.lang.Class
 */
UlxDefinedTest(UlxSystem system, Class testComponent) {
	super(system, testComponent);
}
void define(UlxComposedTest test, java.util.Vector controls) {
	fTested = test;
	fControls = new UlxComposedTest[controls.size()];
	controls.copyInto(fControls);
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
ULCComponent getControlsComponent() {
	ULCNotebook answer = new ULCNotebook();
	for (int i = 0; i < fControls.length; i++) {
		ULCPage page = new UlxPage(fControls[i].getTestPageTabString(), fControls[i].getComposedComposite());
		answer.addPage(page);
	}
	return answer;
}

UlxAbstractTestComposite getTestComposite(int tabPlacement) {
	UlxPrivateTestComposite composite = new UlxPrivateTestComposite(fSystem.getContext());
	if (fControls.length == 1)
		composite.addControlsComponent(fControls[0].getComposedComposite());
	else
		composite.addControlsComponent(getControlsComponent());
	composite.addTestComponent(fTested.getComposedComposite());
	return composite;
}
/**
 * Answer the list of classes tested by the receiver's test
 *
 * @return String[]
 */
String[] getTestedClasses() {
	if (fTested != null)
		return fTested.getTestedClasses();
	else
		return new String[0];
}
/**
 * Answer the list of classes tested by the receiver's test
 *
 * @return String[]
 */
String getTestPageTabString() {
	if (fTested != null)
		return fTested.getTestPageTabString();
	else
		return "N/A";
}
}
