package com.ibm.ulc.test;

/**
 * This type was created in VisualAge.
 */
import java.util.Enumeration;
import java.util.Vector;
import com.ibm.ulc.application.*;
public class UlxComposedTest extends UlxTest {
	boolean fIsApiTest;
	boolean fIsClassTest;
/**
 * UlxComposedTest constructor comment.
 */
UlxComposedTest() {
	super();
	fIsApiTest = false;
	fIsClassTest = false;
}
/**
 * UlxComposedTest constructor comment.
 * @param system com.ibm.ulc.test.UlxSystem
 */
UlxComposedTest(UlxSystem system) {
	super(system);
}
/**
 * UlxComposedTest constructor comment.
 * @param system com.ibm.ulc.test.UlxSystem
 * @param testComponent java.lang.Class
 */
UlxComposedTest(UlxSystem system, Class testComponent) {
	super(system, testComponent);
}
/**
 * Answer true, if the receiver's test class can be run
 */
public boolean canRun() {
	return false;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
UlxPrivateTestComposite getApiTestComposite(int tabPlacement) {
	UlxPrivateTestComposite composite = new UlxPrivateTestComposite(fSystem.getContext());
	composite.addControlsComponent(getComposedComposite());
	composite.addTestComponent(getTestedComposite(tabPlacement));
	composite.setName(getTestPageTabString());
	return composite;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
UlxPrivateTestComposite getClassTestComposite() {
	UlxPrivateTestComposite composite = new UlxPrivateTestComposite(fSystem.getContext());
	composite.addControlsComponent(getControlComposite());
	composite.addTestComponent(getComposedComposite());
	return composite;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
ULCVajComposite getComposedComposite() {
	Class thisClass = getTestClass();
	if (thisClass == null)
		return null;
	ULCVajComposite answer = null;
	try {
		java.lang.reflect.Constructor constructor = thisClass.getConstructor(new Class[] {IUsesVajContext.class});
		answer = (ULCVajComposite) constructor.newInstance(new Object[] {getContext()});
	} catch (Throwable t) {
		t.toString();
	}
	return answer;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
ULCComponent getControlComposite() {
	Vector p = new Vector();
	for (int i = 0; i < fTestedAPI.length; i++)
		p.addElement(fTestedAPI[i]);
	Vector controls = fSystem.getComposedTestsCoveringClassesAPI(new Vector(), p);
	UlxComposedTest[] cv = new UlxComposedTest[controls.size()];
	controls.copyInto(cv);
	if (cv.length == 1)
		return cv[0].getComposedComposite();
	else {
		ULCNotebook answer = new ULCNotebook();
		for (int i = 0; i < cv.length; i++) {
			ULCPage page = new UlxPage(cv[i].getTestPageTabString(), cv[i].getComposedComposite());
			answer.addPage(page);
		}
		return answer;
	}
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
UlxAbstractTestComposite getTestComposite(int tabPlacement) {
	UlxPrivateTestComposite answer;
	if (isApiTest())
		answer = getApiTestComposite(tabPlacement);
	else
		answer = getClassTestComposite();
	answer.setName(getTestPageTabString());
	return answer;
}
/**
 * Answer java class of the receiver's testComponent
 *
 * @return Class	answer null if the class cannot be found.
 */
ULCComponent getTestedComposite(int tabPlacement) {
	Vector p = new Vector();
	for (int i = 0; i < fTestedClasses.length; i++)
		p.addElement(fTestedClasses[i]);
	Vector controls = fSystem.getComposedTestsCoveringClassesAPI(p, new Vector());
	UlxComposedTest[] cv = new UlxComposedTest[controls.size()];
	controls.copyInto(cv);
	if (cv.length == 1)
		return cv[0].getComposedComposite();
	else {
		ULCNotebook answer = new ULCNotebook();
		answer.setTabPlacement(tabPlacement);
		for (int i = 0; i < cv.length; i++) {
			ULCPage page = new UlxPage(cv[i].getTestPageTabString(), cv[i].getComposedComposite());
			answer.addPage(page);
		}
		return answer;
	}
}
/**
 * Answer the String displayed on the reciever's page
 *
 * @return String
 */
String getTestPageTabString() {
	if (fTabString == "N/A") {
		try {
			if (isApiTest())
				return getTestedAPI()[0];
			else
				return getTestedClasses()[0];
		} catch (Throwable e) {
			return fTestClassName;
		}
	} else
		return fTabString;
}
boolean isApiTest() {
	return fIsApiTest;
}
boolean isClassTest() {
	return fIsClassTest;
}
boolean isComposedTest() {
	return true;
}
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
void setApiComponent(Class cls) {
	fIsApiTest = true;
	Object[] noParms = new Object[0];
	String clsName = cls.getName();
	fTestClassName = clsName.substring(clsName.lastIndexOf(".") + 1);
	fPackageName = clsName.substring(0, clsName.lastIndexOf("."));
	fDescription = (String) UlxMessage.invoke(cls, "testDescription", fDescription);
	fTestedAPI = (String[]) UlxMessage.invoke(cls, "testedAPI", noParms, fTestedAPI);
	fTestedClasses = fSystem.getClassesUnderstandingApi(fTestedAPI);
	fTestCategories = (String[]) UlxMessage.invoke(cls, "testCategories", noParms, fTestCategories);
	fTestedPRs = new String[0];
	fAuthor = "OTI";
	fTabString = (String) UlxMessage.invoke(cls, "testPageTabString", fTabString);
}
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
void setClassComponent(Class cls) {
	fIsClassTest = true;
	Object[] noParms = new Object[0];
	String clsName = cls.getName();
	fTestClassName = clsName.substring(clsName.lastIndexOf(".") + 1);
	fPackageName = clsName.substring(0, clsName.lastIndexOf("."));
	fDescription = (String) UlxMessage.invoke(cls, "testDescription", fDescription);
	fTestedClasses = (String[]) UlxMessage.invoke(cls, "testedClasses", noParms, fTestedClasses);
	fTestedAPI = fSystem.getTestedApiFor(fTestedClasses);
	fTestCategories = (String[]) UlxMessage.invoke(cls, "testCategories", noParms, fTestCategories);
	fTestedPRs = new String[0];
	fAuthor = "OTI";
	fTabString = (String) UlxMessage.invoke(cls, "testPageTabString", fTabString);
}
/**
 * Initialize a new instance of the receiver fro @testComponent.
 *
 * @param testComponent	a subclass of UlxAbstractTestComposite
 */
void setComponent(Class cls) {
	if (cls.getSuperclass() == UlxControlViewAbstract.class) {
		setApiComponent(cls);
	}
	if (cls.getSuperclass() == UlxTestedViewAbstract.class) {
		setClassComponent(cls);return;
	}
	
}
}
