package com.ibm.ulc.test;

/**
 * This class implements the infrastructure for all ULC tests.
 */
//import com.ibm.ulc.varun.*;
import com.ibm.ulc.test.*;
import com.ibm.ulc.testsample.*;

import com.ibm.ulc.application.*;
public abstract class UlxAbstractTestComposite extends UlxAbstractComposite {
	UlxViewTestRunner fRunner = null;
	UlxTestedViewAbstract fActiveTestedView = null;
	protected ULCNotebook fTargetNotebook = null;
/**
 * UlxAbstractTestComposite constructor comment.
 */
public UlxAbstractTestComposite() {
	super();
}
/**
 * UlxAbstractTestComposite constructor comment.
 * @param vajContext com.ibm.ulc.varun.IUsesVajContext
 */
public UlxAbstractTestComposite(IUsesVajContext usesVajContext) {
	super(usesVajContext);
}
/*
 * This notification is sent to the receiver before a test suite is running through all its
 * test composites (sending #runIt). The receiver has the chance to prepare for the test.
 * Default is do nothing.
 */
public void aboutToRun(boolean visibly) {
}
public UlxTestedViewAbstract getActiveTestedView() {
	return fActiveTestedView;
}
public UlxBusinessController getController() {
	return getRunner().getController();
}
public UlxData getDataSource() {
	return getTestData().getDataSource();
}
protected String getInstruction() {
	return "This method (#getInstruction) should be reimplemented by all Control Views";
}
public String getName() {
	return getClass().getName();
}
UlxViewTestRunner getRunner() {
	if (fRunner == null) {
		UlxViewTestRunner runner = new UlxViewTestRunner(getVajContext());
		runner.setTestComponent(this);
	}
	return fRunner;
}
/**
 * Answer the enumeration of ULCComponents currently selected for testing.
 */
public java.util.Vector getTargetComponents() {
	return new java.util.Vector();
}
/*
 * Answer the notebook holding the components to be tested. Default is to answer null,
 * but subclasses actually holding such a notebook, should set the instance variable.
 */
public ULCNotebook getTargetNotebook() {
	return fTargetNotebook;
}
/**
 * Answer the enumeration of ULCComponents currently selected for testing.
 */
public java.util.Vector getTargetProxies() {
	return new java.util.Vector();
}
public UlxTestData getTestData() {
	return getRunner().getTestData();
}
public void logError(Object object, String selector, Throwable t) {
	String errorText = "ULX Error: " + object.getClass().getName() + "#" + selector + " => " + t.toString();
	//getErrorText.setValue(errorText);
	if (getRunner() == null)
		System.out.println(errorText);
	else
		getRunner().logError(errorText);
}
public void pause() {
	if (getRunner() != null)
		getRunner().pause();
}
public void resetErrorLog() {
	//getErrorText.setValue(errorText);
	if (getRunner() != null)
		getRunner().resetErrorLog();
}
/**
 * Run the test(s) defined by the receiver and answer the result.
 * In order to log tests subclasses must implement this method as follows:
 *
 * Before a test is run, the <code>#testStarted</code> must be called with
 * the test's name. When the test has been completed, the <code>#testCompleted</code>
 * must be called with the test's boolean result.
 *
 * The @visibly parameter passed may be ignored. It indicates whether the current user
 * has selected to view the tests while they are executed automatically. Be aware that
 * if the tested components are in a notebook, the tests do nothing for the components in
 * pages not uploaded. In those cases, subclasses should always force all pages to be uploaded
 * regardless of the @visibly parameter.
 *
 * Example:
 * <PR>
 * testStarted("The name of the Test");
 * boolean result = callingTheTestRoutine();
 * testCompleted(result);
 * return result;
 * </PR>
 * 
 * Tests that cannot determine their success must return <code>null</coce>.
 *
 * @return boolean
 */
abstract public boolean runIt(boolean visibly);
void setRunner(UlxViewTestRunner runner) {
	fRunner = runner;
}
public void startBatchingRequests() {
	if (fContext != null)
		fContext.startBatchingRequests();
}
public void stopBatchingRequests() {
	if (fContext != null)
		fContext.stopBatchingRequests();
}
/**
 * Answer the Author of the receiver.
 *
 * If not specified, default is to answer "OTI".
 */
static public String testAuthor() {
	return "N/A";
}
/**
 * Answer the test categories covered by the receiver
 *
 * 
 */
static public String[] testCategories() {
	return new String[] {"uncategorized"};
}
/**
 * After a test has completed in auto pilot mode, close the log entry with @testResult.
 *
 * This message must be called after running a test if has opened a log entry.
 *
 * @see runIt
 * @see testStarted
 */
protected void testCompleted(boolean testResult) {
	if (getRunner() != null)
		getRunner().testCompleted(this, testResult);
}
/**
 * Answer the names of the API tested in this component.
 *
 * The answer contains the names of the methods tested.
 */
static public String[] testedAPI() {
	return new String[0];
}
/**
 * Answer the names of the ULC classes tested in this component.
 *
 * Unless the classse tested are defined in <code>com.ibm.ulc.application</code>, the
 * class names must be fully specified. This information is optional if @testedPRs 
 * is specified.
 */
static public String[] testedClasses() {
	return new String[0];
}
/**
 * Answer the names of the PR verified by this component.
 *
 * The answer contains the name(s) of the PR which the receiver verfies. This
 * information is optional if @testedClasses and/or testedAPI is specified.
 */
static public String[] testedPRs() {
	return new String[0];
}
/**
 * While the test is running, information may be posted to the UI using this method
 *
 * 
 */
public void testMessage(String message) {
	if (getRunner() != null)
		getRunner().testMessage(this, message);
}
/**
 * Answer the package name of this component.
 *
 * this information is needed for automatic updates to the receiver.
 */
static public String testPackageName() {
	return "subclasses must reimplement";
}
/**
 * Answer the String to be displayed in the receiver's notebook tab.
 *
 * Some test suites will include multiple tests in one notebook. This method
 * allows for specific titles. If subclasses do not reimplement this method, the
 * receiver's class name is answered.
 */
static public String testPageTabString() {
	return "subclasses must reimplement";
}
/**
 * Before running a test in auto pilot mode, prepare a log entry with @testName.
 *
 * This message must be called before running a test if the test should be entered in the
 * test log of the receiver.
 *
 * @see runIt
 * @see testCompleted
 */
protected void testStarted() {
	if (getRunner() != null)
		getRunner().testStarted(this, getClass().getName());
}
/**
 * Before running a test in auto pilot mode, prepare a log entry with @testName.
 *
 * This message must be called before running a test if the test should be entered in the
 * test log of the receiver.
 *
 * @see runIt
 * @see testCompleted
 */
protected void testStarted(String testName) {
	if (getRunner() != null)
		getRunner().testStarted(this, testName);
}
/**
 * Comment
 */
public int toInt(Object object) {
	int answer = 0;
	try {
		String string = (String) object;
		answer = Integer.parseInt(string);
	}
	catch (Throwable t) {
		try {
			Integer integer = (Integer) object;
			answer = integer.intValue();
		}
		catch (Throwable tt) {
		}
	}
	return answer;
}
}
