package com.ibm.ulc.test;

/**
 * This class implements the interface to IBM Java Implementation project.
 */
import java.util.Vector;
abstract class UlxAbstractDevelopmentImplementation {
	boolean fCanInspect = true;
	UlxSystem fSystem;
/**
 * Answer true, if the current environment can open VisualAge browsers.
 */
public boolean canBrowse() {
	return false;
}
/**
 * Answer true, if the current environment can open VisualAge inspectors.
 */
public boolean canInspect() {
	return fCanInspect;
}
/**
 * Answer true, if the current environment can open VisualAge browsers.
 */
public boolean canRunTest() {
	return false;
}
/**
 * Answer the subclasses of @class.
 *
 * The default implementation is to read a file with the class names.
 */
Vector computeAvailableTests() {
	Vector classNames = readTestNameFile();
	java.util.Vector classes = new java.util.Vector(classNames.size());
	for (int i = 0; i < classNames.size(); i++) {
		try {
			classes.addElement(Class.forName((String) classNames.elementAt(i)));
		} catch (Throwable t) { //do nothing
		}
	}
	return classes;
}
/**
 * Create an instance of the receiver's hierarchy depending on the environment.
 *
 */
public static UlxAbstractDevelopmentImplementation create(UlxSystem system) {
	UlxAbstractDevelopmentImplementation answer = null;
	if (isRunningVaj()) {
		try {
			Class cls = Class.forName("com.ibm.ulc.test.UlxVAJImplementation");
			answer = (UlxAbstractDevelopmentImplementation) cls.newInstance();
		} catch (Throwable e) {
			answer = null;
		}
	}
	if (answer == null)
		answer = new UlxNoDevelopmentImplementation();
	answer.setSystem(system);
	return answer;
}
/**
 * Answer true if the class named @className exists.
 */
Class getClass(String className) {
	try {
		Class cls = Class.forName(className);
		return cls;
	} catch (Throwable e) {
		return null;
	}
}
String[] getClassesUnderstandingApi(String[] selectors) {
	return new String[0];
}
java.util.Enumeration getComposedTests() {
	return (new Vector(0)).elements();
}
/**
 * Answer the receiver's system 
 */
private UlxSystem getSystem() {
	return fSystem;
}
Vector getTestedAPI() {
	return new Vector(0);
}
String[] getTestedApiFor(String[] classNames) {
	return new String[0];
}
Vector getTestedClasses() {
	return new Vector(0);
}
/**
 * Open an Inspector on @object.
 */
protected void inspect(Object object) {
	if (fCanInspect) {
		UlxMessage.invoke("com.ibm.uvm.tools.DebugSupport", "inspect", new Object[] {object});
	}
}
/**
 * Answer true when the receiver is running in an VAJ environment
 */
static public boolean isRunningVaj() {
	boolean answer = true;
	try {
		/* Throw an exception if we are not in VAJ */
		Class debugClass = Class.forName("com.ibm.uvm.abt.edit.codeGeneration.CgClassDescription");
	} catch (Throwable e) {
		answer = false;
	}
	return answer;
}
/**
 * Open a VisualAge browser on @cls. Do nothing by default.
 */
public void openBrowserOn(Class cls) {
}
/**
 * Open the package prompter of VisualAge. Do nothing, if the prompter is not available..
 */
public String promptForPackageName(String defaultPackageName) {
	return defaultPackageName;
}
/**
 * Read the file holding the names of all tests and answer a String array of class names.
 *
 */
public Vector readTestNameFile() {
	Vector classNames = new Vector(0);
	return classNames;
}
/**
 * Set the receiver's testSuite now
 */
void setSystem(UlxSystem system) {
	fSystem = system;
	try {
		Class debugClass = Class.forName("com.ibm.uvm.tools.DebugSupport");
		fCanInspect = true;
	} catch (Throwable e) {
		fCanInspect = false;
	}
}
/**
 * Update the tested testComponent's implementation now.
 * Unless running inside the VA ide, this message is ignored, 
 * in fact it should not reach the receiver.
 */
protected boolean testChanged(UlxTest test) {
	return false;
}
}
