package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.FinalPersistentObject;

/**
 * Instances wrap "real" country, location, etc objects.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public abstract class WrapperNode extends AbstractLocationNode {
	/**
	 * The wrapped business object.
	 * @serial
	 */
	protected FinalPersistentObject fModel= null;
/**
 * WrapperNode constructor comment.
 */
public WrapperNode() {
	super();
}
/**
 * WrapperNode constructor comment.
 */
public WrapperNode(FinalPersistentObject model) {
	super();
	fModel= model;
}
/**
 * WrapperNode constructor comment.
 */
public WrapperNode(FinalPersistentObject model, AbstractLocationNode parent) {
	super();
	fModel= model;
	fParent= parent;
}
/**
 * Perform the getId method.
 * @return java.lang.String
 */
public String getId() {
	/* Perform the getId method. */
	return fModel.getId();
}
/**
 * The node's label is the model's name.
 * 
 * Creation date: (30.12.99 11:46:28)
 * @return java.lang.String
 */
public String getLabel() {
	return fModel.getName();
}
/**
 * Gets the model property (com.ibm.ulc.examples.carRental.model.FinalPersistentObject) value.
 *
 * @return The model property value.
 */
public com.ibm.ulc.examples.carRental.model.FinalPersistentObject getModel() {
	return fModel;
}
}
