package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.Location;
import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;

/**
 * The composite used to show the pickup details 
 * for the reservation.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class PickupForm extends NotebookPageComposite {
	private ULCBox ivjBox1 = null;
	private ULCLabel ivjDateLabel = null;
	private ULCField ivjPickupDateField = null;
	private ULCLabel ivjPickupLabel = null;
	private LocationSelectionForm ivjPickupLocationSelectionForm = null;
	private ULCField ivjPickupTimeField = null;
	private ULCLabel ivjTimeLabel = null;
/**
 * PickupForm constructor comment.
 */
public PickupForm() {
	super();
/**
 * Warning - This class requires an IUsesVajContext to be initialized properly.
 * This constructor does not have an IUsesVajContext parameter. If it is used,
 * the class will be constructed but it will not be initialized. 
 */
}
/**
 * PickupForm constructor comment.
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
public PickupForm(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super(usesVajContext);
	initialize();
}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox1() {
	if (ivjBox1 == null) {
		try {
			ivjBox1 = new com.ibm.ulc.application.ULCBox(4, 2);
			ivjBox1.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_LEFT_TOP, 2, getPickupLabel());
			ivjBox1.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, 2, getPickupLocationSelectionForm());
			ivjBox1.add(0, 2, getDateLabel());
			ivjBox1.add(0, 3, getTimeLabel());
			ivjBox1.add(1, 2, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getPickupDateField());
			ivjBox1.add(1, 3, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getPickupTimeField());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox1;
}
/**
 * Return the DateLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getDateLabel() {
	if (ivjDateLabel == null) {
		try {
			ivjDateLabel = new com.ibm.ulc.application.ULCLabel("Date");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDateLabel;
}
/**
 * Return the PickupDateField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getPickupDateField() {
	if (ivjPickupDateField == null) {
		try {
			com.ibm.ulc.application.ULCDateValidator ivjLocalDataType;
			ivjLocalDataType = new com.ibm.ulc.application.ULCDateValidator();
			ivjLocalDataType.setFormatString("dd.MM.yyyy");
			ivjPickupDateField = new com.ibm.ulc.application.ULCField();
			ivjPickupDateField.setFormAttributeName("pickupDate");
			ivjPickupDateField.setDataType(ivjLocalDataType);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPickupDateField;
}
/**
 * Return the PickupLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getPickupLabel() {
	if (ivjPickupLabel == null) {
		try {
			ivjPickupLabel = new com.ibm.ulc.application.ULCLabel("Picking up the car: where & when?");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPickupLabel;
}
/**
 * Return the PickupLocationSelectionForm property value.
 * @return com.ibm.ulc.examples.carRental.views.LocationSelectionForm
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private LocationSelectionForm getPickupLocationSelectionForm() {
	if (ivjPickupLocationSelectionForm == null) {
		try {
			ivjPickupLocationSelectionForm = new com.ibm.ulc.examples.carRental.views.LocationSelectionForm(this);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPickupLocationSelectionForm;
}
/**
 * Return the PickupTimeField property value.
 * @return com.ibm.ulc.application.ULCField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCField getPickupTimeField() {
	if (ivjPickupTimeField == null) {
		try {
			com.ibm.ulc.application.ULCDateValidator ivjLocalDataType1;
			ivjLocalDataType1 = new com.ibm.ulc.application.ULCDateValidator();
			ivjLocalDataType1.setFormatString("HH:mm:ss|HH:mm|HH");
			ivjPickupTimeField = new com.ibm.ulc.application.ULCField();
			ivjPickupTimeField.setFormAttributeName("pickupTime");
			ivjPickupTimeField.setDataType(ivjLocalDataType1);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPickupTimeField;
}
/**
 * Return the TimeLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getTimeLabel() {
	if (ivjTimeLabel == null) {
		try {
			ivjTimeLabel = new com.ibm.ulc.application.ULCLabel("Time (HH:mm:ss)");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTimeLabel;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getBox1());
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	finalInitialize();
	// user code end
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new PickupForm(context);
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCField
 */
ULCField pGetPickupDateField() {
	return getPickupDateField();
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.LocationSelectionForm
 */
LocationSelectionForm pGetPickupLocationSelectionForm() {
	return getPickupLocationSelectionForm();
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCField
 */
ULCField pGetPickupTimeField() {
	return getPickupTimeField();
}
/**
 * Save the changes to the model.
 * Subclasses can override this to save widget state in the model.
 *
 * Creation date: (07.01.00 14:32:52)
 */
public void saveInput() {
	Location selected= getPickupLocationSelectionForm().getSelectedLocation();
	fContractSpecFormModel.getContractSpec().getPickupDetails().setLocation(selected);
}
/**
 * Sets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @param contractSpecFormModel The new value for the property.
 * @see #getContractSpecFormModel
 */
public void setContractSpecFormModel(ContractSpecFormModel contractSpecFormModel) {
	fContractSpecFormModel = contractSpecFormModel;
	//
	getPickupDateField().setFormModel(fContractSpecFormModel);
	getPickupTimeField().setFormModel(fContractSpecFormModel);
	//
	updateContractSpecFormModelChanged();
}
/**
 * Set the fonts of the subparts.
 * Creation date: (06.01.00 22:27:49)
 */
protected void setFonts() {
	super.setFonts();
	getPickupLabel().setFont(HUGE_LABEL_FONT);
	//
	getDateLabel().setFont(NORMAL_LABEL_FONT);
	getTimeLabel().setFont(NORMAL_LABEL_FONT);
}
/**
 * Insert the method's description here.
 * Creation date: (06.01.00 21:58:01)
 * @param treeModel com.ibm.ulc.examples.carRental.views.LocationTreeModel
 */
public void setLocationsTreeModel(ULCTreeTableModel treeModel) {
	getPickupLocationSelectionForm().setLocationTreeModelThis(treeModel);
}
/**
 * Set the reference to the parent shell of the receiver;
 * subclasses should override this to propagate the reference
 * to child composites.
 *
 * Creation date: (11.01.00 11:27:09)
 * @param shell com.ibm.ulc.application.ULCShell
 */
public void setShell(ULCShell shell) {
	fShell= shell;
	getPickupLocationSelectionForm().setShell(shell);
}
/**
 * The ContractSpecFormModel has been set: do the updates to the view.
 * Creation date: (06.01.00 22:27:49)
 */
protected void updateContractSpecFormModelChanged() {
	Location pLoc= getContractSpecFormModel().getContractSpec().getReturnDetails().getLocation();
	getPickupLocationSelectionForm().setSelectedLocation(pLoc);
}
}
