package com.ibm.ulc.examples.carRental.views;

import java.util.Vector;
import com.ibm.ulc.application.ULCTreeTableModel;

/**
 * A tree model for location nodes.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
 
public class LocationTreeModel extends ULCTreeTableModel {
	/**
	 * The root of the tree
	 * @serial
	 */
	 protected RootNode fRoot= null;
/**
 * LocationTreeModel constructor comment.
 */
public LocationTreeModel() {
	super();
}
/**
 * LocationTreeModel constructor comment.
 * @param prefetchCount int
 */
public LocationTreeModel(int prefetchCount) {
	super(prefetchCount);
}
/**
 * getChildCount method comment.
 */
public int getChildCount(Object parent) {
	if (parent instanceof AbstractLocationNode) {
		return ((AbstractLocationNode) parent).getChildren().length;
	} else {
		throw new Error("This should not happen");
	}
}
/**
 * Return the index of the given child object,
 * in the given parent bject. 
 * This method is (only) required in case operations (e.g. setSelection) 
 * are being performed on a node which has not yet been uploaded to the
 * UI side.
 *
 * By default, the child will be assumed to be the first child of this parent.
 *
 * @param parent The domain object containing the given child.
 * @param child	The domain object whose parent is required.
 */
public int getChildIndexFor(Object child, Object parent) {
	return getChildren(parent).indexOf(child);
}
/**
 * getChildren method comment.
 */
public Vector getChildren(Object parent) {
	WrapperNode[] children= ((AbstractLocationNode)parent).getChildren();
	
	Vector vect= new Vector(children.length);
	for (int i=0; i<children.length; i++) {
		vect.addElement(children[i]);
	}
	return vect;
}
/**
 * getParent method comment.
 */
public Object getParent(Object userObject) {
	return ((AbstractLocationNode) userObject).getParent();
}
/**
 * getRoot method comment.
 */
public Object getRoot() {
	if (fRoot==null) fRoot= new RootNode();
	return fRoot;
}
/**
 * getRowCount method comment.
 */
public int getRowCount() {
	return 0;
}
/**
 * getValue method comment.
 */
public Object getValue(String columnId, Object nodeObject) {
	AbstractLocationNode node= (AbstractLocationNode) nodeObject;
	if (columnId.equals("nodeType"))
		return node.getNodeType();
	if (columnId.equals("isOpen"))
		return new Boolean(node.isOpen());
	if (columnId.equals("label"))
		return node.getLabel();
	//if (columnId.equals("BossName"))
	//return ((Employee) node).getBossName();
	//if (columnId.equals("PreloadedAttribute"))
	//return "Preloaded for: " + ((Employee) node).getName();
	return columnId; // Useful for testing random column-addition
}
/**
 * saveItemLists method comment.
 */
protected void saveItemLists(com.ibm.ulc.util.Anything anything) {}
}
