package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.DataAccessor;
import com.ibm.ulc.examples.carRental.model.Location;
import com.ibm.ulc.examples.carRental.model.Country;
import com.ibm.ulc.examples.carRental.model.FinalPersistentObject;

/**
 * Adapters used to show countries in a tree widget.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */

public class CountryNode extends WrapperNode {
/**
 * CountryNode constructor comment.
 */
public CountryNode() {
	super();
}
/**
 * CountryNode constructor comment.
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 */
public CountryNode(FinalPersistentObject model) {
	super(model);
}
/**
 * CountryNode constructor comment.
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 */
public CountryNode(FinalPersistentObject model, AbstractLocationNode parent) {
	super(model);
	fParent= parent;
}
/**
 * Answer a state node for each state in the country of the receiver 
 * that has at least a location.
 */
protected WrapperNode[] computeChildren() {
	DataAccessor dAcc= dataAccessor();
	Location[] locs= dAcc.getLocationsInCountry(getCountry());
	String[] states= Location.getStatesFor(locs);
	
	StateNode[] sNodes= new StateNode[states.length];
	for (int i=0; i<sNodes.length; i++) {
		sNodes[i]= new StateNode(fModel,states[i],this);
	}
	return sNodes;
}
/**
 * Insert the method's description here.
 * 
 * Creation date: (30.12.99 12:05:07)
 * @return com.ibm.ulc.examples.carRental.model.Country
 */
protected Country getCountry() {
	return (Country) fModel;
}
}
