package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.CardCompany;
import java.util.Date;
import com.ibm.ulc.application.ULCFormModel;
import com.ibm.ulc.examples.carRental.model.ContractSpec;
import com.ibm.ulc.examples.carRental.model.FinalPersistentObject;
import com.ibm.ulc.examples.carRental.model.DataAccessor;

/**
 * The form model for CustomerSpecs.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */

public class ContractSpecFormModel extends ULCFormModel {
	/**
	 * The contract spec model.
	 * @serial
	 */
	protected ContractSpec fContractSpec = null;
	/**
	 * The attribute 'price'
	 */
	public static final String PRICE_N = "price";
	/**
	 * The attribute 'pricePerDay'
	 */
	public static final String PRICE_PER_DAY_N = "pricePerDay";
	/**
	 * The attribute 'pricePerWeek'
	 */
	public static final String PRICE_PER_WEEK_N = "pricePerWeek";
	/**
	 * The attribute 'hasPickupInfo'
	 */
	public static final String HAS_PICKUP_INFO_N = "hasPickupInfo";
	/**
	 * The attribute 'residenceCountryName'
	 */
	public static final String RESIDENCE_COUNTRY_NAME_N = "residenceCountryName";
	/**
	 * The attribute 'rateSchemeName'
	 */
	public static final String RATE_SCHEME_NAME_N = "rateSchemeName";
	/**
	 * The attribute 'customerId'
	 */
	public static final String CUSTOMER_ID_N = "customerId";
	/**
	 * The attribute 'pickupDate'
	 */
	public static final String PICKUP_DATE_N = "pickupDate";
	/**
	 * The attribute 'pickupTime'
	 */
	public static final String PICKUP_TIME_N = "pickupTime";
	/**
	 * The attribute 'returnDate'
	 */
	public static final String RETURN_DATE_N = "returnDate";
	/**
	 * The attribute 'returnTime'
	 */
	public static final String RETURN_TIME_N = "returnTime";
	/**
	 * The attribute 'isReturnSameAsPickup'
	 */
	public static final String IS_RETURN_SAME_AS_PICKUP_N = "isReturnSameAsPickup";
	/**
	 * The attribute 'hasReturnInfo'
	 */
	public static final String HAS_RETURN_INFO_N = "hasReturnInfo";
	/**
	 * The attribute 'transmissionString'
	 */
	public static final String TRANSMISSION_STRING_N = "transmissionString";
	/**
	 * The attribute 'airConditioning'
	 */
	public static final String AIR_CONDITIONING_N = "airConditioning";
	/**
	 * The attribute 'hasPricingInfo'
	 */
	public static final String HAS_PRICING_INFO_N = "hasPricingInfo";
	/**
	 * The attribute 'cardCompanyName'
	 */
	public static final String CARD_COMPANY_NAME_N = "cardCompanyName";
	/**
	 * The attribute 'cardNumber'
	 */
	public static final String CARD_NUMBER_N = "cardNumber";
	/**
	 * The attribute 'expiration'
	 */
	public static final String EXPIRATION_N = "expiration";
	/**
	 * The attribute 'hasChildSeats'
	 */
	public static final String HAS_CHILD_SEATS_N = "hasChildSeats";
	/**
	 * The attribute 'childSeats'
	 */
	public static final String CHILD_SEATS_N = "childSeats";
	/**
	 * The attribute 'mobile'
	 */
	public static final String MOBILE_N = "mobile";
	/**
	 * The attribute 'navigation'
	 */
	public static final String NAVIGATION_N = "navigation";
	/**
	 * The attribute 'lossIns'
	 */
	public static final String LOSS_INS_N = "lossIns";
	/**
	 * The attribute 'propertyIns'
	 */
	public static final String PROPERTY_INS_N = "propertyIns";
	/**
	 * The list of all registred attributes.
	 */
	public static final String[] ALL_ATTRIBUTE_NAMES = {
		RESIDENCE_COUNTRY_NAME_N, RATE_SCHEME_NAME_N, CUSTOMER_ID_N, 
		PRICE_N, PRICE_PER_DAY_N, PRICE_PER_WEEK_N,
		PICKUP_DATE_N, PICKUP_TIME_N, 
		HAS_PICKUP_INFO_N, 
		IS_RETURN_SAME_AS_PICKUP_N,
		RETURN_DATE_N, RETURN_TIME_N, 
		HAS_RETURN_INFO_N, 
		TRANSMISSION_STRING_N, AIR_CONDITIONING_N, 
		HAS_CHILD_SEATS_N, CHILD_SEATS_N, MOBILE_N, NAVIGATION_N, 
		LOSS_INS_N, PROPERTY_INS_N, 
		HAS_PRICING_INFO_N, 
		CARD_COMPANY_NAME_N, CARD_NUMBER_N, EXPIRATION_N};
/**
 * ContractSpecFormModel constructor comment.
 */
public ContractSpecFormModel() {
	super();
}
/**
 * ContractSpecFormModel constructor comment.
 * @param policy int
 */
public ContractSpecFormModel(int policy) {
	super(policy);
}
/**
 * Convenience.
 * Creation date: (07.01.00 12:31:52)
 * @return com.ibm.ulc.examples.carRental.model.DataAccessor
 */
protected DataAccessor dataAccessor() {
	return DataAccessor.instance();
}
/**
 * Get the receiver's ContractSpec model.
 * 
 * Creation date: (27.12.99 14:16:31)
 * @return com.ibm.ulc.examples.carRental.model.ContractSpec
 */
public ContractSpec getContractSpec() {
	return fContractSpec;
}
/**
 * Get the name out of object handling the null case.
 * Creation date: (07.01.00 12:23:38)
 * @return java.lang.String
 * @param object com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 */
protected String getNameOf(FinalPersistentObject object) {
	return object==null ? "" : object.getName();
}
/**
 * getValueAt That's for the beauty contest!.
 */
public Object getValueAt(String formAttributeName) {
	if (formAttributeName.equals(PRICE_N))
		return new Double(fContractSpec.getPrice());
	if (formAttributeName.equals(PRICE_PER_DAY_N))
		return new Double(fContractSpec.getPricePerDay());
	if (formAttributeName.equals(PRICE_PER_WEEK_N))
		return new Double(fContractSpec.getPricePerWeek());
	if (formAttributeName.equals(HAS_PICKUP_INFO_N))
		return new Boolean(fContractSpec.hasPickupInfo());
	if (formAttributeName.equals(RESIDENCE_COUNTRY_NAME_N))
		return getNameOf(fContractSpec.getCustomerSpec().getResidenceCountry());
	if (formAttributeName.equals(RATE_SCHEME_NAME_N))
		return getNameOf(fContractSpec.getCustomerSpec().getRateScheme());
	if (formAttributeName.equals(CUSTOMER_ID_N))
		return fContractSpec.getCustomerSpec().getCustomerId();
	if (formAttributeName.equals(PICKUP_DATE_N))
		return fContractSpec.getPickupDetails().getDate();
	if (formAttributeName.equals(PICKUP_TIME_N))
		return fContractSpec.getPickupDetails().getTime();
	if (formAttributeName.equals(IS_RETURN_SAME_AS_PICKUP_N))
		return new Boolean(fContractSpec.getIsReturnSameAsPickup());
	if (formAttributeName.equals(RETURN_DATE_N))
		return fContractSpec.getReturnDetails().getDate();
	if (formAttributeName.equals(RETURN_TIME_N))
		return fContractSpec.getReturnDetails().getTime();
	if (formAttributeName.equals(HAS_RETURN_INFO_N))
		return new Boolean(fContractSpec.hasReturnInfo());
	if (formAttributeName.equals(TRANSMISSION_STRING_N))
		return fContractSpec.getCarSpec().getTransmission();
	if (formAttributeName.equals(AIR_CONDITIONING_N))
		return new Boolean(fContractSpec.getCarSpec().getAirConditioning());
	//
	if (formAttributeName.equals(HAS_PRICING_INFO_N))
		return new Boolean(fContractSpec.hasReturnInfo()); //simplification 
	//
	if (formAttributeName.equals(CARD_COMPANY_NAME_N))
		return getNameOf(fContractSpec.getGuarantee().getCardCompany());
	if (formAttributeName.equals(CARD_NUMBER_N))
		return fContractSpec.getGuarantee().getCardNumber();
	if (formAttributeName.equals(EXPIRATION_N))
		return fContractSpec.getGuarantee().getExpiration();
	if (formAttributeName.equals(HAS_CHILD_SEATS_N))
		return new Boolean(fContractSpec.getOptionsSpec().getChildSeats()>0);
	if (formAttributeName.equals(CHILD_SEATS_N))
		return new Integer(fContractSpec.getOptionsSpec().getChildSeats());
	if (formAttributeName.equals(MOBILE_N))
		return new Boolean(fContractSpec.getOptionsSpec().getMobile());
	if (formAttributeName.equals(NAVIGATION_N))
		return new Boolean(fContractSpec.getOptionsSpec().getNavigation());
	if (formAttributeName.equals(LOSS_INS_N))
		return new Boolean(fContractSpec.getOptionsSpec().getLossIns());
	if (formAttributeName.equals(PROPERTY_INS_N))
		return new Boolean(fContractSpec.getOptionsSpec().getPropertyIns());
	
System.out.println("request for unimplemented formAttributeName "+formAttributeName);
	return null;
}
/**
 * Set the receiver's ContractSpec model.
 * 
 * Creation date: (27.12.99 14:17:35)
 * @param contract com.ibm.ulc.examples.carRental.model.ContractSpec
 */
public void setContractSpec(ContractSpec contract) {
	fContractSpec= contract;
}
/**
 * Overridden this method to save updated form values (see getValueAt comment).
 *
 * @param formAttributeName 	The key at which the change occurred.
 * @param value				 	The value to be set at the specified key.
 */
public void setValueAt(Object value, String formAttributeName) {
	// customer data
	if (formAttributeName.equals(RESIDENCE_COUNTRY_NAME_N)) {
		fContractSpec.getCustomerSpec().setResidenceCountry(dataAccessor().countryNamed((String)value));
	} else if (formAttributeName.equals(RATE_SCHEME_NAME_N)) {
		fContractSpec.getCustomerSpec().setRateScheme(dataAccessor().rateSchemeNamed((String)value));
	} else if (formAttributeName.equals(CUSTOMER_ID_N)) {
		fContractSpec.getCustomerSpec().setCustomerId((String)value);
	// pickup
	} else if (formAttributeName.equals(PICKUP_DATE_N)) {
		fContractSpec.getPickupDetails().setDate((Date)value);
	} else if (formAttributeName.equals(PICKUP_TIME_N)) {
		fContractSpec.getPickupDetails().setTime((Date)value);
	// return
	} else if (formAttributeName.equals(IS_RETURN_SAME_AS_PICKUP_N)) {
		fContractSpec.setIsReturnSameAsPickup(((Boolean)value).booleanValue());
	} else if (formAttributeName.equals(RETURN_DATE_N)) {
		fContractSpec.getReturnDetails().setDate((Date)value);
	} else if (formAttributeName.equals(RETURN_TIME_N)) {
		fContractSpec.getReturnDetails().setTime((Date)value);
	// car
	} else if (formAttributeName.equals(AIR_CONDITIONING_N)) {
		fContractSpec.getCarSpec().setAirConditioning(((Boolean)value).booleanValue());
	} else if (formAttributeName.equals(TRANSMISSION_STRING_N)) {
		fContractSpec.getCarSpec().setTransmission((String)value);
	// options
	} else if (formAttributeName.equals(HAS_CHILD_SEATS_N)) {
		boolean boolVal= ((Boolean)value).booleanValue();
		if (!boolVal) fContractSpec.getOptionsSpec().setChildSeats(0);
		// nothing can be set in the else case
	} else if (formAttributeName.equals(CHILD_SEATS_N)) {
		fContractSpec.getOptionsSpec().setChildSeats(((Integer)value).intValue());
	} else if (formAttributeName.equals(MOBILE_N)) {
		fContractSpec.getOptionsSpec().setMobile(((Boolean)value).booleanValue());
	} else if (formAttributeName.equals(NAVIGATION_N)) {
		fContractSpec.getOptionsSpec().setNavigation(((Boolean)value).booleanValue());
	} else if (formAttributeName.equals(PROPERTY_INS_N)) {
		fContractSpec.getOptionsSpec().setPropertyIns(((Boolean)value).booleanValue());
	} else if (formAttributeName.equals(LOSS_INS_N)) {
		fContractSpec.getOptionsSpec().setLossIns(((Boolean)value).booleanValue());
	// guarantee
	} else if (formAttributeName.equals(CARD_COMPANY_NAME_N)) {
		fContractSpec.getGuarantee().setCardCompany(dataAccessor().cardCompanyNamed((String)value));
	} else if (formAttributeName.equals(CARD_NUMBER_N)) {
		fContractSpec.getGuarantee().setCardNumber((String)value);
	} else if (formAttributeName.equals(EXPIRATION_N)) {
		fContractSpec.getGuarantee().setExpiration((Date)value);
	// catch all in the log
	} else {
		System.out.println("setValueAt(" + formAttributeName + "): " + value.toString());
	}
}
}
