package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.CarClass;
import com.ibm.ulc.examples.carRental.model.CarSpec;
import com.ibm.ulc.base.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.examples.carRental.model.AvailableCarSpecPattern;
import com.ibm.ulc.examples.carRental.model.ContractSpec;

/**
 * The composite used to show the details about the reserved car.
 * @author: Markus Marzetta (CS-ZRH)
 */
public class CarForm extends NotebookPageComposite {
	private ULCBox ivjVerticalBox = null;
	private ULCLabel ivjWhatTypeLabel = null;
	private ULCPage ivjFalsePage = null;
	private ULCPagebook ivjPagebook1 = null;
	private ULCLabel ivjPleaseLabel = null;
	private ULCPage ivjTruePage = null;
	private ULCBox ivjVerticalBox1 = null;
	private ULCColumn ivjAirColumn = null;
	private ULCTable ivjAvailableCarSpecTable = null;
	private ULCLabel ivjAvailableCarTypesLabel = null;
	private ULCBox ivjBox1 = null;
	private ULCColumn ivjCarClassColumn = null;
	private ULCLabel ivjFillOutLabel = null;
	private ULCColumn ivjTransmissionColumn = null;
	private ULCBorder ivjAirGroupBox = null;
	private ULCPage ivjTransmissionAMPage = null;
	private ULCPage ivjTransmissionAPage = null;
	private ULCBorder ivjTransmissionGroupBox = null;
	private ULCPage ivjTransmissionMPage = null;
	private ULCPagebook ivjTransmissionPagebook = null;
	private ULCBox ivjVerticalBox2 = null;
	private AvailableCarSpecPatternTableModel ivjAvailableCarSpecPatternTableModel = null;
	private ULCRowModel ivjRowModel1 = null;
	private ULCLabel ivjAutomaticTransmissionLabel = null;
	private ULCLabel ivjManualTransmissionLabel = null;
	private ULCLabel ivjAirNoLabel = null;
	private ULCPage ivjAirNPage = null;
	private ULCPagebook ivjAirPagebook = null;
	private ULCLabel ivjAirYesLabel = null;
	private ULCPage ivjAirYNPage = null;
	private ULCPage ivjAirYPage = null;
	private ULCCheckbox ivjAirConditioningCheckBox = null;
	private ULCRadioButton ivjAutomaticRadioButton = null;
	private ULCBox ivjBox2 = null;
	private ULCBox ivjBox3 = null;
	private ULCRadioButton ivjManualRadioButton = null;
	private ULCFiller ivjFiller1 = null;
	private ULCFiller ivjFiller2 = null;
	private ULCButtonGroup ivjRadioGroup1 = null;
	private ULCFiller ivjFiller3 = null;
/**
 * CarForm constructor comment.
 */
public CarForm() {
	super();
	initialize();
}
/**
 * CarForm constructor comment.
 * @param usesVajContext com.ibm.ulc.application.IUsesVajContext
 */
public CarForm(com.ibm.ulc.application.IUsesVajContext usesVajContext) {
	super(usesVajContext);
	initialize();
}
/**
 * connPtoP1SetTarget:  (AvailableCarSpecPatternTableModel.this <--> AvailableCarSpecTable.tableModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP1SetTarget() {
	/* Set the target from the source */
	try {
		getAvailableCarSpecTable().setTableModel(getAvailableCarSpecPatternTableModel());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP2SetTarget:  (AvailableCarSpecPatternTableModel.this <--> RowModel1.tableModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP2SetTarget() {
	/* Set the target from the source */
	try {
		getRowModel1().setTableModel(getAvailableCarSpecPatternTableModel());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP3SetTarget:  (AvailableCarSpecTable.this <--> RowModel1.tableList)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP3SetTarget() {
	/* Set the target from the source */
	try {
		getRowModel1().setTableList(getAvailableCarSpecTable());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP4SetTarget:  (RowModel1.this <--> TransmissionPagebook.formModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP4SetTarget() {
	/* Set the target from the source */
	try {
		getTransmissionPagebook().setFormModel(getRowModel1());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP5SetTarget:  (RowModel1.this <--> Pagebook3.formModel)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP5SetTarget() {
	/* Set the target from the source */
	try {
		getAirPagebook().setFormModel(getRowModel1());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP6SetTarget:  (RadioGroup1.this <--> AutomaticRadioButton.buttonGroup)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP6SetTarget() {
	/* Set the target from the source */
	try {
		getAutomaticRadioButton().setButtonGroup(getRadioGroup1());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connPtoP7SetTarget:  (RadioGroup1.this <--> ManualRadioButton.buttonGroup)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP7SetTarget() {
	/* Set the target from the source */
	try {
		getManualRadioButton().setButtonGroup(getRadioGroup1());
		// user code begin {1}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * Return the AirColumn property value.
 * @return com.ibm.ulc.application.ULCColumn
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCColumn getAirColumn() {
	if (ivjAirColumn == null) {
		try {
			ivjAirColumn = new com.ibm.ulc.application.ULCColumn("airConditioningChoices", "Air", 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirColumn;
}
/**
 * Return the AirConditioningCheckBox property value.
 * @return com.ibm.ulc.application.ULCCheckbox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCCheckbox getAirConditioningCheckBox() {
	if (ivjAirConditioningCheckBox == null) {
		try {
			ivjAirConditioningCheckBox = new com.ibm.ulc.application.ULCCheckbox();
			ivjAirConditioningCheckBox.setFormAttributeName("airConditioning");
			ivjAirConditioningCheckBox.setLabel("Air conditioning required");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirConditioningCheckBox;
}
/**
 * Return the AirGroupBox property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getAirGroupBox() {
	if (ivjAirGroupBox == null) {
		try {
			ivjAirGroupBox = new com.ibm.ulc.application.ULCBorder("Air conditioning");
			ivjAirGroupBox.add(getAirPagebook());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirGroupBox;
}
/**
 * Return the AirNoLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getAirNoLabel() {
	if (ivjAirNoLabel == null) {
		try {
			ivjAirNoLabel = new com.ibm.ulc.application.ULCLabel("Not available");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirNoLabel;
}
/**
 * Return the AirNPage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getAirNPage() {
	if (ivjAirNPage == null) {
		try {
			ivjAirNPage = new com.ibm.ulc.application.ULCPage("N", getAirNoLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirNPage;
}
/**
 * Return the Pagebook3 property value.
 * @return com.ibm.ulc.application.ULCPagebook
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPagebook getAirPagebook() {
	if (ivjAirPagebook == null) {
		try {
			ivjAirPagebook = new com.ibm.ulc.application.ULCPagebook();
			ivjAirPagebook.setFormAttributeName("airConditioningChoices");
			ivjAirPagebook.addPage(getAirYPage());
			ivjAirPagebook.addPage(getAirNPage());
			ivjAirPagebook.addPage(getAirYNPage());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirPagebook;
}
/**
 * Return the AirYesLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getAirYesLabel() {
	if (ivjAirYesLabel == null) {
		try {
			ivjAirYesLabel = new com.ibm.ulc.application.ULCLabel("Present");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirYesLabel;
}
/**
 * Return the AirYNPage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getAirYNPage() {
	if (ivjAirYNPage == null) {
		try {
			ivjAirYNPage = new com.ibm.ulc.application.ULCPage("Y/N", getBox3());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirYNPage;
}
/**
 * Return the Page1 property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getAirYPage() {
	if (ivjAirYPage == null) {
		try {
			ivjAirYPage = new com.ibm.ulc.application.ULCPage("Y", getAirYesLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAirYPage;
}
/**
 * Return the AutomaticRadioButton property value.
 * @return com.ibm.ulc.application.ULCRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCRadioButton getAutomaticRadioButton() {
	if (ivjAutomaticRadioButton == null) {
		try {
			ivjAutomaticRadioButton = new com.ibm.ulc.application.ULCRadioButton("Automatic");
			ivjAutomaticRadioButton.setFormAttributeName("transmissionString");
			ivjAutomaticRadioButton.setValue("automatic");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAutomaticRadioButton;
}
/**
 * Return the Label3 property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getAutomaticTransmissionLabel() {
	if (ivjAutomaticTransmissionLabel == null) {
		try {
			ivjAutomaticTransmissionLabel = new com.ibm.ulc.application.ULCLabel("Automatic");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAutomaticTransmissionLabel;
}
/**
 * Return the AvailableCarSpecPatternTableModel property value.
 * @return com.ibm.ulc.examples.carRental.views.AvailableCarSpecPatternTableModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private AvailableCarSpecPatternTableModel getAvailableCarSpecPatternTableModel() {
	if (ivjAvailableCarSpecPatternTableModel == null) {
		try {
			ivjAvailableCarSpecPatternTableModel = new com.ibm.ulc.examples.carRental.views.AvailableCarSpecPatternTableModel();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAvailableCarSpecPatternTableModel;
}
/**
 * Return the AvailableCarSpecTable property value.
 * @return com.ibm.ulc.application.ULCTable
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCTable getAvailableCarSpecTable() {
	if (ivjAvailableCarSpecTable == null) {
		try {
			ivjAvailableCarSpecTable = new com.ibm.ulc.application.ULCTable();
			ivjAvailableCarSpecTable.setHeightInRows(6);
			ivjAvailableCarSpecTable.setAutoResize(IDefaults.TABLE_AUTO_RESIZE_ALL_COLUMNS);
			ivjAvailableCarSpecTable.addColumn(getCarClassColumn());
			ivjAvailableCarSpecTable.addColumn(getTransmissionColumn());
			ivjAvailableCarSpecTable.addColumn(getAirColumn());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAvailableCarSpecTable;
}
/**
 * Return the AvailableCarTypesLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getAvailableCarTypesLabel() {
	if (ivjAvailableCarTypesLabel == null) {
		try {
			ivjAvailableCarTypesLabel = new com.ibm.ulc.application.ULCLabel("Available car types");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAvailableCarTypesLabel;
}
/**
 * Return the Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox1() {
	if (ivjBox1 == null) {
		try {
			ivjBox1 = new com.ibm.ulc.application.ULCBox(2, 2);
			ivjBox1.add(0, 0, 2, getAvailableCarTypesLabel());
			ivjBox1.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getAvailableCarSpecTable());
			ivjBox1.add(1, 1, com.ibm.ulc.base.IDefaults.BOX_LEFT_TOP, getVerticalBox2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox1;
}
/**
 * Return the Box2 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox2() {
	if (ivjBox2 == null) {
		try {
			ivjBox2 = new com.ibm.ulc.application.ULCBox(2, 2);
			ivjBox2.add(0, 0, getAutomaticRadioButton());
			ivjBox2.add(0, 1, getManualRadioButton());
			ivjBox2.add(1, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getFiller1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox2;
}
/**
 * Return the Box3 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getBox3() {
	if (ivjBox3 == null) {
		try {
			ivjBox3 = new com.ibm.ulc.application.ULCBox(1, 2);
			ivjBox3.add(0, 0, getAirConditioningCheckBox());
			ivjBox3.add(1, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getFiller2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjBox3;
}
/**
 * Return the CarClassColumn property value.
 * @return com.ibm.ulc.application.ULCColumn
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCColumn getCarClassColumn() {
	if (ivjCarClassColumn == null) {
		try {
			ivjCarClassColumn = new com.ibm.ulc.application.ULCColumn("name", "Car Class", 120);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCarClassColumn;
}
/**
 * Return the FalsePage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getFalsePage() {
	if (ivjFalsePage == null) {
		try {
			ivjFalsePage = new com.ibm.ulc.application.ULCPage("false", getVerticalBox1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFalsePage;
}
/**
 * Return the Filler1 property value.
 * @return com.ibm.ulc.application.ULCFiller
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCFiller getFiller1() {
	if (ivjFiller1 == null) {
		try {
			ivjFiller1 = new com.ibm.ulc.application.ULCFiller();
			ivjFiller1.setWidth(5);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFiller1;
}
/**
 * Return the Filler2 property value.
 * @return com.ibm.ulc.application.ULCFiller
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCFiller getFiller2() {
	if (ivjFiller2 == null) {
		try {
			ivjFiller2 = new com.ibm.ulc.application.ULCFiller();
			ivjFiller2.setWidth(5);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFiller2;
}
/**
 * Return the Filler3 property value.
 * @return com.ibm.ulc.application.ULCFiller
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCFiller getFiller3() {
	if (ivjFiller3 == null) {
		try {
			ivjFiller3 = new com.ibm.ulc.application.ULCFiller();
			ivjFiller3.setHeight(1);
			ivjFiller3.setWidth(150);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFiller3;
}
/**
 * Return the FillOutLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getFillOutLabel() {
	if (ivjFillOutLabel == null) {
		try {
			ivjFillOutLabel = new com.ibm.ulc.application.ULCLabel("Fill out the pickup page before");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFillOutLabel;
}
/**
 * Return the ManualRadioButton property value.
 * @return com.ibm.ulc.application.ULCRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCRadioButton getManualRadioButton() {
	if (ivjManualRadioButton == null) {
		try {
			ivjManualRadioButton = new com.ibm.ulc.application.ULCRadioButton("Manual");
			ivjManualRadioButton.setFormAttributeName("transmissionString");
			ivjManualRadioButton.setValue("manual");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjManualRadioButton;
}
/**
 * Return the Label2 property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getManualTransmissionLabel() {
	if (ivjManualTransmissionLabel == null) {
		try {
			ivjManualTransmissionLabel = new com.ibm.ulc.application.ULCLabel("Manual");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjManualTransmissionLabel;
}
/**
 * Return the Pagebook1 property value.
 * @return com.ibm.ulc.application.ULCPagebook
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPagebook getPagebook1() {
	if (ivjPagebook1 == null) {
		try {
			ivjPagebook1 = new com.ibm.ulc.application.ULCPagebook();
			ivjPagebook1.setFormAttributeName("hasPickupInfo");
			ivjPagebook1.addPage(getTruePage());
			ivjPagebook1.addPage(getFalsePage());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPagebook1;
}
/**
 * Return the PleaseLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getPleaseLabel() {
	if (ivjPleaseLabel == null) {
		try {
			ivjPleaseLabel = new com.ibm.ulc.application.ULCLabel("Please");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjPleaseLabel;
}
/**
 * Return the RadioGroup1 property value.
 * @return com.ibm.ulc.application.ULCButtonGroup
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCButtonGroup getRadioGroup1() {
	if (ivjRadioGroup1 == null) {
		try {
			ivjRadioGroup1 = new com.ibm.ulc.application.ULCButtonGroup();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjRadioGroup1;
}
/**
 * Return the RowModel1 property value.
 * @return com.ibm.ulc.application.ULCRowModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCRowModel getRowModel1() {
	if (ivjRowModel1 == null) {
		try {
			ivjRowModel1 = new com.ibm.ulc.application.ULCRowModel();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjRowModel1;
}
/**
 * Answer the car spec pattern selected in the view.
 * Creation date: (11.01.00 15:13:58)
 * @return com.ibm.ulc.examples.carRental.model.AvailableCarSpecPattern
 */
protected AvailableCarSpecPattern getSelectedCarSpecPattern() {
	return (AvailableCarSpecPattern) getAvailableCarSpecTable().getSelectedItem();
}
/**
 * Return the TransmissionAMPage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getTransmissionAMPage() {
	if (ivjTransmissionAMPage == null) {
		try {
			ivjTransmissionAMPage = new com.ibm.ulc.application.ULCPage("A/M", getBox2());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTransmissionAMPage;
}
/**
 * Return the TransmissionAPage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getTransmissionAPage() {
	if (ivjTransmissionAPage == null) {
		try {
			ivjTransmissionAPage = new com.ibm.ulc.application.ULCPage("A", getAutomaticTransmissionLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTransmissionAPage;
}
/**
 * Return the TransmissionColumn property value.
 * @return com.ibm.ulc.application.ULCColumn
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCColumn getTransmissionColumn() {
	if (ivjTransmissionColumn == null) {
		try {
			ivjTransmissionColumn = new com.ibm.ulc.application.ULCColumn("transmissionChoices", "Transm.", 30);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTransmissionColumn;
}
/**
 * Return the TransmissionGroupBox property value.
 * @return com.ibm.ulc.application.ULCBorder
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBorder getTransmissionGroupBox() {
	if (ivjTransmissionGroupBox == null) {
		try {
			ivjTransmissionGroupBox = new com.ibm.ulc.application.ULCBorder("Transmission");
			ivjTransmissionGroupBox.add(getTransmissionPagebook());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTransmissionGroupBox;
}
/**
 * Return the TransmissionMPage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getTransmissionMPage() {
	if (ivjTransmissionMPage == null) {
		try {
			ivjTransmissionMPage = new com.ibm.ulc.application.ULCPage("M", getManualTransmissionLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTransmissionMPage;
}
/**
 * Return the TransmissionPagebook property value.
 * @return com.ibm.ulc.application.ULCPagebook
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPagebook getTransmissionPagebook() {
	if (ivjTransmissionPagebook == null) {
		try {
			ivjTransmissionPagebook = new com.ibm.ulc.application.ULCPagebook();
			ivjTransmissionPagebook.setFormAttributeName("transmissionChoices");
			ivjTransmissionPagebook.addPage(getTransmissionAPage());
			ivjTransmissionPagebook.addPage(getTransmissionMPage());
			ivjTransmissionPagebook.addPage(getTransmissionAMPage());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTransmissionPagebook;
}
/**
 * Return the TruePage property value.
 * @return com.ibm.ulc.application.ULCPage
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCPage getTruePage() {
	if (ivjTruePage == null) {
		try {
			ivjTruePage = new com.ibm.ulc.application.ULCPage("true", getBox1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTruePage;
}
/**
 * Return the Vertical Box property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getVerticalBox() {
	if (ivjVerticalBox == null) {
		try {
			ivjVerticalBox = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjVerticalBox.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_LEFT_TOP, getWhatTypeLabel());
			ivjVerticalBox.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_EXPAND, getPagebook1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVerticalBox;
}
/**
 * Return the Vertical Box1 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getVerticalBox1() {
	if (ivjVerticalBox1 == null) {
		try {
			ivjVerticalBox1 = new com.ibm.ulc.application.ULCBox(2, 1);
			ivjVerticalBox1.add(0, 0, getPleaseLabel());
			ivjVerticalBox1.add(0, 1, getFillOutLabel());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVerticalBox1;
}
/**
 * Return the Vertical Box2 property value.
 * @return com.ibm.ulc.application.ULCBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCBox getVerticalBox2() {
	if (ivjVerticalBox2 == null) {
		try {
			ivjVerticalBox2 = new com.ibm.ulc.application.ULCBox(3, 1);
			ivjVerticalBox2.add(0, 0, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getTransmissionGroupBox());
			ivjVerticalBox2.add(0, 1, com.ibm.ulc.base.IDefaults.BOX_EXPAND_CENTER, getAirGroupBox());
			ivjVerticalBox2.add(0, 2, getFiller3());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVerticalBox2;
}
/**
 * Return the WhatTypeLabel property value.
 * @return com.ibm.ulc.application.ULCLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private com.ibm.ulc.application.ULCLabel getWhatTypeLabel() {
	if (ivjWhatTypeLabel == null) {
		try {
			ivjWhatTypeLabel = new com.ibm.ulc.application.ULCLabel("What type of car would you like?");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjWhatTypeLabel;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	connPtoP1SetTarget();
	connPtoP3SetTarget();
	connPtoP2SetTarget();
	connPtoP4SetTarget();
	connPtoP5SetTarget();
	connPtoP6SetTarget();
	connPtoP7SetTarget();
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		// user code begin {2}
		// user code end
		setComponent(getVerticalBox());
		getAvailableCarSpecPatternTableModel();
		getRowModel1();
		getRadioGroup1();
		initConnections();
		// user code begin {3}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {4}
	finalInitialize();
	zzzTest();
	// user code end
}
/**
 * Please do not use or rely on this method. It is used by the VAJava test process.
 * It is public only so that the ULCVajContext class can access the method.
 * It can change at any time, or it could be entirely removed in any update 
 * to the VAJava builder. Thank you.
 * @return com.ibm.ulc.application.ULCComponent
 * @param context com.ibm.ulc.application.ULCVajContext
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public static com.ibm.ulc.application.ULCComponent mainTestConstruction(com.ibm.ulc.application.ULCVajContext context) {
	return new CarForm(context);
}
/**
 * Make the getter available to the package.
 * @return com.ibm.ulc.application.ULCField
 */
ULCTable pGetAvailableCarSpecTable() {
	return getAvailableCarSpecTable();
}
/**
 * Save the changes to the model.
 * Subclasses can override this to save widget state in the model.
 *
 * Creation date: (07.01.00 14:32:52)
 */
public void saveInput() {
	ContractSpec contract= getContractSpecFormModel().getContractSpec();
	CarSpec car= contract.getCarSpec();
	AvailableCarSpecPattern selectedPattern= getSelectedCarSpecPattern();
	CarClass selectedCarClass= selectedPattern==null ? null : selectedPattern.getCarClass();
	
	contract.getCarSpec().setCarClass(selectedCarClass);
	if (selectedPattern==null) return;

	if (!selectedPattern.hasManyTransmission())
		car.setTransmission(selectedPattern.getTransmission()[0]);
	if (!selectedPattern.hasManyAirConditioning())
		car.setAirConditioning(selectedPattern.getAirConditioning()[0]);
}
/**
 * Sets the contractSpecFormModel property (com.ibm.ulc.examples.carRental.views.ContractSpecFormModel) value.
 * @param contractSpecFormModel The new value for the property.
 * @see #getContractSpecFormModel
 */
public void setContractSpecFormModel(ContractSpecFormModel contractSpecFormModel) {
	fContractSpecFormModel = contractSpecFormModel;
	//
	getPagebook1().setFormModel(contractSpecFormModel);
	getManualRadioButton().setFormModel(contractSpecFormModel);
	getAutomaticRadioButton().setFormModel(contractSpecFormModel);
	getAirConditioningCheckBox().setFormModel(contractSpecFormModel);
}
/**
 * Insert the method's description here.
 * Creation date: (10.01.00 09:42:44)
 */
protected void setFonts() {
	super.setFonts();
	getWhatTypeLabel().setFont(HUGE_LABEL_FONT);
	//
	getPleaseLabel().setFont(LARGE_LABEL_FONT);
	//
}
/**
 * Set the size of notebooks and pagebooks,
 * which is mandatory!
 *
 * Creation date: (06.01.00 22:27:49)
 */
protected void sizeNoteAndPageBooks() {
	/* Setting the layout parameters with the property sheets
	 * in the composition editor, makes the edit time layout
	 * too poor: we have to set H and W by code
	 */
	getPagebook1().setHeight(368); 
	getPagebook1().setWidth(424);
	getTransmissionPagebook().setHeight(72); 
	getTransmissionPagebook().setWidth(180);
	getAirPagebook().setHeight(46); 
	getAirPagebook().setWidth(180);
}
/**
 * Insert the method's description here.
 * Creation date: (10.01.00 10:36:25)
 */
protected void zzzTest() {
	getAvailableCarSpecPatternTableModel()
		.setRows(getDataAccessor().getAvailableCarSpecsPatternsFor(null));
}
}
