package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.AvailableCarSpecPattern;

/**
 * TableModel adapter for AvailableCarClassPatterns.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */


public class AvailableCarSpecPatternTableModel extends com.ibm.ulc.application.ULCTableModel {
	/**
	 * the rows
	 * @serial
	 */
	 protected AvailableCarSpecPattern[] fCarSpecPatterns= null;
/**
 * AvailableCarSpecPatternTableModel constructor comment.
 */
public AvailableCarSpecPatternTableModel() {
	super();
}
/**
 * AvailableCarSpecPatternTableModel constructor comment.
 * @param prefetch int
 */
public AvailableCarSpecPatternTableModel(int prefetch) {
	super(prefetch);
}
/**
 * AvailableCarSpecPatternTableModel constructor comment.
 * @param prefetch int
 * @param policy int
 */
public AvailableCarSpecPatternTableModel(int prefetch, int policy) {
	super(prefetch, policy);
}
/**
 * AvailableCarSpecPatternTableModel constructor comment.
 * @param prefetch int
 * @param veto boolean
 * @param policy int
 */
public AvailableCarSpecPatternTableModel(int prefetch, boolean veto, int policy) {
	super(prefetch, veto, policy);
}
/**
 * AvailableCarSpecPatternTableModel constructor comment.
 * @param veto boolean
 */
public AvailableCarSpecPatternTableModel(boolean veto) {
	super(veto);
}
/**
 * AvailableCarSpecPatternTableModel constructor comment.
 * @param veto boolean
 * @param policy int
 */
public AvailableCarSpecPatternTableModel(boolean veto, int policy) {
	super(veto, policy);
}
/**
 * getRowAt method comment.
 */
public Object getRowAt(int row) {
	return fCarSpecPatterns[row];
}
/**
 * getRowCount method comment.
 */
public int getRowCount() {
	return fCarSpecPatterns==null ? 0 : fCarSpecPatterns.length;
}
/**
 * getValueAt method comment.
 */
public Object getValueAt(String attributeName, int rowIndex) {
	AvailableCarSpecPattern pattern= fCarSpecPatterns[rowIndex];
	if (attributeName.equals("name"))
		return pattern.getName();
	if (attributeName.equals("transmissionChoices")) 
		return pattern.getTransmissionString();
	if (attributeName.equals("airConditioningChoices"))
		return pattern.getAirConditioningString();

	return null;
}
/**
 * Set the rows of the model.
 * Creation date: (06.01.00 17:36:33)
 * @param patterns com.ibm.ulc.examples.carRental.model.AvailableCarSpecPattern[]
 */
public void setRows(AvailableCarSpecPattern[] patterns) {
	fCarSpecPatterns= patterns;
}
}
