package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.application.IUsesVajContext;
import com.ibm.ulc.application.ULCVajComposite;
import com.ibm.ulc.application.ULCFont;
import com.ibm.ulc.application.ULCShell;
import com.ibm.ulc.examples.carRental.model.Country;
import com.ibm.ulc.examples.carRental.model.RateScheme;
import com.ibm.ulc.examples.carRental.model.DataAccessor;

/**
 * Common superclass for all composites used in the application;
 * Takes care about fonts, sizing notebooks and
 * offers some convenience methods.
 *
 */

public class AbstractComposite extends ULCVajComposite {
	/**
	 * A reference to the parent shell
	 * @serial
	 */
	protected ULCShell fShell = null;
	/**
	 * The normal label font.
	 */
	public ULCFont NORMAL_LABEL_FONT = new ULCFont("sansserif.bold", 1, 12);

	/**
	 * The large label font.
	 */
	public ULCFont LARGE_LABEL_FONT = new ULCFont("sansserif", 0, 14);

	/**
	 * The huge label font.
	 */
	public ULCFont HUGE_LABEL_FONT = new ULCFont("sansserif.bold", 1, 18);
/**
 * AbstractComposite constructor comment.
 */
public AbstractComposite() {
	super();
}
/**
 * AbstractComposite constructor comment.
 */
public AbstractComposite(IUsesVajContext usesVajContext) {
	super();
	if (usesVajContext != null)
		fVajContext = usesVajContext.getVajContext();
}
/**
 * Do the final part initializations here.
 * Creation date: (06.01.00 22:27:49)
 */
protected void finalInitialize() {
	setFonts();
	sizeNoteAndPageBooks();
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	fShell = null;
	NORMAL_LABEL_FONT = null;
	LARGE_LABEL_FONT = null;
	HUGE_LABEL_FONT = null;
}
/**
 * Convenience.
 * Creation date: (06.01.00 18:09:14)
 * @return com.ibm.ulc.examples.carRental.model.Country[]
 */
protected Country[] getAllCountriesSortedByName() {
	return getDataAccessor().getCountriesSortedByName();
}
/**
 * Convenience.
 * Creation date: (06.01.00 18:09:14)
 * @return com.ibm.ulc.examples.carRental.model.RateScheme[]
 */
protected RateScheme[] getAllRateSchemes() {
	return getDataAccessor().getRateSchemes();
}
/**
 * Convenience.
 * Creation date: (06.01.00 18:09:14)
 * @return com.ibm.ulc.examples.carRental.model.DataAccessor
 */
protected DataAccessor getDataAccessor() {
	return DataAccessor.instance();
}
/**
 * Set the fonts of the subparts.
 * Creation date: (06.01.00 22:27:49)
 */
protected void setFonts() {}
/**
 * Set the reference to the parent shell of the receiver;
 * subclasses should override this to propagate the reference
 * to child composites.
 *
 * Creation date: (11.01.00 11:27:09)
 * @param shell com.ibm.ulc.application.ULCShell
 */
public void setShell(ULCShell shell) {
	fShell= shell;
}
/**
 * Set the size of notebooks and pagebooks,
 * which is mandatory!
 *
 * Creation date: (06.01.00 22:27:49)
 */
protected void sizeNoteAndPageBooks() {}
}
