package com.ibm.ulc.examples.carRental.model;

import java.util.Date;

/**
 * Instances represent a sales point.
 */
public class Location extends FinalPersistentObject {
	/**
	 * The address of the location.
	 */
	 protected String fAddress= null;
	/**
	 * The city of the location.
	 */
	 protected String fCity= null;
	/**
	 * The state of the location.
	 */
	 protected String fState= null;
	/**
	 * The country of the location.
	 */
	 protected Country fCountry= null;
	/**
	 * The phone number of the location.
	 */
	 protected String fPhone= null;
	/**
	 * The fax number of the location.
	 */
	 protected String fFax= null;
	/**
	 * The telex number of the location.
	 */
	 protected String fTelex= null;
	/**
	 * The opening schedule of the location.
	 */
	 protected OpeningSchedule fOpeningSchedule= null;
	/**
	 * The key to use to contruct a URL for the map of the location.
	 */
	 protected String[] fMapKey= null;
	/**
	 * The time zone offset of the location (in seconds).
	 */
	 protected long fTimeOffset= 0;
/**
 * Insert the method's description here.
 * 
 * Creation date: (13.12.99 13:11:46)
 * @param id java.lang.String
 * @param name java.lang.String
 */
public Location(String id, String name) {
	super(id, name);
	}
/**
 * Gets the address property (String) value.
 * @return The address property value.
 * @see #setAddress
 */
public String getAddress() {
	return fAddress;
}
/**
 * Gets the city property (String) value.
 * @return The city property value.
 * @see #setCity
 */
public String getCity() {
	return fCity;
}
/**
 * fCountry getter.
 * 
 * Creation date: (13.12.99 11:32:40)
 * @return com.ibm.ulc.examples.carRental.model.Country
 */
public Country getCountry() {
	return fCountry;
}
/**
 * Convenience: answer the receiver's country name.
 * 
 * Creation date: (11.1.00 11:32:40)
 * @return String
 */
public String getCountryName() {
	return fCountry.getName();
}
/**
 * Gets the fax property (String) value.
 * @return The fax property value.
 * @see #setFax
 */
public String getFax() {
	return fFax;
}
/**
 * Convenience: answer the receiver's opening schedule in textual form.
 * 
 * Creation date: (11.1.00 11:32:40)
 * @return String
 */
public String getHoursOfOperation() {
	return fOpeningSchedule.toString();
}
/**
 * Gets the mapKey property (String[]) value.
 * @return The mapKey property value.
 * @see #setMapKey
 */
public String[] getMapKey() {
	return fMapKey;
}
/**
 * Answer a URL String where a map of this is located.
 * 
 * Creation date: (30.12.99 17:05:22)
 * @return java.lang.String
 */
public String getMapUrl() {
	return MapUrl.urlForLocation(getMapKey());
}
/**
 * Gets the openingSchedule property (com.ibm.ulc.examples.carRental.model.OpeningSchedule) value.
 * @return The openingSchedule property value.
 * @see #setOpeningSchedule
 */
public OpeningSchedule getOpeningSchedule() {
	return fOpeningSchedule;
}
/**
 * Gets the phone property (String) value.
 * @return The phone property value.
 * @see #setPhone
 */
public String getPhone() {
	return fPhone;
}
/**
 * fState getter.
 * 
 * Creation date: (13.12.99 11:32:40)
 * @return String
 */
public String getState() {
	return fState;
}
/**
 * Answer a sorted array without repetitions 
 * of all states of the given locations.
 * 
 * Creation date: (30.12.99 12:34:36)
 * @return java.lang.String[]
 * @param locations com.ibm.ulc.examples.carRental.model.Location[]
 */
public static String[] getStatesFor(Location[] locations) {

	// If the collection is empty, we are done.
	if (locations.length==0) return new String[0];
	
	// We can assume that there are locations!
	String[] allStates= new String[locations.length];
	for (int i=0; i<locations.length; i++) {
		allStates[i]= locations[i].getState();
	}
	
	// Sorting and counting how many distinct elements there are.
	ArrayExtensions.sort(allStates,new Comparator() {
		public int compare(Object s1, Object s2) {
			return ((String)s1).compareTo((String)s2);
		}
	});
	int cardinality= 1;
	for (int i=1; i<allStates.length; i++) {
		if (! allStates[i].equals(allStates[i-1]))
			cardinality++;
	}

	// Create the array without repetitions
	String[] allUnified= new String[cardinality];
	allUnified[0]= allStates[0];
	int nextFree= 1;
	for (int i=1; i<allStates.length; i++) {
		if (! allStates[i].equals(allStates[i-1])) {
			allUnified[nextFree]= allStates[i];
			nextFree++;
		}
	}
	
	return allUnified;
}
/**
 * Gets the telex property (String) value.
 * @return The telex property value.
 * @see #setTelex
 */
public String getTelex() {
	return fTelex;
}
/**
 * Gets the timeOffset property (long) value.
 * @return The timeOffset property value.
 * @see #setTimeOffset
 */
public long getTimeOffset() {
	return fTimeOffset;
}
/**
 * dateAndTime are in UTC; local DST is not considered.
 * 
 * Creation date: (30.12.99 16:13:52)
 * @return boolean
 * @param dateAndTime java.util.Date
 */
public boolean isOpenAt(Date dateAndTime) {
	long localTime= dateAndTime.getTime()+fTimeOffset;
	return fOpeningSchedule.isOpenAt(new Date(localTime));
}
/**
 * Sets the address property (String) value.
 * @param address The new value for the property.
 * @see #getAddress
 */
public void setAddress(String address) {
	fAddress = address;
}
/**
 * Sets the city property (String) value.
 * @param city The new value for the property.
 * @see #getCity
 */
public void setCity(String city) {
	fCity = city;
}
/**
 * fCountry setter.
 * 
 * Creation date: (13.12.99 14:17:08)
 * @param country com.ibm.ulc.examples.carRental.model.Country
 */
public void setCountry(Country country) {
	fCountry= country;
	}
/**
 * Sets the fax property (String) value.
 * @param fax The new value for the property.
 * @see #getFax
 */
public void setFax(String fax) {
	fFax = fax;
}
/**
 * Sets the mapKey property (String[]) value.
 * @param mapKey The new value for the property.
 * @see #getMapKey
 */
public void setMapKey(String[] mapKey) {
	fMapKey = mapKey;
}
/**
 * Sets the openingSchedule property (com.ibm.ulc.examples.carRental.model.OpeningSchedule) value.
 * @param openingSchedule The new value for the property.
 * @see #getOpeningSchedule
 */
public void setOpeningSchedule(OpeningSchedule openingSchedule) {
	fOpeningSchedule = openingSchedule;
}
/**
 * Sets the phone property (String) value.
 * @param phone The new value for the property.
 * @see #getPhone
 */
public void setPhone(String phone) {
	fPhone = phone;
}
/**
 * fState setter.
 * 
 * Creation date: (13.12.99 15:37:34)
 * @param state String
 */
public void setState(String state) {
	fState= state;
}
/**
 * Sets the telex property (String) value.
 * @param telex The new value for the property.
 * @see #getTelex
 */
public void setTelex(String telex) {
	fTelex = telex;
}
/**
 * Sets the timeOffset property (long) value.
 * @param timeOffset The new value for the property.
 * @see #getTimeOffset
 */
public void setTimeOffset(long timeOffset) {
	fTimeOffset = timeOffset;
}
}
