package com.ibm.ulc.examples.carRental.model;

/**
 * Instances describe collections of ints defined
 * as the set of all elements between a minimum and a maximum.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class IntInterval {
	/**
	 * The smallest element of the interval.
	 */ 
	 protected int fMin = 0;
	/**
	 * The largest element of the interval.
	 */ 
	 protected int fMax = -1;
/**
 * WeekDayInterval constructor comment.
 */
public IntInterval() {
	super();
}
/**
 * WeekDayInterval constructor comment.
 * @param min int
 * @param max int
 */
public IntInterval(int min, int max) {
	fMin= min;
	fMax= max;
}
/**
 * Answer the maximum of the interval.
 * 
 * Creation date: (07.12.99 18:06:24)
 * @return int
 */
public int getMax() {
	return fMax;
}
/**
 * Answer the minimum of the interval.
 * 
 * Creation date: (07.12.99 18:06:24)
 * @return int
 */
public int getMin() {
	return fMin;
}
/**
 * Answer true, if the parameter lies between the receiver's
 * min and max.
 * 
 * Creation date: (09.12.99 09:48:23)
 * @return boolean
 * @param element int
 */
public boolean includes(int element) {
	return fMin<=element && element<=fMax;
}
/**
 * Answer the size of the interval defined as follows:
 * if max<min, then size=0;
 * if min=max, then size=1;
 * if min<max, then size=2.
 * 
 * Creation date: (07.12.99 17:56:19)
 * @return int
 */
public int size() {
	if (fMin<fMax)
		return 2;
	else if (fMin==fMax)
		return 1;
	else
		return 0;
}
}
