package com.ibm.ulc.examples.carRental.model;

import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Extensions to the Date class.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class DateExtensions {
/**
 * DateExtensions constructor comment.
 */
public DateExtensions() {
	super();
}
/**
 * Answer the day of the week of the parameter 
 * (1=Sunday..7=Saturday; see GregorianCalendar)
 * 
 * Creation date: (09.12.99 13:07:09)
 * @return int
 * @param date java.util.Date
 */
public static int getDayOfWeek(Date date) {
	GregorianCalendar calendar= new GregorianCalendar();
	calendar.setTime(date);
	return calendar.get(GregorianCalendar.DAY_OF_WEEK);
}
/**
 * Create a new Date object representing just the time of the day.
 * 
 * Creation date: (09.12.99 12:59:10)
 * @return java.util.Date
 * @param h int
 * @param m int
 * @param s int
 */
public static Date newTime(int h, int m, int s) {
	GregorianCalendar cal= new GregorianCalendar();
	cal.set(GregorianCalendar.HOUR_OF_DAY, h);
	cal.set(GregorianCalendar.MINUTE, m);
	cal.set(GregorianCalendar.SECOND, s);
	normalizeCalendar(cal);
	return cal.getTime();
}
/**
 * Set the date (year, month,day) of the parameter to a fixed value,
 * leaving the time fields unchanged, and answer the parameter.
 * 
 * Creation date: (09.12.99 13:03:08)
 * @return java.util.GregorianCalendar
 * @param calendar java.util.GregorianCalendar
 */
protected static GregorianCalendar normalizeCalendar(GregorianCalendar calendar) {
	calendar.set(GregorianCalendar.YEAR,1970);
	calendar.set(GregorianCalendar.MONTH,0);
	calendar.set(GregorianCalendar.DAY_OF_MONTH,1);
	return calendar;
}
/**
 * Set the date (year, month,day) of the parameter to a fixed value,
 * leaving the time fields unchanged, and answer the parameter.
 * 
 * Creation date: (09.12.99 13:03:08)
 * @return java.util.GregorianCalendar
 * @param calendar java.util.GregorianCalendar
 */
public static Date normalizeTime(Date date) {
	GregorianCalendar calendar= new GregorianCalendar();
	calendar.setTime(date);
	calendar.set(GregorianCalendar.YEAR,1970);
	calendar.set(GregorianCalendar.MONTH,0);
	calendar.set(GregorianCalendar.DAY_OF_MONTH,1);
	return calendar.getTime();
}
}
