package com.ibm.ulc.examples.carRental.model;

/**
 * Instances represent the specification of a car; 
 * this includes the car class and some features
 * that are (almost) guaranteed to the customer,
 * like transmission and air conditioning.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class CarSpec extends CarRentalObject {
	/**
	 * The car class
	 */
	 protected CarClass fCarClass = null;
	/**
	 * Does the car have air conditioning?
	 */
	 protected boolean fAirConditioning = false;
	/**
	 * The car's transmission type
	 */
	 protected String fTransmission = "";
	/**
	 * The constant for automatic transmission
	 */
	 public static final String AUTOMATIC_TRANSMISSION = "automatic";
	/**
	 * The constant for manual transmission
	 */
	 public static final String MANUAL_TRANSMISSION = "manual";
/**
 * CarSpec constructor comment.
 */
public CarSpec() {
	super();
}
/**
 * Answer the value of the air conditioning attribute.
 * 
 * Creation date: (07.12.99 15:29:39)
 * @return boolean
 */
public boolean getAirConditioning() {
	return fAirConditioning;
}
/**
 * Answer the value of the car class attribute.
 * 
 * Creation date: (07.12.99 15:29:39)
 * @return boolean
 */
public CarClass getCarClass() {
	return fCarClass;
}
/**
 * Answer the value of the transmission attribute.
 * 
 * Creation date: (07.12.99 15:29:39)
 * @return boolean
 */
public String getTransmission() {
	return fTransmission;
}
/**
 * Answer true if the receiver has complete information.
 * 
 * Creation date: (07.12.99 15:35:13)
 * @return boolean
 */
public boolean isComplete() {
	return fTransmission!=null && fCarClass!=null;
}
/**
 * Set the air conditioning attribute
 * 
 * Creation date: (07.12.99 15:32:15)
 * @param air boolean
 */
public void setAirConditioning(boolean air) {
	fAirConditioning= air;
	}
/**
 * Set the car class attribute
 * 
 * Creation date: (07.12.99 15:32:15)
 * @param air boolean
 */
public void setCarClass(CarClass carClass) {
	fCarClass= carClass;
	}
/**
 * Set the transmission attribute
 * 
 * Creation date: (07.12.99 15:32:15)
 * @param air boolean
 */
public void setTransmission(String transmission) {
	fTransmission= transmission;
	}
}
