package com.ibm.ulc.examples.carRental.model;

/**
 * The instances of this class represent a car class together with
 * its available trasmission and air conditioning choices.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class AvailableCarSpecPattern extends CarRentalObject {
	/**
	 * The car class
	 */
	 protected CarClass fCarClass = null;
	/**
	 * The available air conditioning choices
	 */
	 protected boolean[] fAirConditioning = {false};
	/**
	 * The available transmission choices
	 */
	 protected String[] fTransmission = null;
/**
 * AvailableCarSpecDescription constructor comment.
 */
public AvailableCarSpecPattern() {
	super();
}
/**
 * Answer the possible choices for the air conditioning.
 * Creation date: (11.01.00 15:42:29)
 * @return boolean[]
 */
public boolean[] getAirConditioning() {
	return fAirConditioning;
}
/**
 * Answer a String with 'Y' if air conditioning = true is possible,
 * and with 'N' if air conditioning = false is possible.
 * 
 * Creation date: (07.12.99 15:08:42)
 * @return java.lang.String
 */
public String getAirConditioningString() {
	boolean yes= false;
	boolean no= false;
	for (int i= 0; i<fAirConditioning.length; i++) {
		if (fAirConditioning[i]) {
			yes= true;
		} else {
			no= true;
		}
	}

	StringBuffer buff= new StringBuffer(3);
	if (yes) {
		buff.append('Y');
		if (no) {
			buff.append('/');
		}
	}
	if (no) {
		buff.append('N');
	}
	return buff.toString();
}
/**
 * Get the car class attribute.
 * Creation date: (11.01.00 15:33:34)
 * @return com.ibm.ulc.examples.carRental.model.CarClass
 */
public CarClass getCarClass() {
	return fCarClass;
}
/**
 * Answer the car class'es name.
 * 
 * Creation date: (07.12.99 15:22:40)
 * @return java.lang.String
 */
public String getName() {
	return fCarClass.getName();
}
/**
 * Answer the possible choices for the transmission.
 * Creation date: (11.01.00 15:41:56)
 * @return java.lang.String[]
 */
public String[] getTransmission() {
	return fTransmission;
}
/**
 * Answer a String with 'A' if transmission = "automatic" is possible,
 * and with 'M' if transmission = "manual" is possible.
 * 
 * Creation date: (07.12.99 15:08:42)
 * @return java.lang.String
 */
public String getTransmissionString() {
	boolean auto= false;
	boolean man= false;
	for (int i= 0; i<fTransmission.length; i++) {
		if (fTransmission[i].equals(CarSpec.AUTOMATIC_TRANSMISSION)) {
			auto= true;
		} else if (fTransmission[i].equals(CarSpec.MANUAL_TRANSMISSION)) {
			man= true;
		}
	}

	StringBuffer buff= new StringBuffer(3);
	if (auto) {
		buff.append('A');
		if (man) {
			buff.append('/');
		}
	}
	if (man) {
		buff.append('M');
	}
	return buff.toString();
}
/**
 * Answer true, if the receiver specifies many possible values for air conditioning.
 * 
 * Creation date: (07.12.99 15:03:16)
 * @return boolean
 */
public boolean hasManyAirConditioning() {
	return fAirConditioning.length > 1;
}
/**
 * Answer true, if the receiver specifies many possible values for transmission
 * 
 * Creation date: (07.12.99 15:04:18)
 * @return boolean
 */
public boolean hasManyTransmission() {
	return fTransmission.length > 1;
}
/**
 * Test whether aCarSpec satisfies the receiver description:
 * answer true on success, false on failure.
 * 
 * Creation date: (07.12.99 15:06:19)
 * @return boolean
 * @param carSpec com.ibm.ulc.examples.carRental.model.CarSpec
 */
public boolean matches(CarSpec carSpec) {
	return false;
}
/**
 * Set the air conditioning attribute.
 *
 * Creation date: (07.12.99 14:58:11)
 * @param possibleValues boolean[]
 */
public void setAirConditioning(boolean[] possibleValues) {
	fAirConditioning= possibleValues;
	}
/**
 * Set the car class attribute.
 *
 * Creation date: (07.12.99 14:59:54)
 * @param carClass com.ibm.ulc.examples.carRental.model.CarClass
 */
public void setCarClass(CarClass carClass) {
	fCarClass= carClass;
	}
/**
 * Set the transmission attribute.
 * 
 * Creation date: (07.12.99 15:01:56)
 * @param possibleValues java.lang.String[]
 */
public void setTransmission(String[] possibleValues) {
	fTransmission= possibleValues;
	}
}
