package com.ibm.ulc.examples.Dossier;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.*;
import java.io.*;
import java.util.*;
public class Dossier extends ULCContext implements ISortListener, ISelectionChangedListener {
	protected Customers fCustomers = null;
	protected CustomerFormModel fFormModel = null;
	protected Editor fEditor = null;
	protected ULCAlert fAlert = null;
	protected ULCApplication fApp = null;
	protected ULCTable fTable = null;
	protected ULCShell fShell = null;
	protected ULCField fField = null;
	protected ULCMenuBar fMenuBar = null;
	protected ULCMenu fLookAndFeelMenu = null;
	public ULCIcon fRed;
	public ULCIcon fGreen;
	public ULCIcon fHead;
	public ULCIcon fAscending, fDescending;
	protected UlcHashtable fItemLists = null;
	public Dossier() {
		fCustomers= new Customers(getClass().getResource("customers.any"));
	}
/**
 * called from editor after editor's "add" button has been pressed
 */
public void addNewCustomer() {
	fEditor.hide();
	fFormModel.saveInput();
	Customer c = fFormModel.getCustomer();
	if (c != null)
		setSelection(fCustomers.add(c));
}
public ULCMenu createLookAndFeelMenu() {
	if (fLookAndFeelMenu == null) {
		fLookAndFeelMenu = new ULCMenu("Look");
		fLookAndFeelMenu.setMnemonic('L');
		//Obtain the existing LookAndFeel objects
		Vector looks = getInstalledLookAndFeels();
		if (looks != null) {
			Enumeration allLooks = looks.elements();
			while (allLooks.hasMoreElements()) {
				Look aLook = (Look) allLooks.nextElement();
				ULCMenuItem mi = new ULCMenuItem(aLook.getName());
				mi.addActionListener(new SwitchLookAction(this, aLook.getClassName()));
				fLookAndFeelMenu.add(mi);
			}
		}
	}
	return fLookAndFeelMenu;
}
public void createPopupMenu(ULCField component) {
	ULCMenu popupMenu = new ULCMenu("Popup Menu");
	ULCMenuItem mi = new ULCMenuItem("Cut");
	mi.addActionListener(new CutCopyPasteAction(this, component, "cut"));
	mi.setEnabler(component);
	popupMenu.add(mi);
	mi = new ULCMenuItem("Copy");
	mi.addActionListener(new CutCopyPasteAction(this, component, "copy"));
	mi.setEnabler(component);
	popupMenu.add(mi);
	mi = new ULCMenuItem("Paste");
	mi.addActionListener(new CutCopyPasteAction(this, component, "paste"));
	popupMenu.add(mi);
	popupMenu.addSeparator();
	ULCMenu nestedPopupMenu = new ULCMenu("Nested Popup");
	mi = new ULCMenuItem("Cut");
	mi.addActionListener(new CutCopyPasteAction(this, component, "cut"));
	mi.setEnabler(component);
	nestedPopupMenu.add(mi);
	mi = new ULCMenuItem("Copy");
	mi.addActionListener(new CutCopyPasteAction(this, component, "copy"));
	mi.setEnabler(component);
	nestedPopupMenu.add(mi);
	mi = new ULCMenuItem("Paste");
	mi.addActionListener(new CutCopyPasteAction(this, component, "paste"));
	nestedPopupMenu.add(mi);
	nestedPopupMenu.add(new ULCCheckboxMenuItem("Toggle Item"));
	popupMenu.add(nestedPopupMenu);
	component.setPopupMenu(popupMenu);
}
public void createTablePopupMenu(ULCTable component) {
	ULCMenu popupMenu = new ULCMenu("Table Popup Menu");
	
	ULCMenuItem mi = new ULCMenuItem("Edit");
	mi.addActionListener(new EditAction(this));
	mi.setEnabler(component);
	popupMenu.add(mi);
	
	mi = new ULCMenuItem("New");
	mi.addActionListener(new NewAction(this));
	popupMenu.add(mi);
	
	component.setPopupMenu(popupMenu);
}
public ULCToolBar createToolBar() {
	ULCToolBar toolBar = new ULCToolBar();
	ULCButton button = new ULCButton("", new ULCIcon(getClass().getResource("save.gif")));
	button.setToolTipText(getResourceString("TTTxtMnuSave"));
	toolBar.add(button);
	toolBar.add(new ULCSeparator());
	button = new ULCButton("", new ULCIcon(getClass().getResource("cut.gif")));
	button.setToolTipText(getResourceString("TTTxtMnuCut"));
	button.addActionListener(new CutCopyPasteAction(this, fField, "cut"));
	toolBar.add(button);
	button = new ULCButton("", new ULCIcon(getClass().getResource("copy.gif")));
	button.setToolTipText(getResourceString("TTTxtMnuCopy"));
	button.addActionListener(new CutCopyPasteAction(this, fField, "copy"));
	toolBar.add(button);
	button = new ULCButton("", new ULCIcon(getClass().getResource("paste.gif")));
	button.setToolTipText(getResourceString("TTTxtMnuPaste"));
	button.addActionListener(new CutCopyPasteAction(this, fField, "paste"));
	toolBar.add(button);
	return toolBar;
}
public void deleteCustomer() {
	Vector s = fTable.getSelectedTableModelIndices();
	if (s.size() > 0) {
		int ix = ((Integer) s.elementAt(0)).intValue();
		deleteCustomerAt(ix);
	}
}
   public void deleteCustomerAt(int x) {
		if (x >= 0) {
			if (fFormModel.isCurrent(x) && fEditor != null)
				fEditor.hide();
			fCustomers.delete(x);
		}
	}
public void editCustomer() {
	Vector s = fTable.getSelectedTableModelIndices();
	if (s.size() > 0) {
		int ix = ((Integer) s.elementAt(0)).intValue();
		editCustomerAt(ix);
	}
}
public void editCustomerAt(int x) {
	fFormModel.setCustomer(fCustomers, x);
	showEditor("Save");
}
	public void findCustomer(String name) {
		fShell.setCursor(ULCCursor.WAIT_CURSOR);
		int index= fCustomers.findIndexOf(name);
		if (index >= 0)
			setSelection(index);
		else
			beep();
		fShell.setCursor(ULCCursor.DEFAULT_CURSOR);
	}
/**
  * Empty implementation of method from ICallable protocol.
  * perform any resource deallocation necessary after this object has been destroyed.
  */
public void free() {
	super.free();
	fCustomers = null;
	fFormModel = null;
	fEditor = null;
	fAlert = null;
	fApp = null;
	fTable = null;
	fShell = null;
	fField = null;
	fMenuBar = null;
	fLookAndFeelMenu = null;
	fRed = null;
	fGreen = null;
	fHead = null;
	fAscending = null;
	fDescending = null;
	fItemLists = null;
}
public ULCIcon getAscendingIcon() {
	if (fAscending == null)
		fAscending = new ULCIcon(getClass().getResource("ascending.gif"));
	return fAscending;
}
/**
 * Return a user defined error message for connection
 * down errors.
 *
 * This message will be displayed to the user in a dialog box
 * if the connection or the ULC side goes down.
 *
 * @since	R3.1
 * @return	The <code>String</code> which should be used as error message
 *			if <code>null</code> is returned, then no message will be displayed
 */
public String getConnDownErrorMsg() {
	return 	"Connection to ULC Dossier server terminated because connection lost or server shutdown";
}
public ULCIcon getDescendingIcon() {
	if (fDescending == null)
		fDescending = new ULCIcon(getClass().getResource("descending.gif"));
	return fDescending;
}
/**
 * Returns the Resource Bundle base file name
 * Subclasses must implement that method to return the correct file name.
 *
 * @return <code>String</code>
 */
public String getResourceBundleBaseFileName() {
	return "dossierstrings";
}
/**
 * A sort request has been received, build a SortedItemList for the specified column
 * or return the existing ULCSortedItemList for the column if it already exists.
 */
public ULCSortedItemList itemListFor(ULCSortEvent sortEvent) {
	if (fItemLists == null)
		fItemLists = new UlcHashtable();
	String attribute = sortEvent.getCurrentSortColumn().getAttributeName();
	Object o = fItemLists.get(attribute);
	ULCSortedItemList itemList = null;
	if (o == null) {
		itemList = new ULCSortedItemList();
		itemList.setModel(sortEvent.getTable().getTableModel());
		fItemLists.put(attribute, itemList);
		String[] attr = new String[1];
		attr[0] = attribute;
		itemList.setAttributeNames(attr);
	} else
		itemList = (ULCSortedItemList) o;
	return itemList;
}
	public static
	void main(String args[]) {
		ULC.run(args, Dossier.class);
	}
	public void newCustomer() {
		fFormModel.setCustomer(new Customer());
		showEditor("Add");
	}
public void quit() {
	if (fAlert == null)
		fAlert = new ULCAlert(fShell, "Please Confirm", "Do you really want to quit?", "Yes", "No");
	if (fAlert.ask().equals("Yes"))
	 // 1FQTOSC
	 // In JDK1.2 we get two windowClosingEvent so ensure that fApp is still valid
	 // This bug seems to have been fixed in JRE 1.2.2
		if (fApp != null)
			fApp.terminate();
}
	/**
	 * called from editor after editor's "save" button has been pressed
	 */
	public void saveChanges() {
		//fEditor.hide();
		fFormModel.saveInput();
	}
	public void saveCustomers() {
		fCustomers.save();
	}
public void selectionChanged(ULCSelectionChangedEvent e) {
	// if dubl-click start editor
	if (e.getCmd("").equals("action")) {
		Vector s = fTable.getSelectedTableModelIndices();
		if (s.size() > 0) {
			int ix = ((Integer) s.elementAt(0)).intValue();
			editCustomerAt(ix);
		}
	}
}
public void setSelection(int s) {
	if (fTable != null) {
		Vector sel = new Vector();
		sel.addElement(new Integer(s));
		fTable.setSelectedTableModelIndices(sel);
		if (s >= 0)
			fTable.ensureTableModelIndexIsVisible(s);
	}
}
	public void showEditor(String s) {
		if (fEditor == null) {
	   		fEditor= new Editor(fFormModel, this);
	   		fApp.add(fEditor.getShell());
	   	}
		fEditor.show(s);
	}
/**
 * A sort request has been received, set the sortedItem list for the table based on the column selected
 * and set the icons for the column header to the ascending or descending icon.
 */
public void sortRequested(ULCSortEvent sortEvent) {
	startBatchingRequests();
	ULCSortedItemList itemList = itemListFor(sortEvent);
	boolean ascending = itemList.isAscending();
	ULCColumn lastcol = sortEvent.getLastColumnSorted();
	ULCColumn currentcol = sortEvent.getCurrentSortColumn();
	if (lastcol == currentcol) {
		ascending = !ascending;
		itemList.setAscending(ascending);
	}
	ULCColumn.swapHeaderIcon(lastcol, currentcol, getAscendingIcon(), getDescendingIcon(), ascending);
	sortEvent.getTable().setItemList(itemList);
	stopBatchingRequests();
}
public void start() {
	fApp = new ULCApplication(this);
	fFormModel = new CustomerFormModel();
	fHead = new ULCIcon(getClass().getResource("a1.gif"));
	fGreen = new ULCIcon(getClass().getResource("green-ball.gif"));
	fRed = new ULCIcon(getClass().getResource("red-ball.gif"));
	fShell = new ULCShell(getResourceString("LblDossier"), true); // receive CloseBox events
	fShell.setIcon(fHead);
	fShell.addWindowClosingListener(new WinCloseAction(this));
	fApp.add(fShell);
	ULCBox vbox = new ULCVBox(10);
	ULCBox buttons = new ULCHBox(15);
	ULCBox find = new ULCHBox(15);
	ULCBox header = new ULCHBox(15);
	final ULCFont boldfont = new ULCFont("Dialog", ULCFont.BOLD, 18);
	final ULCButton editButton = new ULCButton(getResourceString("ButEdit"));
	editButton.setDisableOnAction(true);
	final ULCButton deleteButton = new ULCButton(getResourceString("ButDelete"));
	final ULCButton newButton = new ULCButton(getResourceString("ButNew"));
	fField = new ULCField(30);
	ULCMenu file = new ULCMenu(getResourceString("MnuFile"), 'F');
	file.setToolTipText(getResourceString("TTTxtMnuFile"));
	ULCMenuItem mi = new ULCMenuItem(getResourceString("MnuSave"), new SaveAction(this));
	mi.setToolTipText(getResourceString("TTTxtMnuSave"));
	mi.setAccelerator('S', 8, true); //InputEvent.ALT_MASK=8
	mi.setMnemonic('S');
	file.add(mi);
	IActionListener quit = new QuitAction(this);
	IActionListener restart = new RestartAction(this);
	IActionListener reconnect = new ReconnectAction(this);
	IActionListener synch = new SynchAction(this);
	IActionListener kill = new KillAction(this);
	file.addSeparator();
	IActionListener findAction = new FindAction(this, fField);
	mi = new ULCMenuItem(getResourceString("MnuQuit"), quit);
	mi.setToolTipText(getResourceString("TTTxtMnuQuit"));
	mi.setMnemonic('Q');
	file.add(mi);
	ULCMenu edit = new ULCMenu(getResourceString("MnuEdit"), 'E');
	edit.setToolTipText(getResourceString("TTTxtMnuEdit"));
	mi = new ULCMenuItem(getResourceString("MnuUndo"));
	mi.setToolTipText(getResourceString("TTTxtMnuUndo"));
	edit.add(mi);
	edit.addSeparator();
	mi = new ULCMenuItem(getResourceString("MnuCut"), new ULCIcon(getClass().getResource("cut.gif")));
	mi.setAccelerator('X', 2, true); //InputEvent.CTRL_MASK=2
	mi.setToolTipText(getResourceString("TTTxtMnuCut"));
	mi.addActionListener(new CutCopyPasteAction(this, fField, "cut"));
	edit.add(mi);
	mi = new ULCMenuItem(getResourceString("MnuCopy"), new ULCIcon(getClass().getResource("copy.gif")));
	mi.setAccelerator('C', 2, true);
	mi.setToolTipText(getResourceString("TTTxtMnuCopy"));
	mi.addActionListener(new CutCopyPasteAction(this, fField, "copy"));
	edit.add(mi);
	mi = new ULCMenuItem(getResourceString("MnuPaste"), new ULCIcon(getClass().getResource("paste.gif")));
	mi.setAccelerator('V', 2, true);
	mi.setToolTipText(getResourceString("TTTxtMnuPaste"));
	mi.addActionListener(new CutCopyPasteAction(this, fField, "paste"));
	edit.add(mi);
	edit.addSeparator();
	ULCCheckboxMenuItem cmi = new ULCCheckboxMenuItem(getResourceString("MnuEnableShellResize"));
	cmi.setSelected(true);
	cmi.setToolTipText(getResourceString("TTTxtEnableShellResize"));
	cmi.setMnemonic('R');
	cmi.addActionListener(new ShellResizeAction(this));
	edit.add(cmi);
	ULCMenu sm = new ULCMenu("UI Server");
	sm.add(new ULCMenuItem("Restart UI connection", restart));
	sm.add(new ULCMenuItem("Reconnect to UI", reconnect));
	sm.add(new ULCMenuItem("Synchronize", synch));
	sm.add(new ULCMenuItem("Kill UI", kill));
	ULCMenu debug = new ULCMenu("Debug");
	debug.add(sm);
	fMenuBar = new ULCMenuBar();
	fMenuBar.add(file);
	fMenuBar.add(edit);
	// mb.add(debug);

	fMenuBar.add(createLookAndFeelMenu());
	fShell.setMenuBar(fMenuBar);
	fShell.add(vbox);
	ULCLabel il = new ULCLabel(fHead);
	il.setToolTipText(getResourceString("TTTxtLblHeader"));
	header.add(il);
	header.add("lc", new ULCLabel(boldfont, getResourceString("LblDossier")));
	vbox.add("lc", createToolBar());
	vbox.add("lt", header);
	ULCButton findbutton = new ULCButton(getResourceString("ButFind"), findAction);
	findbutton.setEnabler(fField);
	findbutton.setMnemonic('I');
	findbutton.setToolTipText(getResourceString("TTTxtButFind"));
	fField.setToolTipText(getResourceString("TTTxtFldFind"));
	find.add("lc", findbutton);
	find.add("ec", fField);
	vbox.add("et", find);
	fTable = new ULCTable(fCustomers, 300, 10);
	//fTable.setRowHeight(100);
	//fTable.setAutoResize(ULCTable.AUTO_RESIZE_LAST_COLUMN); 
	fTable.setAutoResize(TABLE_AUTO_RESIZE_ALL_COLUMNS);
	// fTable.setAutoResize(ULCTable.AUTO_RESIZE_OFF);
	ULCColumn firstColumn= new ULCColumn("Icon", "", 16);
	firstColumn.setToolTipText("IconText");
	fTable.addColumn(firstColumn);
	fTable.addColumn("FirstName", getResourceString("ColFirstName"), false, 100);
	fTable.addColumn("LastName", getResourceString("ColLastName"), false, 100);
	fTable.addColumn("Title", getResourceString("ColTitle"), 40);
	fTable.addColumn("Member", getResourceString("ColMember"), true, new ULCCheckbox());
	ULCColumn lastCol= new ULCColumn("Skill", getResourceString("ColSkill"));
	lastCol.setEditable(false);
	lastCol.setToolTipText("SkillText");
	fTable.addColumn(lastCol);
	editButton.setEnabler(fTable);
	editButton.setMnemonic('T');
	deleteButton.setEnabler(fTable);
	deleteButton.setMnemonic('D');
	fTable.addSelectionChangedListener(this);
	fTable.setToolTipText("ULCTable Tooltip");
	fTable.addSortListener(this);
	vbox.add("ee", fTable);
	// 
	vbox.add("et", buttons);
	editButton.setEnabled(false);
	editButton.setToolTipText(getResourceString("TTTxtButEdit"));
	editButton.addActionListener(new EditAction(this));
	buttons.add(editButton);
	newButton.setToolTipText(getResourceString("TTTxtButNew"));
	newButton.addActionListener(new NewAction(this));
	newButton.setMnemonic('N');
	buttons.add(newButton);
	deleteButton.setEnabled(false);
	deleteButton.setToolTipText(getResourceString("TTTxtButDelete"));
	deleteButton.addActionListener(new DeleteAction(this));
	buttons.add(deleteButton);
	createPopupMenu(fField);
	createTablePopupMenu(fTable);
	fShell.setDefaultButton(newButton);
	fShell.setVisible(true);
}
}
