package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.application.*;
import java.net.*;
import java.awt.event.*;
/**
 * This class provides the actions required for an Html pane.
 */
class SetDocumentPageAction extends Object implements IActionListener, IValueChangedListener, IHyperLinkListener {
	private ULCHtmlPane fHtmlPane= null;
	private ULCField fField= null;
	private ULCBrowserContext fBrowserContext= null;
/**
 * (c) Object Technology International.
 * @param browserContext com.ibm.ulc.application.ULCBrowserContext
 * @param field com.ibm.ulc.application.ULCField
 */
public SetDocumentPageAction(ULCBrowserContext browserContext, ULCField field) {
	fBrowserContext= browserContext;
	fField= field;
}
/**
 * (c) Object Technology International.
 * @param htmlPane com.ibm.ulc.application.ULCHtmlPane
 * @param field com.ibm.ulc.application.ULCField
 */
public SetDocumentPageAction(ULCHtmlPane htmlPane, ULCField field) {
	fHtmlPane= htmlPane;
	fField= field;
}
public void actionPerformed(ULCActionEvent e) {
	if (e.getSource().getClass() == ULCField.class) {
		try {
			URL u = new URL((String) fField.getValue());
			fHtmlPane.setUrl(u);
		} catch (Exception ex) {
		};
	} else {
		try {
			URL u = new URL((String) fField.getValue());
			fBrowserContext.showDocument(u);
		} catch (Exception ex) {
		};
	}
}
public void linkActivated(ULCLinkActivatedEvent e) {
	fHtmlPane.setPage(e.getUrlString());
	fField.setValue(e.getUrlString());
}
public void linkError(ULCLinkErrorEvent e) {
}
public void valueChanged(ULCValueChangedEvent e) {
	if (fBrowserContext == null) {
		try {
			URL u = new URL((String) fField.getValue());
			fHtmlPane.setUrl(u);
		}
		catch (Exception ex) {
		}
	}
}
}
