package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;

/**
 * This is the business-specific application class, which interacts
 * with ULC only via a separate adapter class.
 */
public class Customer {
	private int fId; 				//for unique identification only, not displayed.		
	private String fLastName;
	private String fFirstName;
	private Address fAddress;
	private Vector fAccounts;
	private Vector fCredits;
public Customer() {
	fId= (int) (Math.random() * 100000); 	// Allocate a random id to each new customer.
	fAccounts= new Vector();
	fCredits= new Vector();
}
public Customer(String lastName, String firstName, Address address) {
	this();
	setLastName(lastName);
	setFirstName(firstName);
	setAddress(address);
}
/** 
 * Add the given new accounts, to the list of accounts
 * already existing for this receiver 
 */
 
public void addAccounts(Vector newAccounts) {
	Vector existingAccounts= getAccounts();
	for (int i= 0; i < existingAccounts.size(); i++) {
		newAccounts.addElement(existingAccounts.elementAt(i));
	}	
	setAccounts(newAccounts);		
}
/** 
 * Add the given new credits, to the list of credits
 * already existing for this receiver 
 */
public void addCredits(Vector newCredits) {
	Vector finalSetOfCredits= newCredits;
	Vector existingCredits= getCredits();
	for (int i= 0; i < existingCredits.size(); i++) {
		finalSetOfCredits.addElement(existingCredits.elementAt(i));
	}	
	setCredits(finalSetOfCredits);		
}
/**
 * Create some test-instances which can be used for testing
 * out the application. 
 * Here we create 'basic' customers, i.e. ones with no account
 * or credit information.
 */
 
public static Vector createBasicTestCustomers() {
	Vector customers= new Vector();
	customers.addElement(new Customer("Majmudar","Rupal", Address.createTestAddress()));
	customers.addElement(new Customer("Gamma","Erich", Address.createTestAddress()));
	customers.addElement(new Customer("Madhavan","Sanjay", Address.createTestAddress()));
	customers.addElement(new Customer("Bosshard","Stefan", Address.createTestAddress()));
	customers.addElement(new Customer("Schmid","Marianne", Address.createTestAddress()));
	return customers;
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */
 
public static void createTestAccountsAndCreditsFor(Customer customer) {
	 	// Create some dummy accounts and add them to the customer...
	customer.addAccounts(Account.createTestAccounts());
	 	// Use the available Accounts for creating some dummy credits...
	Vector credits= Credit.createTestCredits(customer.getAccounts());
	customer.addCredits(credits);
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */
 
public static Customer createTestCustomer() {
	Customer customer= getRandomTestCustomer();
	createTestAccountsAndCreditsFor(customer);
	return customer;
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */
 
public static Vector createTestCustomers() {
	Vector customers= createBasicTestCustomers();
	for (int i=0; i < customers.size(); i++) {
		createTestAccountsAndCreditsFor((Customer) customers.elementAt(i));
	}	
	return customers;
}
/**
 * Two customers are equal if they have the same
 * id...
 */
public boolean equals(Object obj) {
	if (obj instanceof Customer)	{
		Customer customerObj= (Customer) obj;
		if (getId() == customerObj.getId()) return true;
	}	
	return false;
}
public Vector getAccounts() {
	return fAccounts;
}
public Address getAddress() {
	return fAddress;
}
public Vector getCredits() {
	return fCredits;
}
public String getFirstName() {
	return fFirstName;
}
public int getId() {
	return fId;
}
public String getLastName() {
	return fLastName;
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */

public static Customer getRandomTestCustomer() {
	Vector customers= createBasicTestCustomers();
	int custPosition= (int) (Math.random() * customers.size());
	return (Customer) customers.elementAt(custPosition);
}
/**
 * Answer the value for the attribute corresponding
 * to the given column-Id. Note: This can also be
 * done using the reflection API.
 */
public Object getValueForAttributeName(String colId) {
	if (colId.equals("LastName")) return fLastName;
	else
		if (colId.equals("FirstName")) return fFirstName;
		else
			if (colId.equals("Address")) return fAddress;
			else return null;
}
public void setAccounts(Vector accounts) {
	fAccounts= accounts;
}
public void setAddress(Address address) {
	fAddress= address;
}
public void setCredits(Vector credits) {
	fCredits= credits;
}
public void setFirstName(String firstName) {
	fFirstName= firstName;
}
public void setId(int id) {
	fId= id;
}
public void setLastName(String lastName) {
	fLastName= lastName;
}
}
