package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.application.ULCIcon;

/**
 * This is the business-specific application class, which interacts
 * with ULC only via a separate adapter class.
 *
 *	A note about the implementation of this class: The Account Type (fType) is 
 * kept as a String instead of	having subclasses for each type of account, for 
 * the sake of keeping this sample simple.
 * 
 */
public class Account implements Cloneable {
	private String fNumber;
	private String fType;		
	private String fCurrency;
	private double fCharges;
	private double fBalance;
	private double fLimit;
	private Vector fCredits;
	
	static String fgCurrencies[]= {"USD", "CHF", "INR", "GBP", "JPY"};
	static String fgAccountTypes[]= {"Savings Account", "Private Account", "Loan Account"};
public Account() {
	fCredits= new Vector();
}
public Account(String number, String currency) {
	this();
	fNumber= number;
	fCurrency= currency;
}
public Account(String number, String type, String currency) {
	this(number, currency);
	fType= type;
}
/**
 * Add the given credit to the receiver's collection of credits.
 */
public void basicAddCredit(Credit credit) {
	getCredits().addElement(credit);
}
public Object clone() {
	try {
		Account accountObj= (Account) super.clone();
		accountObj.setNumber(fNumber);
		accountObj.setType(fType);
		accountObj.setCurrency(fCurrency);
		accountObj.setBalance(fBalance);
		accountObj.setCharges(fCharges);
		accountObj.setLimit(fLimit);
		return accountObj;
	}	
	catch	(CloneNotSupportedException e) {
		System.out.println("Unable to clone Account: " + e);
	}	
	return null;
}
/**
 * Create some test-instances which can be used for testing
 */
public static Vector createBasicTestAccounts() {
	Vector accounts= new Vector();
	String[] ccyList= Account.possibleCurrencies();
	String typeList[]= Account.possibleAccountTypes();
	int nextAccountNumber;
	int nextCurrency;
	for (int i=0; i < 30; i++) {
		nextAccountNumber= (int) (Math.random() * 1000000);
		int nextCurrencyPosition= (int) (Math.random() * ccyList.length);
		int nextTypePosition= (int) (Math.random() * typeList.length);
 		accounts.addElement(new Account(String.valueOf(nextAccountNumber), 
 				typeList[nextTypePosition], String.valueOf(ccyList[nextCurrencyPosition])));
	}	
	return accounts;
}
/**
 * We need an 'initial' account, which is a proper 
 * Account object containing some dummy data (which 
 * can be edited by the user.
 */
public static Account createInitialDummyAccount() {
	return new Account("", "", "");
}
/**
 * Pick a random number ('n') of accounts each time. Note that we do not pick
 * 'n' random elements frm the vector, though - since this is quite likely to
 * lead to duplicate account numbers, which leads to problems in the table...
 */
public static Vector createTestAccounts() {
	Vector allAccounts= createBasicTestAccounts();
	Vector randomAccounts= new Vector();
	int numberOfAccounts= (int) (Math.random() * 12 + 1);
	for (int i=0; i < numberOfAccounts; i++) {
		// int accPosition= (int) (Math.random() * allAccounts.size());
		randomAccounts.addElement((Account) allAccounts.elementAt(i));
	}	
	return randomAccounts;
}
/**
 * Two accounts are equal if they have the same
 * accountNumber.
 */
public boolean equals(Object obj) {
	if (obj instanceof Account) {
		Account accountObj= (Account) obj;
		if (fNumber == accountObj.fNumber) 
			return true;
	}			
	return false;
}
public Vector getCredits() {
	return fCredits;
}
public ULCIcon getIcon() {
	return new ULCIcon(getClass().getResource(getIconName()));
}
/**
 * Depending on the type of account, use a different icon.
 */
public String getIconName() {
	if (fType.equals("Savings Account")) return "green-ball.gif";
	else
		if (fType.equals("Private Account")) return "magenta-ball.gif";
		else 
			if (fType.equals("Loan Account")) return "blue-ball.gif";	
			else return "red-ball.gif"; // this happens when the account type is undefined.
}
public String getNumber() {
	return fNumber;
}
public int getNumberOfCredits() {
	return getCredits().size();
}
public static Account getRandomTestAccount() {
	Vector accounts= createBasicTestAccounts();
	int accPosition= (int) (Math.random() * accounts.size());
	return (Account) accounts.elementAt(accPosition);
}
public String getType() {
	return fType;
}
/**
 * Answer the value for the attribute corresponding
 * to the given column-Id. Note: This can also be
 * done using the reflection API.
 */
public Object getValueForAttributeName(String colId) {
	if (colId.equals("Number")) return fNumber;
	if (colId.equals("Type")) return fType;
	if (colId.equals("Currency")) return fCurrency;
	if (colId.equals("Charges")) return new Double(fCharges);
	if (colId.equals("Balance")) return new Double(fBalance);
	if (colId.equals("Limit")) return new Double(fLimit);	
	if (colId.equals("NumberOfCredits")) 
		return new Integer(getNumberOfCredits());	
	if (colId.equals("Icon")) return getIcon();	
	return null;
}
/**
 * Merge the values from the cloneAccount, into the
 * receiver. This is required in our case when the validation
 * fails, and we need to 'rollback' the account held in the
 * account adapter.
 */
public void mergeWith(Account cloneAccount) {
	setNumber(cloneAccount.fNumber);
	setType(cloneAccount.fType);
	setCurrency(cloneAccount.fCurrency);
	setBalance(cloneAccount.fBalance);
	setCharges(cloneAccount.fCharges);
	setLimit(cloneAccount.fLimit);
}
public static String[] possibleAccountTypes() {
	return fgAccountTypes;
}
public static String[] possibleCurrencies() {
	return fgCurrencies;
}
public void setBalance (double balance) {
	fBalance= balance;
}
public void setCharges (double charges) {
	fCharges= charges;
}
public void setCurrency (String currency) {
	fCurrency= currency;
}
public void setLimit (double limit) {
	fLimit= limit;
}
public void setNumber (String number ) {
	fNumber= number;
}
public void setType (String type) {
	fType= type;
}
/**
 * Set the value for the attribute corresponding
 * to the given column-Id. Note: This can also be
 * done using the reflection API.
 */
/**
 * For now: only the Balance of an account is editable.
 * However, changes can also come from the RowModel-based
 * form, in which case we need to update the receiver's values
 * appropriately.
 */
public void setValueForAttributeName(Object value, String colId) {
	if (colId.equals("Number")) {
		String number = (String) value;
		setNumber(number);
	}
	if (colId.equals("Type")) {
		String type = (String) value;
		setType(type);
	}
	if (colId.equals("Currency")) {
		String ccy = (String) value;
		setCurrency(ccy);
	}
	if (colId.equals("Charges")) {
		try {
			double charges = 0.0;
			if (value != null)
				charges = ((Double) value).doubleValue();
			setCharges(charges);
		}
		catch (NumberFormatException e) {
			//Should never happen, since there is a range validator associated
			// with this column.
		}
	}
	if (colId.equals("Balance")) {
		try {
			double balance = 0.0;
			if (value != null)
				balance = ((Double) value).doubleValue();
			setBalance(balance);
		}
		catch (NumberFormatException e) {
			//Should never happen, since there is a range validator associated
			// with this column.
		}
	}
	if (colId.equals("Limit")) {
		try {
			double limit = 0.0;
			if (value != null)
				limit = ((Double) value).doubleValue();
			setLimit(limit);
		}
		catch (NumberFormatException e) {
			//Should never happen, since there is a range validator associated
			// with this column.
		}
	}
}
}
