package com.ibm.ulc.examples.Browser;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.*;
import com.ibm.ulc.application.*;

class BrowserPane extends ULCList {
	SimpleModel fSimpleModel;
	BrowserPane fNext;
	ULCField fEditor;
	ULCLabel fLabel;
	ULCShell fShell;
	BrowserPane(ULCShell shell, ULCField editor, ULCLabel label, int size, BrowserPane next) {
		super(new SimpleModel(size), 150, 10);
		fLabel= label;
		fEditor= editor;
		fNext= next;
		fShell= shell;
		fSimpleModel= (SimpleModel) fModel;
		updateLabel();
	   	addSelectionChangedListener(new SelectionListener(this));
	}
	void clear() {
		setSelectedIndex(-1);
		fSimpleModel.clear();
		updateLabel();
		if (fNext != null)
			fNext.clear();
	}
	void select(int selection) {
		String s= fSimpleModel.get(selection);
		if (fEditor != null)
			fEditor.setValue(s);
		if (fShell != null)
			fShell.setLabel(s);
		if (fNext != null)
			fNext.set(s);
	}
	void set(String s) {
		setSelectedIndex(-1);
		fSimpleModel.set(s);
		updateLabel();
		if (fNext != null)
			fNext.clear();
	}
	void updateLabel() {
		if (fLabel != null)
			fLabel.setLabel(fSimpleModel.getRowCount() + " items");
	}
}
