package com.ibm.ulc.corba;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */
import java.io.*;
import org.omg.CORBA.*;
import com.ibm.ulc.corba.generated.*;
import com.ibm.ulc.comm.*;


/**
 * An implemention for a ULC Corba servant.
 */
public class UlcCorbaServant extends _UlcCorbaObjectImplBase {
	private String fApplicationName= null;
	private UlcCorbaBasedTransport fTransport= null;

/**
 * UlcCorbaServant constructor.
 */
public UlcCorbaServant() {
	super();
}
public String getApplicationName() {
	return fApplicationName;
}
public UlcTransport getTransport() {
	return fTransport;
}
public void sendAnyBytes(byte[] anyBytes) {
	if (getTransport().isDebugModeOn())
		System.out.println("<UlcCorbaServant.sendAnyBytes()");

	// pass bytes on to transport instance
	fTransport.receiveBytes(anyBytes);
	
	if (getTransport().isDebugModeOn()) {
		System.out.println(">UlcCorbaServant.sendAnyBytes(" + fApplicationName + ")");
		//request.dump(System.out);
	}
}
public void setApplicationName(String name) {
	fApplicationName= name;
}
public void setTransport(UlcCorbaBasedTransport transport) {
	fTransport= transport;
}
}
