package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.io.InputStream;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InterruptedIOException;
import java.io.IOException;
import com.ibm.ulc.util.UlcObject;

/**
 * Encapsulates a request. A request knows its target, method, and arguments.
 *
 * @see IRequestProcessor
 */
public abstract
class Request extends UlcObject {
	/**
	 * Executes the request.
	 */
	abstract public void dispatch();
 	/**
	 * Dumps the contents of a request. For debugging purposes only.
	 */
	public void dump(OutputStream os) {
	}
/**
 * Gets the number of bytes a request will take up when streamed.
 * This is used for debugging and monitoring purposes only.
 */
public int getByteCount() {
	ByteArrayOutputStream os= new ByteArrayOutputStream();
	write(os);
	return os.size();
}
	/**
	 * Gets the name of a request. This is used for debugging purposes
	 * only.
	 */
	public String getName() {
		return "aRequest";
	}
/**
 * Tests if a next request is available on the input stream.
 *
 * Note: This might put back the first character to the reader
 *
 * @return <code>true</code> if available; <code>false</code> otherwise
 * @IOException		Most common will be the InterruptedIOException because the read() timed out
 */
public boolean isAvailable(InputStream is) throws IOException {
	return false;
}
	/**
	 * Reads the request from the given input stream.
	 * @return true when a complete request could be read.
	 */
	public boolean read(InputStream is) {
			return false;
	}
/**
 * Reads the request from the given input stream.
 * @return true when a complete request could be read
 * @return false or throw an exception otherwise.
 */
public boolean readEx(InputStream is) throws IOException {
	return false;
}
	/**
	 * Marshals and writes a request to the given output stream.
	 */
	public void write(OutputStream os) {
	}
/**
 * Marshals and writes a request to the given output stream.
 */
public void writeEx(OutputStream os)
throws InterruptedIOException, IOException {
}
}
