package com.ibm.ulc.comm;

/**
 * Insert the type's description here.
 * Creation date: (10/14/99 4:29:42 PM)
 * @author: Stefan Bosshard, OTI
 */
public interface IChild {
/**
 * Answer the receiver's current parent object. Answer null,  if none is defined.
 *
 * Creation date: (10/14/99 4:31:40 PM)
 * @param parent com.ibm.ulc.comm.IParent
 */
public IParent getParent();
/**
 * Answer true if the receiver is a child of the specified parent object.
 *
 * Creation date: (10/14/99 4:23:23 PM)
 * @param uiComponent com.ibm.ulc.ui.UIComponent
 */
public boolean isChildOf(IParent parent);
/**
 * Reset the receiver's parent to none if it is the specified parent object.
 *
 * Creation date: (10/14/99 4:31:40 PM)
 * @param parent com.ibm.ulc.comm.IParent
 */
void resetParent(IParent parent);
/**
 * Set the specified object as the receiver's parent.
 *
 * Creation date: (10/14/99 4:31:40 PM)
 * @param parent com.ibm.ulc.comm.IParent
 */
void setParent(IParent parent);
}
