package com.ibm.ulc.comm;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.net.*;
import java.io.*;

/**
 * A default implementation for the ISocketFactory interface.
 * Creates standard Sockets and ServerSockets.
 */
public class DefaultSocketFactory implements ISocketFactory {
/**
 * createServerSocket method comment.
 */
public ServerSocket createServerSocket(Server server, int port) throws IOException {
	return new ServerSocket(port);
}
/**
 * createSocket method comment.
 */
public Socket createSocket(String urlString)
throws UnknownHostException, IOException {

	// make sure hostnames work for applets:
	// convert real name to "localhost"
	String host= mapHost(UlcConnection.getHostFromUrlString(urlString));
	int port= UlcConnection.getPortFromUrlString(urlString);
	if (port == UlcConnection.INVALIDPORT)
		port= com.ibm.ulc.comm.Common.SERVER_PORT;

	return new Socket(host,port);
}
	String mapHost(String hostToMap) {
		// Convert real name to something acceptable to Web browsers if necessary,
		// i.e. if host is addressing the local machine.
		// (acceptable to Web browsers: "localhost", "127.0.0.1")
		String host= hostToMap;
		try {
			InetAddress localAddr= InetAddress.getLocalHost();
			if (hostToMap.equals(localAddr.getHostName())
				 || hostToMap.equals(localAddr.getHostAddress()))
				host= UlcConnection.getLocalHost();   // ip address or host name 
		} catch (UnknownHostException uhe) {
			System.out.println("@@@@@ DefaultSocketFactory.mapHost(): cannot get local host!?");
			host = "127.0.0.1";
		}

		return host;
	}
}
