package com.ibm.ulc.base;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * Implements all static constants required by the ULC application and UI Engine.
 */

public interface IDefaults {
	/**
	 * Constant used for notification policy which means that any changes in the form field
	 * are immediately reported back to the application.
	 */
	public static final int FORM_NOTIFICATION_IMMEDIATE = 0;
	/**
	 * Constant used for notification policy which means that any changes in the form field
	 * are reported back to the application on focus changes.
	 */
	public static final int FORM_NOTIFICATION_ON_FOCUS_CHANGE = 1;
	/**
	 * Constant used for notification policy which means that any changes in the form field
	 * have to be explicitely requested.
	 */
	public static final int FORM_NOTIFICATION_ON_REQUEST = 2;

	//------------------------------------------------------------------------------------

	/**
	 * Specify that if the table is resized the columns should not be resized.
	 */
	public static final int TABLE_AUTO_RESIZE_OFF = 0;
	/**
	 * Specify that if the table is resized only the last column should be resized.
	 */
	public static final int TABLE_AUTO_RESIZE_LAST_COLUMN = 1;
	/**
	 * Specify that if the table is resized all columns should be resized.
	 */
	public static final int TABLE_AUTO_RESIZE_ALL_COLUMNS = 2;

	//------------------------------------------------------------------------------------

	/**
	 * Constant used for update policy which means that changes done to a
	 * Table cell (via direct editing) are reported back to the application 
	 * on focus change from that cell.
	 */
	public static final int TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE = 1;
	/**
	 * Constant used for update policy which means that changes done to a
	 * Table cell (via direct editing) are reported back to the application 
	 * only when requested by the application.
	 */
	public static final int TABLE_EDIT_UPDATE_ON_REQUEST = 2;
	/**
	 * Constant used for update policy which means that changes done to a
	 * Table cell (via direct editing) are reported back to the application 
	 * when a different row starts being edited.
	 */
	public static final int TABLE_EDIT_UPDATE_ON_ROW_CHANGE = 3;

	//------------------------------------------------------------------------------------

	/**
	 * An unspecified change has occurred in the ULCFormModel. 
	 */
	public static final int FORM_MODEL_UNSPECIFIED = 0;
	/**
	 * The ULCFormModel is no longer valid
	 */
	public static final int FORM_MODEL_INVALID = 1;
	/**
	 * The ULCFormModel data has changed refresh the data once again.
	 */
	public static final int FORM_MODEL_CHANGED = 2;
	/**
	 * The UIFormModel is about to save its input.
	 */
	public static final int FORM_MODEL_ABOUT_TO_SAVE = 3;

	//------------------------------------------------------------------------------------

	/**
	 * Constant used for selection policy for lists (i.e. List and Table widgets).
	 * Allow only one item in the list to be selected.
	 */
	public static final int LIST_SINGLE_SELECTION = 0;
	/**
	 * Constant used for selection policy for lists (i.e. List and Table widgets).
	 * Allow only a single interval (i.e. one set of items in sequence) to be selected.
	 */
	public static final int LIST_SINGLE_INTERVAL_SELECTION = 1;
	/**
	 * Constant used for selection policy for lists (i.e. List and Table widgets).
	 * Allow multiple intervals to be selected.
	 */
	public static final int LIST_MULTIPLE_INTERVAL_SELECTION = 2;

	//------------------------------------------------------------------------------------

	/**
	 * Contents in the ULCTableModel have changed. 
	 */
	public static final int TABLE_MODEL_CONTENTS_CHANGED = 0;
	/**
	 * Rows have been added to the ULCTableModel. 
	 */
	public static final int TABLE_MODEL_ROWS_ADDED = 1;
	/**
	 * Rows have been removed from the ULCTableModel. 
	 */
	public static final int TABLE_MODEL_ROWS_REMOVED = 2;
	/**
	 * Rows have been changed in the ULCTableModel. 
	 */
	public static final int TABLE_MODEL_ROWS_CHANGED = 3;
	/**
	 * A cell has been changed in the ULCTableModel. 
	 */
	public static final int TABLE_MODEL_CELL_CHANGED = 4;

	//------------------------------------------------------------------------------------	

	/**
	 * Constant used for selection policy for Tree widgets.
	 * Allow only one item in the list to be selected.
	 */
	public static final int TREE_SINGLE_SELECTION = 1;
	/**
	 * Constant used for selection policy for Tree widgets.
	 * Allow only a single interval (i.e. one set of items in sequence) to be selected.
	 */
	public static final int TREE_CONTIGUOUS_SELECTION = 2;
	/**
	 * Constant used for selection policy for Tree widgets.
	 * Allow multiple intervals to be selected.
	 */
	public static final int TREE_DISCONTIGUOUS_SELECTION = 4;

	//------------------------------------------------------------------------------------

	/**
	 * Constant used for exception reason in UlcTransportException.
	 * Default: unknown reason.
	 */
	public static final int TRANSPORT_EX_UNKNOWN_REASON = 0;
	/**
	 * Constant used for exception reason in UlcTransportException.
	 * Exception occurred during initialization of connection.
	 */
	public static final int TRANSPORT_EX_INIT_CONNECTION_EXCEPTION = 1;
	/**
	 * Constant used for exception reason in UlcTransportException.
	 * Error occurred during initialization of connection.
	 */
	public static final int TRANSPORT_EX_INIT_CONNECTION_ERROR = 2;
	/**
	 * Constant used for exception reason in UlcTransportException.
	 * Problem occurred while connection was running.
	 */
	public static final int TRANSPORT_EX_CONNECTION_INTERRUPTED = 10;
	/**
	 * Constant used for exception reason in UlcTransportException.
	 * Exception occurred during initialization of server.
	 */
	public static final int TRANSPORT_EX_INIT_SERVER_EXCEPTION = 20;

	//------ BOX LAYOUT ALIGNMENT CONSTANTS ------------------------------------

	/**
	 * Constant used for horizontal and vertical expand layout
	 */
	public static final String BOX_EXPAND_EXPAND = "ee";
	/**
	 * Constant used for horizontal expand and anchor vertically to top
	 */
	public static final String BOX_EXPAND_TOP = "et";
	/**
	 * Constant used for horizontal expand and anchor vertically to center
	 */
	public static final String BOX_EXPAND_CENTER = "ec";
	/**
	 * Constant used for horizontal expand and anchor vertically to bottom
	 */
	public static final String BOX_EXPAND_BOTTOM = "eb";
	/**
	 * Constant used for anchor horizontally left and vertical expand 
	 */
	public static final String BOX_LEFT_EXPAND = "le";
	/**
	 * Constant used for anchor horizontally left and anchor vertically to top
	 */
	public static final String BOX_LEFT_TOP = "lt";
	/**
	 * Constant used for anchor horizontally left and anchor vertically to center
	 */
	public static final String BOX_LEFT_CENTER = "lc";
	/**
	 * Constant used for anchor horizontally left and anchor vertically to bottom
	 */
	public static final String BOX_LEFT_BOTTOM = "lb";
	/**
	 * Constant used for anchor horizontally center and vertically expand
	 */
	public static final String BOX_CENTER_EXPAND = "ce";
	/**
	 * Constant used for anchor horizontally center and anchor vertically to top
	 */
	public static final String BOX_CENTER_TOP = "ct";
	/**
	 * Constant used for anchor horizontally center and anchor vertically to center
	 */
	public static final String BOX_CENTER_CENTER = "cc";
	/**
	 * Constant used for anchor horizontally center and anchor vertically to bottom
	 */
	public static final String BOX_CENTER_BOTTOM = "cb";
	/**
	 * Constant used for anchor horizontally right and vertically expand
	 */
	public static final String BOX_RIGHT_EXPAND = "re";
	/**
	 * Constant used for anchor horizontally right and anchor vertically to top
	 */
	public static final String BOX_RIGHT_TOP = "rt";
	/**
	 * Constant used for anchor horizontally right and anchor vertically to center
	 */
	public static final String BOX_RIGHT_CENTER = "rc";
	/**
	 * Constant used for anchor horizontally right and anchor vertically to bottom
	 */
	public static final String BOX_RIGHT_BOTTOM = "rb";

	//------ ORIENTATION CONSTANTS ------------------------------------
	/** 
	 * Box-orientation constants used to specify a position.
	 */
	public static final int BOX_CENTER = 0;
	public static final int BOX_TOP = 1;
	public static final int BOX_LEFT = 2;
	public static final int BOX_BOTTOM = 3;
	public static final int BOX_RIGHT = 4;



	//------ ULC FILE CONSTANTS ------------------------------------
	/**
	 * File Dialog Types
	 */
	public static final int FILE_OPEN_DIALOG = 0;
	public static final int FILE_SAVE_DIALOG = 1;
	public static final int FILE_CUSTOM_DIALOG = 2;

	/**
	 * File Dialog Return Values
	 */
	public static final int FILE_CANCEL_OPTION = 1;
	public static final int FILE_APPROVE_OPTION = 0;
	public static final int FILE_ERROR_OPTION = -1;

	/**
	 * File Selection Mode
	 */
	public static final int FILE_FILES_ONLY = 0;
	public static final int FILE_DIRECTORIES_ONLY = 1;
	public static final int FILE_FILES_AND_DIRECTORIES = 2;

	//------ MANDATORY FIELDS CONSTANTS ------------------------------------
	/**
	 *  The background color signals a mandatory field.
	 */
	public static final int MANDATORY_STYLE_BACKGROUND = 0;
	/**
	 *  The border signals a mandatory field.
	 */
	public static final int MANDATORY_STYLE_BORDERED = 1;
	//------ MNEMONIC CHARACTER INDICATOR ------------------------------------
	/**
	 *  The special character that indicates that the next character should be treated as the mnemonic.
	 * 	The special character itself is not displayed.
	 */
	public static final char MNEMONIC_INDICATOR = '~';

	// --------- ULC TRIGGER CONSTANTS ---------------------------------------
	/**
	 *  When triggerred target all shells within the current ULCApplication.
	 */
	public static int TRIGGER_ALL_SHELLS = 0;
	/**
	 *  When triggerred target the owning widgets shell.
	 */
	public static int TRIGGER_SHELL = 1;
	/**
	 *  When triggerred target the owning widget.
	 */
	public static int TRIGGER_WIDGET = 2;
	/**
	 *  When triggerred target all widgets that have been explicitly added to the Trigger as children.
	 */
	public static int TRIGGER_CHILD_WIDGETS = 3;
	/**
	 *  User defined trigger depends on the actual trigger implementation default is do nothing.
	 */
	public static int TRIGGER_USER_DEFINED = 4;
	/**
	 *  Trigger is activated on action events.
	 */
	public static int TRIGGER_ON_ACTION = 1;
	/**
	 *  Trigger is activated on selection events.
	 */
	public static int TRIGGER_ON_SELECTION = 2;
	/**
	 *  Trigger is activated on action and selection events.
	 */
	public static int TRIGGER_ON_ACTION_AND_SELECTION = 3;

	// --------- ULC SCROLLBAR CONSTANTS ---------------------------------------
	/**
	 * Specifies that horizontal/vertical scrollbar should be shown
	 * only when the size of the child exceeds the size of the scrollpane
	 * in the horizontal/vertical dimension.
	 */
	public static final int SCROLLBARS_AS_NEEDED= 0;

	/**
	 * Specifies that horizontal and vertical scrollbars should always be
	 * shown regardless of the respective sizes of the scrollpane and child.
	 */
	public static final int SCROLLBARS_ALWAYS= 1;

	/**
	 * Specifies that horizontal and vertical scrollbars should never be shown
	 * regardless of the respective sizes of the scrollpane and child.
	 */
	public static final int SCROLLBARS_NEVER= 2;
	// --------- ULC TREETABLE CONSTANTS ---------------------------------------
	/**
	 * Specifies the magic first column attribute name
	 */
	public static final String TREETABLE_FIRST_COLUMN_ATTRIBUTE_NAME= "ulcFirstColumnAttr";
	// --------- ULC MISC CONSTANTS ---------------------------------------
	/**
	 * Specifies the minimal version of the needed JVM
	 */
	public static final String MIN_JVM_VERSION= "1.2";
}
