package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import java.util.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.base.*;

/**
 * UlcTableRow is a row information object private to ULCDefaultItemList
 */
class UlcTableRow extends UlcObject {
	/**
	 * the collection of attributes already uploaded to the UI
	 */
	private String[] fAttributesUploaded = null;
	/**
	 * Indicates whether the receiver has been uploaded to the UI already
	 * @serial	 
	 */
	private boolean fUploaded = false;
	/**
	 * the Oid of the actual row
	 * @serial	 
	 */
	private int fOid = -1;
/**
 * Constructs an instance with the row identifier oid
 */
protected UlcTableRow(int oid) {
	fOid = oid;
}
/**
 * Store all attributes requested in a new Anything
 *
 * Only attriubutes included in <code>attributes</code> that have not previously been uploaded are
 * uploaded. If no attributes need upload, the receiver will answer an empty <code>Anything</code>.
 */
protected Anything attributesForUpload(ULCTableModel model, String[] attributes) {
	Anything answer = new Anything();
	Anything values = new Anything();
	if (getOid() >= 0) {
		fUploaded = true;
		for (int i = 0; i < attributes.length; i++) {
			values.put(attributes[i], model.convert(model.fContext, model.getValueAtRowId(attributes[i], getOid())));
		}
		if (values.size() > 0) {
			answer.put("oid", getOid());
			answer.put("a", values);
		}
	}
	return answer;
}
/**
 * Answer the receiver's row identifier
 */
protected int getOid() {
	return fOid;
}
/**
 * answer true if @attributeName has not been uploaded previously.
 * mark the attribute as uploaded if it was not uploaded already.
 * else answer false.
 */
private boolean requestToUploadAttribute(String attributeName) {
return true;
}
/**
 * answer true, if at least some of the attributes contained in @attributes have been uploaded.
 * if @attributes is null, and the receiver has been previously uploaded at least partially, answer true
 *
 * @param	attributes		the list of attributes of which at least should have been uploaded already
 */
protected boolean shouldRefreshUi(String[] attributes) {
	return true;
}
}
