package com.ibm.ulc.application;

/**
 * A ULCTreeColumn represents a column in a ULCTreeTable, which is rendered internally
 * using the JTree widget. As a result, the renderer cannot be explicitly set on this
 * receiver.  
 */
public class ULCTreeColumn extends ULCColumn {
/**
 * Construct a new ULCTreeColumn
 */
public ULCTreeColumn() {
	super();
}
/**
 * Construct a new ULCTreeColumn with the given attribute name.
 *
 * @param attributeName 	String	The name of the attribute to be displayed in the receiver.
 */
public ULCTreeColumn(String attributeName) {
	super(attributeName);
}
/**
 * Construct a new ULCTreeColumn with the given attribute name and validator.
 *
 * @param attributeName 	String		The name of the attribute to be displayed in the receiver.
 * @param width				int			The width of the receiver in pixels
 */
public ULCTreeColumn(String attributeName, int width) {
	super(attributeName, width);
}
/**
 * Construct a new ULCTreeColumn with the given attribute name, width and validator.
 *
 * @param attributeName 	String		The name of the attribute to be displayed in the receiver.
 * @param datatype			IDateType	The validator to be used when editing the receiver.
 * @param width				int			The width of the receiver in pixels
 */
public ULCTreeColumn(String attributeName, int width, IDataType datatype) {
	super(attributeName, width, datatype);
}
/**
 * Construct a new ULCTreeColumn with the given attribute name and validator.
 *
 * @param attributeName 	String		The name of the attribute to be displayed in the receiver.
 * @param datatype			IDateType	The validator to be used when editing the receiver.
 */
public ULCTreeColumn(String attributeName, IDataType datatype) {
	super(attributeName, datatype);
}
/**
 * Construct a new ULCTreeColumn with the given attribute name and validator.
 *
 * @param attributeName 	String		The name of the attribute to be displayed in the receiver.
 * @param headerValue 		String		The label to display in the receiver's header.
 */
public ULCTreeColumn(String attributeName, String headerValue) {
	super(attributeName, headerValue);
}
/**
 * Construct a new ULCTreeColumn with the given parameters
 *
 * @param attributeName 	String		The name of the attribute to be displayed in the receiver.
 * @param headerValue 		String		The label to display in the receiver's header.
 * @param width				int			The width of the receiver in pixels
 */
public ULCTreeColumn(String attributeName, String headerValue, int width) {
	super(attributeName, headerValue, width);
}
/**
 * Construct a new ULCTreeColumn with the given parameters.
 *
 * @param attributeName 	String		The name of the attribute to be displayed in the receiver.
 * @param headerValue 		String		The label to display in the receiver's header.
 * @param width				int			The width of the receiver in pixels
 * @param datatype			IDateType	The validator to be used when editing the receiver.
 */
public ULCTreeColumn(String attributeName, String headerValue, int width, IDataType datatype) {
	super(attributeName, headerValue, width, datatype);
}
/**
 * Sets the ULCComponent that is configured as my renderer. One may not set the renderer, since
 * for this receiver, the renderer is always internally set to the JTree widget.
 *
 * @param ULCComponent The widget that is used as my renderer
 */
public void setRenderer(ULCComponent renderer) {
	trouble("setRenderer", "is not allowed for TreeColumns because they have an immutable renderer on the UI");
}
/**
 * returns a logical name for this component.
 * This name is used to locate the other half of this object in the UI Engine.
 * The default implementation extracts the name from the class name by stripping
 * off the package name and an optional prefix "ULC".
 * widgets that are not found in the com.ibm.ulc.ui.swing package should
 * override this method to return the fully qualified class name of the UI class
 * eg: com.ibm.ulc.ui.UIApplication
 *
 * @return The Logical name for this component.
 */
protected String typeString() {
	return "com.ibm.ulc.ui.lists.UITreeColumn";
}
}
