package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.util.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.Assert;
import com.ibm.ulc.comm.ORBConnection;

/**
 * This widget is used for representing an hierarchical relationship
 * between objects. The tree has a 'root  node' which has 'children';
 * each child in turn may have children of it's own. 
 * The tree is also associated with an adapter (ULCTreeModel) for mapping
 * onto the underlying hierarchical business objects. 
 * Note that the business objects do not need to be modelled as 'nodes'
 * in order to be used in the tree - for example, a Directory structure 
 * where a directory contains other directories and files, can also be
 * displayed easily as a tree.
 *
 * Also, a tree can no longer have columns associated with it. For using
 * columns with a tree, use the TreeTable widget.
 *
 * While this widget is not yet deprecated, it is recommended that
 * the ULCTreeTable widget be used instead. The latter supports additional
 * columns, and is also more flexible in how the data is accessed (using
 * pluggable hierarchy adapters etc.).
 *
 * @see ULCTreeTable
 * @see ULCTreeModel
 * @see ULCColumn 
 */
public class ULCTree extends ULCTreeTable {
/**
 * Constructs a new ULCTree.
 */
public ULCTree() {
	super();
}
/**
 * Constructs a new ULCTree which displays values from the given ULCTreeModel.
 *
 * @param model 	The ULCTreeModel that serves as the data source.
 */
public ULCTree(ULCTreeModel model) {
	this(model, TREE_SINGLE_SELECTION, -1);
}
/**
 * Constructs a new ULCTree which displays values from the given ULCTreeModel.
 *
 * @param model 			The ULCTreeModel that serves as the data source.
 * @param selectionMode 	Specifies the selection policy for the tree.
 * 							<pre>
 * 							Valid values are :
 *								TREE_SINGLE_SELECTION
 * 								TREE_CONTIGUOUS_SELECTION
 *								TREE_DISCONTIGUOUS_SELECTION
 * 							</pre>
 */
public ULCTree(ULCTreeModel model, int selectionMode) {
	this(model, selectionMode, -1);
}
/**
 * Constructs a new ULCTree which displays values from the given ULCTreeModel.
 *
 * @param model 			The ULCTreeModel that serves as the data source.
 * @param selectionMode 	Specifies the selection policy for the tree.
 * 							<pre>
 * 							Valid values are :
 *								TREE_SINGLE_SELECTION
 * 								TREE_CONTIGUOUS_SELECTION
 *								TREE_DISCONTIGUOUS_SELECTION
 * @param rowHeight		The height specified as number of visible rows for this treeTable.
 * 							</pre>
 */
public ULCTree(ULCTreeModel model, int selectionMode, int rowHeight) {
	super(model, selectionMode, rowHeight);
}
/**
 * Appends a ULCColumn at the right end of the ULCTree.
 *
 * @param column	The <code>ULCColumn</code> to be added as the last column.
 *
 * @ deprecated with R3 .0	 Tree with columns is now supported in ULCTreeTable
 */
public void addColumn(ULCColumn column) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Constructs a new ULCColumn for the specified key and appends it at the right end of the ULCTree.
 *
 * @param key	The <code>String</code> columnId for the new column
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */
public void addColumn(String key) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Constructs a new ULCColumn for the specified key and appends it at the right end of the ULCTree.
 *
 * @param colId	The <code>String</code> key to be used to retrieve values from the ULCTreeModel.
 * @param label	The <code>String</code> label for this column.
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */
public void addColumn(String colId, String label) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Constructs a new ULCColumn for the specified key and appends it at the right end of the ULCTree.
 *
 * @param colId	The <code>String</code> key to be used to retrieve values from the ULCTreeModel.
 * @param label	The <code>String</code> label for this column.
 * @param width The width of the column.
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */
public void addColumn(String colId, String label, int width) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Constructs a new ULCColumn for the specified key and appends it at the right end of the ULCTree.
 *
 * @param 	colId	
 *			The <code>String</code> key to be used to retrieve values
 *			from the ULCTreeModel.
 * @param 	label	
 *			The <code>String</code> label for this column.
 * @param width
 * 			The <code>int</code> width of this column.
 * @param 	editable 
 *			If true allow the column being added to allow direct editing.
 * @param 	renderer
 *			The <code>ULCComponent</code> that will be used to render values in this column.
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */
public void addColumn(String colId, String label, int width, boolean editable, ULCComponent renderer) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Constructs a new ULCColumn for the specified key and appends it at the right end of the ULCTree.
 *
 * @param 	colId	
 *			The <code>String</code> key to be used to retrieve values
 *			from the ULCTreeModel.
 * @param 	label	
 *			The <code>String</code> label for this column.
 * @param 	renderer 
 *			The <code>ULCComponent</code> that will be used to render the 
 *			values in this column.
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */
public void addColumn(String colId, String label, ULCComponent renderer) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Constructs a new ULCColumn for the specified key and appends it at the right end of the ULCTree.
 *
 * @param 	colId	
 *			The <code>String</code> key to be used to retrieve values
 *			from the ULCTreeModel.
 * @param 	label	
 *			The <code>String</code> label for this column.
 * @param 	editable 
 *			If true allow the column being added to allow direct editing.
 * @param 	renderer
 *			The <code>ULCComponent</code> that will be used to render values in this column.
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */

public void addColumn(String colId, String label, boolean editable, ULCComponent renderer) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Appends ULCColumns at the right end of the ULCTree.
 *
 * @param 	columns
 *			The <code>Vector</code> containing a list of <code>ULCColumn</code> objects.
 *
 * @ deprecated with R3 .0	 Tree with columns is now supported in ULCTreeTable
 */
public void addColumns(Vector columns) {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Add all table attributes that should be preloaded to the UI to the specified Vector.
 * This receiver has no table attributes to preload.
 *
 * @param vectorOfPreloadAttributes	Vector	into which the receiver adds the
 *											table attributes it needs to preload.
 *
 * Do nothing for this receiver, since it can contain no additional attributes.
 */
public void addPreloadTableAttributesInto(Vector vectorOfPreloadAttributes) {
}
/**
 * Returns the current list of all ULCColumns in this tree.
 *
 * @return	The <code>Vector</code> containing a list of <code>ULCColumn</code> objects.
 *
 * @deprecated with R3.0		Tree with columns is now supported in ULCTreeTable
 */
public Vector getColumns() {
	trouble("addColumn", "ULCTree no longer supports columns. Use TreeTable instead");
	return new Vector();
}
/**
 * Removes the specified <code>ULCColumn</code> from this tree.
 *
 * @param column The <code>ULCColumn</code> to be removed.
 * @ deprecated with R3 .0	 Tree with columns is now supported in ULCTreeTable
 */
public void removeColumn(ULCColumn column) {
	trouble("removeColumn", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Removes all the specified ULCColumns from this tree.
 *
 * @param columns The <code>Vector</code> containing a list of <code>ULCColumn</code> objects.
 * @ deprecated with R3 .0	 Tree with columns is now supported in ULCTreeTable
 */
public void removeColumns(Vector columns) {
	trouble("removeColumns", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Sets the current list of all ULCColumns in this tree.
 *
 * @param	The <code>Vector</code> containing a list of <code>ULCColumn</code> objects.
 * @ deprecated with R3 .0	 Tree with columns is now supported in ULCTreeTable
 */
public void setColumns(Vector columns) {
	trouble("setColumns", "ULCTree no longer supports columns. Use TreeTable instead");
}
/**
 * Return the fully qualified class path to my proxy class in the UI.
 *
 */
public String typeString() {
	return "com.ibm.ulc.ui.lists.UITree";
}
}
