package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import java.util.*;
/**
 * The ULCToolBar implements a floatable widget that allows <code>ULCButton</code> and
 * <code>ULCSeparator's</code> to be added to it.
 */
public class ULCToolBar extends ULCComponent {
	/**
	 * If true the ToolBar can be dragged out of its parent widget 
	 * and placed on the desktop.
	 * @serial	 	 
	 */
	protected boolean fFloatable = true;
	/**
	 * If true the ToolBar will be decorated with a border.
	 * @serial	 	 
	 */
	protected boolean fBorderPainted = true;
	/**
	 * If true the ToolBar will be built oriented vertically. Default is false.
	 * @serial	 	 
	 */
	protected boolean fVertical = false;
	/**
	 * The margin between the ToolBar and its buttons. Default is 1.
	 * @serial	 	 
	 */
	protected int fMargin = 1;
	/**
	 * The margin for all <code>ULCButton</code> widgets added to this Toolbar. Default is 1.
	 * @serial	 	 
	 */
	protected int fButtonMargin = 1;
/**
 * Default constructor for ULCToolBar.
 */
public ULCToolBar() {
	super();
}
/**
 * Construct an ULCToolBar with the specified margin and button margin.
 *
 * @param margin 		The <code>int</code> margin between the Toolbar and its buttons.
 * @param buttonMargin 	The <code>int</code> margin for all Buttons added to this Toolbar.
 */
public ULCToolBar(int margin, int buttonMargin) {
	this(true, true, margin, buttonMargin);
}
/**
 * Construct a ULCToolBar with the specified label.
 *
 * @param label The label for the Toolbar.
 */
public ULCToolBar(String label) {
	super(label);
}
/**
 * Construct an ULCToolBar with the specified label and parameters.
 *
 * @param label		 	The label to be used in the ToolBar's title.
 * @param floatable 	If true the Toolbar can be dragged out of its parent.
 * @param borderPainted If true the Toolbar will be decorated with a Border.
 * @param vertical 		If true the ToolBar will be oriented vertically.
 * @param margin 		The <code>int</code> margin between the Toolbar and its buttons.
 * @param buttonMargin 	The <code>int</code> margin for all Buttons added to this Toolbar.
 */
public ULCToolBar(String label, boolean floatable, boolean borderPainted, boolean vertical, int margin, int buttonMargin) {
	super(label);
	fFloatable = floatable;
	fBorderPainted = borderPainted;
	fMargin = margin;
	fButtonMargin = buttonMargin;
	fVertical = vertical;
}
/**
 * Construct an ULCToolBar with the specified label and parameters.
 *
 * @param floatable 	If true the Toolbar can be dragged out of its parent.
 * @param borderPainted If true the Toolbar will be decorated with a Border.
 * @param margin 		The <code>int</code> margin between the Toolbar and its buttons.
 * @param buttonMargin 	The <code>int</code> margin for all Buttons added to this Toolbar.
 */
public ULCToolBar(boolean floatable, boolean borderPainted, int margin, int buttonMargin) {
	this(floatable, borderPainted, false, margin, buttonMargin);
}
/**
 * Construct an ULCToolBar with the specified parameters.
 *
 * @param floatable 	If true the Toolbar can be dragged out of its parent.
 * @param borderPainted If true the Toolbar will be decorated with a Border.
 * @param vertical 		If true the ToolBar will be oriented vertically.
 * @param margin 		The <code>int</code> margin between the Toolbar and its buttons.
 * @param buttonMargin 	The <code>int</code> margin for all Buttons added to this Toolbar.
 */

public ULCToolBar(boolean floatable, boolean borderPainted, boolean vertical, int margin, int buttonMargin) {
	super("Toolbar");
	fFloatable = floatable;
	fBorderPainted = borderPainted;
	fMargin = margin;
	fButtonMargin = buttonMargin;
	fVertical = vertical;
}
/**
 * Adds the <code>ULCButton</code> to the ToolBars contents.
 *
 * @param button  The <code>ULCButton</code> that will be added.
 */
public void add(ULCButton button) {
	internalAdd(button);
}
/**
 * Adds the <code>ULCSeparator</code> to the ToolBars contents.
 *
 * @param separator  The <code>ULCSeparator</code> that will be added.
 */
public void add(ULCSeparator separator) {
	internalAdd(separator);
}
/**
 * Creates a new ULCSeparator and appends it to the end of this menu.
 */
public void addSeparator() {
	internalAdd(new ULCSeparator());
}
/**
 * Gets the margin for all buttons added to this ULCToolBar.
 *
 * @return buttonMargin 	The margin in pixels for all <code>ULCButtons</code> added.
 */
public int getButtonMargin() {
	return fButtonMargin;
}
/**
 * Gets the collection of <code>ULCButtons</code> in this toolBar.
 *
 * @return The <code>Vector</code> containing <code>ULCButtons</code>.
 * @deprecated in R2.0 
 * @see #getComponents
 */
public Vector getButtons() {
	Vector components = new Vector();
	Vector v = getComponents();
	for (int i = 0; i < v.size(); i++) {
		Object next = v.elementAt(i);
		if (next instanceof ULCButton)
			components.addElement(next);
	}
	return components;
}
/**
 * Return the collection of Buttons and Separators in this toolBar.
 *
 * @return The <code>Vector</code> containing collection of <code>ULCComponent</code>.
 */
public Vector getComponents() {
	return internalGetComponents();
}
/**
 * Gets the margin between the ToolBar and its contents.
 *
 * @return margin 	The margin in pixels between the Toolbar and its buttons.
 */
public int getMargin() {
	return fMargin;
}
/**
 * Gets the collection of <code>ULCSeparators</code> in this toolBar.
 *
 * @return The <code>Vector</code> containing <code>ULCSeparators</code>.
 * @deprecated in R2.0 
 * @see #getComponents
 */
public Vector getSeparators() {
	Vector components = new Vector();
	Vector v = getComponents();
	for (int i = 0; i < v.size(); i++) {
		Object next = v.elementAt(i);
		if (next instanceof ULCSeparator)
			components.addElement(next);
	}
	return components;
}
/**
 * Returns true if painting of the border is enabled for the ULCToolBar.
 *
 * @return borderPainted 	If true the border is painted.
 */
public boolean isBorderPainted() {
	return fBorderPainted;
}
/**
 * Returns true if the ULCToolBar can be dragged out of its parent.
 *
 * @return floatable 	If true allows the ToolBar to be floatable.
 */
public boolean isFloatable() {
	return fFloatable;
}
/**
 * Returns true if the ULCToolBar orientation is vertical
 *
 * @return boolean 	If true the ToolBar is oriented vertically
 */
public boolean isVertical() {
	return fVertical;
}
/**
 * Removes the <code>ULCButton</code> from the ToolBars contents.
 *
 * @param button  The <code>ULCButton</code> that will be removed.
 */
public void remove(ULCButton button) {
	internalRemove(button);
}
/**
 * Removes the <code>ULCSeparator</code> from the ToolBars contents.
 *
 * @param separator  The <code>ULCSeparator</code> that will be removed.
 */
public void remove(ULCSeparator separator) {
	internalRemove(separator);
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fVertical)
		a.put("v", fVertical);
	if (fMargin != 1)
		a.put("m", fMargin);
	if (fButtonMargin != 1)
		a.put("bm", fButtonMargin);
	if (!fFloatable)
		a.put("floatable", fFloatable);
	if (!fBorderPainted)
		a.put("borderPainted", fBorderPainted);
}
/**
 * Enables/Disables painting of the border for the ULCToolBar.
 *
 * @param borderPainted 	If true causes the border to be painted.
 */
public void setBorderPainted(boolean borderPainted) {
	if (borderPainted != fBorderPainted) {
		fBorderPainted = borderPainted;
		sendUI("setBorderPainted", new Anything(fBorderPainted));
	}
}
/**
 * Sets the margin for all buttons added to this ULCToolBar.
 *
 * @param buttonMargin 	The margin in pixels for all <code>ULCButtons</code> added.
 */
public void setButtonMargin(int buttonMargin) {
	if (fButtonMargin != buttonMargin) {
		fButtonMargin = buttonMargin;
		sendUI("setButtonMargin", new Anything(fButtonMargin));
	}
}
/**
 * Enables/Disable whether the ULCToolBar can be dragged out of its parent.
 *
 * @param floatable 	If true allows the ToolBar to be floatable.
 */
public void setFloatable(boolean floatable) {
	if (fFloatable != floatable) {
		fFloatable = floatable;
		sendUI("setFloatable", new Anything(fFloatable));
	}
}
/**
 * Sets the margin between the ToolBar and its contents.
 *
 * @param margin 	The margin in pixels between the Toolbar and its buttons.
 */
public void setMargin(int margin) {
	if (fMargin != margin) {
		fMargin = margin;
		sendUI("setMargin", new Anything(fMargin));
	}
}
/**
 * Set true if the ULCToolBar orientation should be vertical
 *
 * @param vertical 	If true the ToolBar is oriented vertically
 */
public void setVertical(boolean vertical) {
	fVertical = vertical;
}
}
